/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.capability;

import endorh.lazulib.capability.ISerializableCapability;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final String DEFAULT_SIDE_TAG = "self";
    private final Map<Capability<? extends ISerializableCapability>, Map<Direction, NonNullSupplier<? extends ISerializableCapability>>> capabilityMap;

    public static Builder create() {
        return new Builder();
    }

    private SerializableCapabilityProvider(Map<Capability<? extends ISerializableCapability>, Map<Direction, NonNullSupplier<? extends ISerializableCapability>>> capabilityMap) {
        this.capabilityMap = capabilityMap;
    }

    @NotNull
    public <C> LazyOptional<C> getCapability(@NotNull Capability<C> cap, @Nullable Direction side) {
        NonNullSupplier<? extends ISerializableCapability> sup;
        Map<Direction, NonNullSupplier<? extends ISerializableCapability>> sub = this.capabilityMap.get(cap);
        if (sub != null && (sup = sub.get(side)) != null) {
            return LazyOptional.of(sup).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.capabilityMap.forEach((c, m) -> {
            CompoundTag capTag = new CompoundTag();
            m.forEach((d, s) -> capTag.m_128365_(d != null ? d.m_7912_() : DEFAULT_SIDE_TAG, (Tag)((ISerializableCapability)s.get()).serializeCapability()));
            tag.m_128365_(c.getName(), (Tag)capTag);
        });
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.capabilityMap.forEach((c, m) -> {
            CompoundTag capTag = tag.m_128469_(c.getName());
            m.forEach((d, s) -> ((ISerializableCapability)s.get()).deserializeCapability(capTag.m_128469_(d != null ? d.m_7912_() : DEFAULT_SIDE_TAG)));
        });
    }

    public static class Builder {
        private final Map<Capability<? extends ISerializableCapability>, Map<Direction, NonNullSupplier<? extends ISerializableCapability>>> capabilityMap = new HashMap<Capability<? extends ISerializableCapability>, Map<Direction, NonNullSupplier<? extends ISerializableCapability>>>();

        private Builder() {
        }

        public <T extends ISerializableCapability> Builder with(Capability<T> capability, @NotNull T instance) {
            return this.with(capability, null, () -> instance);
        }

        public <T extends ISerializableCapability> Builder with(Capability<T> capability, @Nullable Direction side, @NotNull T instance) {
            return this.with(capability, side, () -> instance);
        }

        public <T extends ISerializableCapability> Builder with(Capability<T> capability, NonNullSupplier<T> supplier) {
            this.with(capability, null, supplier);
            return this;
        }

        public <T extends ISerializableCapability> Builder with(Capability<T> capability, @Nullable Direction side, NonNullSupplier<T> supplier) {
            this.capabilityMap.computeIfAbsent(capability, c -> new HashMap()).put(side, supplier);
            return this;
        }

        public SerializableCapabilityProvider build() {
            return new SerializableCapabilityProvider(this.capabilityMap);
        }
    }
}

