/*
 * Decompiled with CFR 0.152.
 */
package endorh.lazulib.animation;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.Mth;

public class Easing {
    private static final float PI = (float)Math.PI;
    private static final float backEaseC1 = 1.70158f;
    private static final float backEaseC2 = 2.5949094f;
    private static final float bounceEaseC1 = 7.5625f;
    private static final float bounceEaseC2 = 2.75f;

    public static float linear(float t) {
        return t;
    }

    public static float sineIn(float t) {
        return 1.0f - Mth.m_14089_((float)(t * (float)Math.PI / 2.0f));
    }

    public static float sineOut(float t) {
        return Mth.m_14031_((float)(t * (float)Math.PI / 2.0f));
    }

    public static float sineInOut(float t) {
        return (1.0f - Mth.m_14089_((float)((float)Math.PI * t))) / 2.0f;
    }

    public static float quadIn(float t) {
        return t * t;
    }

    public static float quadOut(float t) {
        return (2.0f - t) * t;
    }

    public static float quadInOut(float t) {
        return t <= 0.5f ? 2.0f * t * t : t * (t * -2.0f + 4.0f) - 1.0f;
    }

    public static float cubicIn(float t) {
        return t * t * t;
    }

    public static float cubicOut(float t) {
        return t * (t * (t - 3.0f) + 3.0f);
    }

    public static float cubicInOut(float t) {
        return t <= 0.5f ? 4.0f * t * t * t : t * (t * (t * 4.0f - 12.0f) + 12.0f) - 3.0f;
    }

    public static float quartIn(float t) {
        return t * t * t * t;
    }

    public static float quartOut(float t) {
        return t * (t * (t * (-t + 4.0f) - 6.0f) + 4.0f);
    }

    public static float quartInOut(float t) {
        return t <= 0.5f ? 8.0f * t * t * t * t : t * (t * (t * (t * -8.0f + 32.0f) - 48.0f) + 32.0f) - 7.0f;
    }

    public static float quintIn(float t) {
        return t * t * t * t * t;
    }

    public static float quintOut(float t) {
        return t * (t * (t * (t * (t - 5.0f) + 10.0f) - 10.0f) + 5.0f);
    }

    public static float quintInOut(float t) {
        return t <= 0.5f ? 16.0f * t * t * t * t * t : t * (t * (t * (t * (t * 16.0f - 80.0f) + 160.0f) - 160.0f) + 80.0f) - 15.0f;
    }

    public static float expoIn(float t) {
        return t <= 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * (t - 1.0f));
    }

    public static float expoOut(float t) {
        return t >= 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * t);
    }

    public static float expoInOut(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : (t <= 0.5f ? (float)Math.pow(2.0, 20.0f * t - 11.0f) : 1.0f - (float)Math.pow(2.0, -20.0f * t + 9.0f)));
    }

    public static float circIn(float t) {
        return 1.0f - Mth.m_14116_((float)(1.0f - t * t));
    }

    public static float circOut(float t) {
        return Mth.m_14116_((float)(2.0f * t - t * t));
    }

    public static float circInOut(float t) {
        return t <= 0.5f ? (1.0f - Mth.m_14116_((float)(1.0f - 4.0f * t * t))) / 2.0f : (1.0f + Mth.m_14116_((float)(t * (t * -4.0f + 8.0f) - 3.0f))) / 2.0f;
    }

    public static float backIn(float t) {
        return t * t * (t * 2.70158f - 1.70158f);
    }

    public static float backOut(float t) {
        return 1.0f - 2.70158f * (t * (t * (-t + 3.0f) - 3.0f) + 1.0f) + 1.70158f * (t * (t - 2.0f) + 1.0f);
    }

    public static float backInOut(float t) {
        return t <= 0.5f ? 2.0f * t * t * (2.0f * t * 3.5949094f - 2.5949094f) : 1.0f - 2.0f * (t * (t - 2.0f) + 1.0f) * (2.0f * (1.0f - t) * 3.5949094f + 2.5949094f);
    }

    public static float elasticIn(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : (float)Math.pow(2.0, 10.0f * (t - 1.0f)) * Mth.m_14031_((float)((t * 20.0f - 21.5f) * (float)Math.PI / 3.0f)));
    }

    public static float elasticOut(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * t) * Mth.m_14031_((float)((1.5f - t * 20.0f) * (float)Math.PI / 3.0f)));
    }

    public static float elasticInOut(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : (t <= 0.5f ? (float)Math.pow(2.0, 20.0f * t - 11.0f) * Mth.m_14031_((float)((44.5f - t * 80.0f) * (float)Math.PI / 9.0f)) : (float)Math.pow(2.0, 9.0f - 20.0f * t) * Mth.m_14031_((float)((t * 80.0f - 44.5f) * (float)Math.PI / 9.0f))));
    }

    public static float bounceIn(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : 1.0f - Easing.bounceOut(1.0f - t));
    }

    public static float bounceOut(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : (t <= 0.36363637f ? 7.5625f * t * t : (t <= 0.72727275f ? 7.5625f * (t -= 0.54545456f) * t + 0.75f : (t <= 0.90909094f ? 7.5625f * (t -= 0.8181818f) * t + 0.9375f : 7.5625f * (t -= 0.95454544f) * t + 0.984375f))));
    }

    public static float bounceInOut(float t) {
        return t <= 0.0f ? 0.0f : (t >= 1.0f ? 1.0f : (t <= 0.5f ? (1.0f - Easing.bounceOut(1.0f - 2.0f * t)) / 2.0f : (1.0f + Easing.bounceOut(2.0f * t - 1.0f)) / 2.0f));
    }

    public static CubicBezier cubicBezier(float x1, float y1, float x2, float y2) {
        return new CubicBezier(x1, y1, x2, y2);
    }

    public static class CubicBezier
    implements EasingFunction {
        private static final int NEWTON_ITERATIONS = 2;
        private static final float NEWTON_MIN_SLOPE = 0.02f;
        private static final float SUBDIVISION_PRECISION = 1.0E-6f;
        private static final int SUBDIVISION_MAX_ITERATIONS = 8;
        private static final int SAMPLE_TABLE_SIZE = 11;
        private static final float SAMPLE_STEP_SIZE = 0.1f;
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private final float[] sampleValues;

        private CubicBezier(float x1, float y1, float x2, float y2) {
            if (x1 < 0.0f || x1 > 1.0f || x2 < 0.0f || x2 > 1.0f) {
                throw new IllegalArgumentException("Bezier easing function control point x coordinates must be in [0, 1] range");
            }
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            if (x1 != y1 || x2 != y2) {
                this.sampleValues = new float[11];
                this.calcSampleValues();
            } else {
                this.sampleValues = null;
            }
        }

        private void calcSampleValues() {
            for (int i = 0; i < 11; ++i) {
                this.sampleValues[i] = this.calcBezier((float)i * 0.1f, this.x1, this.x2);
            }
        }

        private float A(float p1, float p2) {
            return 1.0f - 3.0f * p2 + 3.0f * p1;
        }

        private float B(float p1, float p2) {
            return 3.0f * p2 - 6.0f * p1;
        }

        private float C(float p1) {
            return 3.0f * p1;
        }

        private float calcBezier(float t, float p1, float p2) {
            return t * (t * (t * this.A(p1, p2) + this.B(p1, p2)) + this.C(p1));
        }

        private float getSlope(float t, float p1, float p2) {
            return t * (t * 3.0f * this.A(p1, p2) + 2.0f * this.B(p1, p2)) + this.C(p1);
        }

        private float getTForX(float x) {
            float next;
            float current;
            float dist;
            float intervalStart;
            float tGuess;
            float initialSlope;
            int currentIndex;
            int lastIndex = 10;
            for (currentIndex = 1; currentIndex < lastIndex && this.sampleValues[currentIndex] <= x; ++currentIndex) {
            }
            if ((initialSlope = this.getSlope(tGuess = (intervalStart = (float)(--currentIndex) * 0.1f) + (dist = (x - (current = this.sampleValues[currentIndex])) / ((next = this.sampleValues[currentIndex + 1]) - current)) * 0.1f, this.x1, this.x2)) >= 0.02f) {
                return this.newtonRaphsonIterate(x, tGuess);
            }
            if (initialSlope == 0.0f) {
                return tGuess;
            }
            return this.binarySubdivide(x, intervalStart, intervalStart + 0.1f);
        }

        private float newtonRaphsonIterate(float x, float tGuess) {
            for (int i = 0; i < 2; ++i) {
                float currentX = this.calcBezier(tGuess, this.x1, this.x2) - x;
                float currentSlope = this.getSlope(tGuess, this.x1, this.x2);
                if (currentSlope == 0.0f) {
                    return tGuess;
                }
                tGuess -= currentX / currentSlope;
            }
            return tGuess;
        }

        private float binarySubdivide(float x, float l, float r) {
            float currentT;
            float currentX;
            int i = 0;
            do {
                if ((currentX = this.calcBezier(currentT = l + (r - l) / 2.0f, this.x1, this.x2) - x) > 0.0f) {
                    r = currentT;
                    continue;
                }
                l = currentT;
            } while (Mth.m_14154_((float)currentX) > 1.0E-6f && ++i < 8);
            return currentT;
        }

        @Override
        public float map(float x) {
            if (this.x1 == this.y1 && this.x2 == this.y2) {
                return x;
            }
            return this.calcBezier(this.getTForX(x), this.y1, this.y2);
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public String toString() {
            return "cubicBezier(" + this.x1 + ", " + this.y1 + ", " + this.x2 + ", " + this.y2 + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CubicBezier that = (CubicBezier)o;
            return Float.compare(that.x1, this.x1) == 0 && Float.compare(that.y1, this.y1) == 0 && Float.compare(that.x2, this.x2) == 0 && Float.compare(that.y2, this.y2) == 0;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2));
        }
    }

    @FunctionalInterface
    public static interface EasingFunction
    extends Function<Float, Float> {
        public static EasingFunction clamped(EasingFunction f) {
            return t -> Mth.m_14036_((float)f.apply(Float.valueOf(t)).floatValue(), (float)0.0f, (float)1.0f);
        }

        public float map(float var1);

        @Override
        default public Float apply(Float t) {
            return Float.valueOf(this.map(t.floatValue()));
        }

        default public EasingFunction clamped() {
            return EasingFunction.clamped(this);
        }
    }
}

