/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors;

import Shadow.shadowed.com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.Choice;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.FinalSymbol;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.GroupRef;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.Node;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.NotSymbol;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.Repeat;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.SymbolSet;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.parsing.dflt.DefaultTreeBuilder;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors.GenerationVisitor;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors.GenerationVisitorBuilder;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Pattern;

public class NotMatchingGenerationVisitor
extends GenerationVisitor {
    private static final Character[] allSymbols = SymbolSet.getAllSymbols();

    public static GenerationVisitorBuilder builder() {
        return new GenerationVisitorBuilder(false);
    }

    public NotMatchingGenerationVisitor(Random random, Map<Integer, String> groupValues, RgxGenProperties properties) {
        super(random, groupValues, properties);
    }

    @Override
    public void visit(SymbolSet node) {
        this.visitSymbolSet(node, SymbolSet::getSymbols);
    }

    protected void visitSymbolSet(SymbolSet node, Function<SymbolSet, Character[]> getSymbols) {
        String pattern = node.getPattern();
        SymbolSet symbolSet = new SymbolSet("[^" + pattern.substring(1), getSymbols.apply(node), SymbolSet.TYPE.NEGATIVE);
        if (!symbolSet.isEmpty()) {
            super.visit(symbolSet);
        }
    }

    @Override
    public void visit(Choice node) {
        StringBuilder groupsBuilder = new StringBuilder();
        StringBuilder valuePrefixBuilder = new StringBuilder();
        this.buildGroupsStringAndValuePrefix(groupsBuilder, valuePrefixBuilder);
        Pattern pattern = Pattern.compile(groupsBuilder + node.getPattern());
        int pos = this.aStringBuilder.length();
        Node[] nodes = node.getNodes();
        do {
            this.aStringBuilder.delete(pos, Integer.MAX_VALUE);
            int i = this.aRandom.nextInt(nodes.length);
            nodes[i].visit(this);
        } while (pattern.matcher(valuePrefixBuilder + this.aStringBuilder.substring(pos)).matches());
    }

    private void buildGroupsStringAndValuePrefix(StringBuilder groupsBuilder, StringBuilder valuePrefixBuilder) {
        int groupValuesUsed = 0;
        int i = 1;
        while (groupValuesUsed < this.aGroupValues.size()) {
            String s = (String)this.aGroupValues.get(i);
            groupsBuilder.append('(');
            if (s != null) {
                groupsBuilder.append(Pattern.quote(s));
                ++groupValuesUsed;
                valuePrefixBuilder.append(s);
            }
            groupsBuilder.append(')');
            ++i;
        }
    }

    @Override
    public void visit(FinalSymbol node) {
        String nodeValue = node.getValue();
        if (nodeValue.isEmpty()) {
            this.aStringBuilder.append(allSymbols[this.aRandom.nextInt(allSymbols.length)]);
        } else {
            StringBuilder builder = new StringBuilder(nodeValue.length());
            do {
                builder.delete(0, Integer.MAX_VALUE);
                nodeValue.chars().map(c -> allSymbols[this.aRandom.nextInt(allSymbols.length)].charValue()).forEachOrdered(c -> builder.append((char)c));
            } while (this.equalsFinalSymbolRandomString(nodeValue, builder.toString()));
            this.aStringBuilder.append((CharSequence)builder);
        }
    }

    protected boolean equalsFinalSymbolRandomString(String s1, String s2) {
        return s1.equals(s2);
    }

    @Override
    public void visit(Repeat node) {
        if (node.getMin() == 0) {
            super.visit(new Repeat(node.getPattern(), node.getNode(), 1, node.getMax()));
        } else {
            super.visit(node);
        }
    }

    @Override
    public void visit(NotSymbol node) {
        DefaultTreeBuilder builder = new DefaultTreeBuilder(node.getPattern());
        Node subNode = builder.get();
        GenerationVisitor generationVisitor = new GenerationVisitor(this.aRandom, this.aGroupValues, this.aProperties);
        subNode.visit(generationVisitor);
        this.aStringBuilder.append(generationVisitor.getString());
    }

    @Override
    public void visit(GroupRef node) {
        FinalSymbol finalSymbol = new FinalSymbol((String)this.aGroupValues.get(node.getIndex()));
        this.visit(finalSymbol);
    }
}

