/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.github.curiousoddman.rgxgen.config;

import Shadow.shadowed.com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import java.util.Objects;
import java.util.Optional;

public enum RgxGenOption {
    INFINITE_PATTERN_REPETITION("generation.infinite.repeat", "100"),
    CASE_INSENSITIVE("matching.case.insensitive", "false");

    private final String aKey;
    private final String aDefault;

    private RgxGenOption(String key, String default_value) {
        this.aKey = key;
        this.aDefault = default_value;
    }

    public String getKey() {
        return this.aKey;
    }

    public String getDefault() {
        return this.aDefault;
    }

    public String getFromProperties(RgxGenProperties properties) {
        return Optional.ofNullable(properties).map(p -> p.getProperty(this.aKey)).orElse(this.aDefault);
    }

    public <T> void setInProperties(RgxGenProperties properties, T value) {
        Objects.requireNonNull(value);
        properties.setProperty(this.aKey, Objects.toString(value));
    }

    public int getIntFromProperties(RgxGenProperties properties) {
        return Integer.parseInt(this.getFromProperties(properties));
    }

    public boolean getBooleanFromProperties(RgxGenProperties properties) {
        return Boolean.parseBoolean(this.getFromProperties(properties));
    }

    public String toString() {
        return this.aKey;
    }
}

