/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.github.curiousoddman.rgxgen;

import Shadow.shadowed.com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.iterators.StringIterator;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.nodes.Node;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.parsing.dflt.DefaultTreeBuilder;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors.GenerationVisitor;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors.NotMatchingGenerationVisitor;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors.UniqueGenerationVisitor;
import Shadow.shadowed.com.github.curiousoddman.rgxgen.visitors.UniqueValuesCountingVisitor;
import java.math.BigInteger;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;

public class RgxGen {
    private static RgxGenProperties aGlobalProperties;
    private final Node aNode;
    private RgxGenProperties aLocalProperties = aGlobalProperties;

    public static void setDefaultProperties(RgxGenProperties properties) {
        aGlobalProperties = properties;
    }

    public RgxGen(CharSequence pattern) {
        this(new DefaultTreeBuilder(pattern.toString()));
    }

    public RgxGen(NodeTreeBuilder builder) {
        this.aNode = builder.get();
    }

    public void setProperties(RgxGenProperties properties) {
        this.aLocalProperties = properties;
        if (this.aLocalProperties == null) {
            this.aLocalProperties = aGlobalProperties;
        } else {
            this.aLocalProperties.setDefaults(aGlobalProperties);
        }
    }

    @Deprecated
    public BigInteger numUnique() {
        UniqueValuesCountingVisitor v = new UniqueValuesCountingVisitor(this.aLocalProperties);
        this.aNode.visit(v);
        return v.getEstimation().orElse(null);
    }

    public Optional<BigInteger> getUniqueEstimation() {
        UniqueValuesCountingVisitor v = new UniqueValuesCountingVisitor(this.aLocalProperties);
        this.aNode.visit(v);
        return v.getEstimation();
    }

    public Stream<String> stream() {
        return Stream.generate(this::generate);
    }

    public StringIterator iterateUnique() {
        UniqueGenerationVisitor ugv = new UniqueGenerationVisitor(this.aLocalProperties);
        this.aNode.visit(ugv);
        return ugv.getUniqueStrings();
    }

    public String generate() {
        return this.generate(new Random());
    }

    public String generate(Random random) {
        GenerationVisitor gv = GenerationVisitor.builder().withRandom(random).withProperties(this.aLocalProperties).get();
        this.aNode.visit(gv);
        return gv.getString();
    }

    public String generateNotMatching() {
        return this.generateNotMatching(new Random());
    }

    public String generateNotMatching(Random random) {
        GenerationVisitor nmgv = NotMatchingGenerationVisitor.builder().withRandom(random).get();
        this.aNode.visit(nmgv);
        return nmgv.getString();
    }
}

