/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.florianingerl.util.regex;

import java.util.HashMap;
import java.util.Locale;

enum UnicodeProp {
    ALPHABETIC{

        @Override
        public boolean is(int ch) {
            return Character.isAlphabetic(ch);
        }
    }
    ,
    LETTER{

        @Override
        public boolean is(int ch) {
            return Character.isLetter(ch);
        }
    }
    ,
    IDEOGRAPHIC{

        @Override
        public boolean is(int ch) {
            return Character.isIdeographic(ch);
        }
    }
    ,
    LOWERCASE{

        @Override
        public boolean is(int ch) {
            return Character.isLowerCase(ch);
        }
    }
    ,
    UPPERCASE{

        @Override
        public boolean is(int ch) {
            return Character.isUpperCase(ch);
        }
    }
    ,
    TITLECASE{

        @Override
        public boolean is(int ch) {
            return Character.isTitleCase(ch);
        }
    }
    ,
    WHITE_SPACE{

        @Override
        public boolean is(int ch) {
            return (28672 >> Character.getType(ch) & 1) != 0 || ch >= 9 && ch <= 13 || ch == 133;
        }
    }
    ,
    CONTROL{

        @Override
        public boolean is(int ch) {
            return Character.getType(ch) == 15;
        }
    }
    ,
    PUNCTUATION{

        @Override
        public boolean is(int ch) {
            return (1643118592 >> Character.getType(ch) & 1) != 0;
        }
    }
    ,
    HEX_DIGIT{

        @Override
        public boolean is(int ch) {
            return DIGIT.is(ch) || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102 || ch >= 65296 && ch <= 65305 || ch >= 65313 && ch <= 65318 || ch >= 65345 && ch <= 65350;
        }
    }
    ,
    ASSIGNED{

        @Override
        public boolean is(int ch) {
            return Character.getType(ch) != 0;
        }
    }
    ,
    NONCHARACTER_CODE_POINT{

        @Override
        public boolean is(int ch) {
            return (ch & 0xFFFE) == 65534 || ch >= 64976 && ch <= 65007;
        }
    }
    ,
    DIGIT{

        @Override
        public boolean is(int ch) {
            return Character.isDigit(ch);
        }
    }
    ,
    ALNUM{

        @Override
        public boolean is(int ch) {
            return ALPHABETIC.is(ch) || DIGIT.is(ch);
        }
    }
    ,
    BLANK{

        @Override
        public boolean is(int ch) {
            return Character.getType(ch) == 12 || ch == 9;
        }
    }
    ,
    GRAPH{

        @Override
        public boolean is(int ch) {
            return (585729 >> Character.getType(ch) & 1) == 0;
        }
    }
    ,
    PRINT{

        @Override
        public boolean is(int ch) {
            return (GRAPH.is(ch) || BLANK.is(ch)) && !CONTROL.is(ch);
        }
    }
    ,
    WORD{

        @Override
        public boolean is(int ch) {
            return ALPHABETIC.is(ch) || (8389568 >> Character.getType(ch) & 1) != 0 || JOIN_CONTROL.is(ch);
        }
    }
    ,
    JOIN_CONTROL{

        @Override
        public boolean is(int ch) {
            return ch == 8204 || ch == 8205;
        }
    };

    private static final HashMap<String, String> posix;
    private static final HashMap<String, String> aliases;

    public static UnicodeProp forName(String propName) {
        String alias = aliases.get(propName = propName.toUpperCase(Locale.ENGLISH));
        if (alias != null) {
            propName = alias;
        }
        try {
            return UnicodeProp.valueOf(propName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static UnicodeProp forPOSIXName(String propName) {
        if ((propName = posix.get(propName.toUpperCase(Locale.ENGLISH))) == null) {
            return null;
        }
        return UnicodeProp.valueOf(propName);
    }

    public abstract boolean is(int var1);

    static {
        posix = new HashMap();
        aliases = new HashMap();
        posix.put("ALPHA", "ALPHABETIC");
        posix.put("LOWER", "LOWERCASE");
        posix.put("UPPER", "UPPERCASE");
        posix.put("SPACE", "WHITE_SPACE");
        posix.put("PUNCT", "PUNCTUATION");
        posix.put("XDIGIT", "HEX_DIGIT");
        posix.put("ALNUM", "ALNUM");
        posix.put("CNTRL", "CONTROL");
        posix.put("DIGIT", "DIGIT");
        posix.put("BLANK", "BLANK");
        posix.put("GRAPH", "GRAPH");
        posix.put("PRINT", "PRINT");
        aliases.put("WHITESPACE", "WHITE_SPACE");
        aliases.put("HEXDIGIT", "HEX_DIGIT");
        aliases.put("NONCHARACTERCODEPOINT", "NONCHARACTER_CODE_POINT");
        aliases.put("JOINCONTROL", "JOIN_CONTROL");
    }
}

