/*
 * Decompiled with CFR 0.152.
 */
package Shadow.shadowed.com.florianingerl.util.regex;

import Shadow.shadowed.com.florianingerl.util.regex.ASCII;
import Shadow.shadowed.com.florianingerl.util.regex.Capture;
import Shadow.shadowed.com.florianingerl.util.regex.CaptureReplacer;
import Shadow.shadowed.com.florianingerl.util.regex.CaptureTree;
import Shadow.shadowed.com.florianingerl.util.regex.CaptureTreeNode;
import Shadow.shadowed.com.florianingerl.util.regex.MatchResult;
import Shadow.shadowed.com.florianingerl.util.regex.Pattern;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.Vector;
import java.util.function.Function;

public final class Matcher
implements MatchResult {
    Pattern parentPattern;
    public static final int CAPTURE_TREE = 1;
    int mode = 0;
    boolean captureTreeMode;
    Map<Class<? extends Pattern.CustomNode>, Object> data;
    int from;
    int to;
    int lookbehindTo;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = 0;
    int oldLast = -1;
    int lastAppendPosition = 0;
    Vector<Stack<Integer>> localVector;
    int[] recursions;
    int activity;
    CaptureTreeNode captureTreeNode;
    int[] groups;
    private CaptureTree captureTree;
    Pattern.Node[] nextNodes;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds = false;
    boolean anchoringBounds = true;

    Matcher() {
    }

    Matcher(Pattern parent, CharSequence text) {
        this.parentPattern = parent;
        this.text = text;
        this.init();
        this.reset();
    }

    private void init() {
        this.groups = new int[this.parentPattern.capturingGroupCount * 2];
        this.recursions = new int[this.parentPattern.capturingGroupCount * 3];
        this.localVector = new Vector(this.parentPattern.localCount);
        this.localVector.setSize(this.parentPattern.localCount);
        this.nextNodes = new Pattern.Node[this.parentPattern.localCount];
    }

    private void genData() {
        this.data = new HashMap<Class<? extends Pattern.CustomNode>, Object>();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        Matcher result = new Matcher(this.parentPattern, this.text.toString());
        result.first = this.first;
        result.last = this.last;
        result.captureTreeNode = this.captureTreeNode;
        return result;
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.parentPattern = newPattern;
        this.init();
        this.reset();
        return this;
    }

    public Matcher reset() {
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        this.captureTree = null;
        this.captureTreeNode = this.captureTreeMode ? new CaptureTreeNode() : null;
        for (int i = 0; i < this.localVector.size(); ++i) {
            this.localVector.set(i, new Stack());
            this.nextNodes[i] = null;
        }
        Arrays.fill(this.groups, -1);
        this.resetRecursions();
        this.activity = 0;
        this.genData();
        this.lastAppendPosition = 0;
        this.from = 0;
        this.to = this.getTextLength();
        return this;
    }

    private void resetRecursions() {
        for (int i = 0; i < this.parentPattern.capturingGroupCount; ++i) {
            this.recursions[i * 3] = -1;
            this.recursions[i * 3 + 2] = 0;
        }
    }

    public Matcher reset(CharSequence input) {
        this.text = input;
        return this.reset();
    }

    @Override
    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    @Override
    public int start(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.groups[group * 2];
    }

    @Override
    public int start(String name) {
        return this.groups[this.getMatchedGroupIndex(name) * 2];
    }

    @Override
    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    @Override
    public int end(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.groups[group * 2 + 1];
    }

    @Override
    public int end(String name) {
        return this.groups[this.getMatchedGroupIndex(name) * 2 + 1];
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        if (this.groups[group * 2] == -1 || this.groups[group * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[group * 2], this.groups[group * 2 + 1]).toString();
    }

    @Override
    public String group(String name) {
        int group = this.getMatchedGroupIndex(name);
        if (this.groups[group * 2] == -1 || this.groups[group * 2 + 1] == -1) {
            return null;
        }
        return this.getSubSequence(this.groups[group * 2], this.groups[group * 2 + 1]).toString();
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.captureTreeMode = (mode & 1) != 0;
    }

    public int getMode() {
        return this.mode;
    }

    public CaptureTree captureTree() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (!this.captureTreeMode) {
            throw new IllegalStateException("Mode CAPTURE_TREE is not set");
        }
        if (this.captureTree == null) {
            this.captureTreeNode.setGroupName(this.parentPattern.groupNames());
            this.captureTree = new CaptureTree(this.captureTreeNode);
        }
        return this.captureTree;
    }

    @Override
    public int groupCount() {
        return this.parentPattern.capturingGroupCount - 1;
    }

    public boolean matches() {
        return this.match(this.from, 1);
    }

    public boolean find() {
        int nextSearchIndex = this.last;
        if (nextSearchIndex == this.first) {
            ++nextSearchIndex;
        }
        if (nextSearchIndex < this.from) {
            nextSearchIndex = this.from;
        }
        if (nextSearchIndex > this.to) {
            return false;
        }
        return this.search(nextSearchIndex);
    }

    public boolean find(int start) {
        int limit = this.getTextLength();
        if (start < 0 || start > limit) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.search(start);
    }

    public boolean lookingAt() {
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int cursor = 0;
        StringBuilder result = new StringBuilder();
        while (cursor < replacement.length()) {
            char nextChar = replacement.charAt(cursor);
            if (nextChar == '\\') {
                if (++cursor == replacement.length()) {
                    throw new IllegalArgumentException("character to be escaped is missing");
                }
                nextChar = replacement.charAt(cursor);
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                if (++cursor == replacement.length()) {
                    throw new IllegalArgumentException("Illegal group reference: group index is missing");
                }
                nextChar = replacement.charAt(cursor);
                int refNum = -1;
                if (nextChar == '{') {
                    ++cursor;
                    StringBuilder gsb = new StringBuilder();
                    while (cursor < replacement.length() && Pattern.isCharOfGroupname(nextChar = replacement.charAt(cursor))) {
                        gsb.append(nextChar);
                        ++cursor;
                    }
                    if (gsb.length() == 0) {
                        throw new IllegalArgumentException("named capturing group has 0 length name");
                    }
                    if (nextChar != '}') {
                        throw new IllegalArgumentException("named capturing group is missing trailing '}'");
                    }
                    String gname = gsb.toString();
                    if (ASCII.isDigit(gname.charAt(0))) {
                        throw new IllegalArgumentException("capturing group name {" + gname + "} starts with digit character");
                    }
                    if (!this.parentPattern.groupIndices().containsKey(gname)) {
                        throw new IllegalArgumentException("No group with name {" + gname + "}");
                    }
                    refNum = this.parentPattern.groupIndices().get(gname);
                    ++cursor;
                } else {
                    int nextDigit;
                    refNum = nextChar - 48;
                    if (refNum < 0 || refNum > 9) {
                        throw new IllegalArgumentException("Illegal group reference");
                    }
                    ++cursor;
                    boolean done = false;
                    while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                        int newRefNum = refNum * 10 + nextDigit;
                        if (this.groupCount() < newRefNum) {
                            done = true;
                            continue;
                        }
                        refNum = newRefNum;
                        ++cursor;
                    }
                }
                if (this.start(refNum) == -1 || this.end(refNum) == -1) continue;
                result.append(this.text, this.start(refNum), this.end(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        sb.append(this.text, this.lastAppendPosition, this.first);
        sb.append((CharSequence)result);
        this.lastAppendPosition = this.last;
        return this;
    }

    public Matcher appendReplacement(StringBuffer sb, Function<Matcher, String> evaluator) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        sb.append(this.text, this.lastAppendPosition, this.first);
        sb.append(evaluator.apply(this));
        this.lastAppendPosition = this.last;
        return this;
    }

    public Matcher appendReplacement(StringBuffer sb, CaptureReplacer replacer) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (!this.captureTreeMode) {
            throw new IllegalStateException("Mode CAPTURE_TREE is not set");
        }
        sb.append(this.text, this.lastAppendPosition, this.first);
        replacer.setInput(this.text);
        sb.append(replacer.replace(this.captureTree().getRoot()));
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.text, this.lastAppendPosition, this.getTextLength());
        return sb;
    }

    public String replaceAll(String replacement) {
        this.reset();
        boolean result = this.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                this.appendReplacement(sb, replacement);
            } while (result = this.find());
            this.appendTail(sb);
            return sb.toString();
        }
        return this.text.toString();
    }

    public String replaceAll(Function<Matcher, String> evaluator) {
        this.reset();
        boolean result = this.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                this.appendReplacement(sb, evaluator);
            } while (result = this.find());
            this.appendTail(sb);
            return sb.toString();
        }
        return this.text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceAll(CaptureReplacer replacer) {
        int saveMode = this.getMode();
        try {
            this.setMode(saveMode | 1);
            this.reset();
            boolean result = this.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                do {
                    this.appendReplacement(sb, replacer);
                } while (result = this.find());
                this.appendTail(sb);
                String string = sb.toString();
                return string;
            }
            String string = this.text.toString();
            return string;
        }
        finally {
            this.setMode(saveMode);
        }
    }

    public String replaceFirst(String replacement) {
        if (replacement == null) {
            throw new NullPointerException("replacement");
        }
        this.reset();
        if (!this.find()) {
            return this.text.toString();
        }
        StringBuffer sb = new StringBuffer();
        this.appendReplacement(sb, replacement);
        this.appendTail(sb);
        return sb.toString();
    }

    public String replaceFirst(Function<Matcher, String> evaluator) {
        if (evaluator == null) {
            throw new NullPointerException("evaluator");
        }
        this.reset();
        if (!this.find()) {
            return this.text.toString();
        }
        StringBuffer sb = new StringBuffer();
        this.appendReplacement(sb, evaluator);
        this.appendTail(sb);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String replaceFirst(CaptureReplacer replacer) {
        if (replacer == null) {
            throw new NullPointerException("replacer");
        }
        int saveMode = this.getMode();
        try {
            this.setMode(saveMode | 1);
            this.reset();
            if (!this.find()) {
                String string = this.text.toString();
                return string;
            }
            StringBuffer sb = new StringBuffer();
            this.appendReplacement(sb, replacer);
            this.appendTail(sb);
            String string = sb.toString();
            return string;
        }
        finally {
            this.setMode(saveMode);
        }
    }

    public Matcher region(int start, int end) {
        if (start < 0 || start > this.getTextLength()) {
            throw new IndexOutOfBoundsException("start");
        }
        if (end < 0 || end > this.getTextLength()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.reset();
        this.from = start;
        this.to = end;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean b) {
        this.transparentBounds = b;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean b) {
        this.anchoringBounds = b;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.util.regex.Matcher");
        sb.append("[pattern=" + this.pattern());
        sb.append(" region=");
        sb.append(this.regionStart() + "," + this.regionEnd());
        sb.append(" lastmatch=");
        if (this.first >= 0 && this.group() != null) {
            sb.append(this.group());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int from) {
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = from = from < 0 ? 0 : from;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        this.genData();
        this.captureTree = null;
        this.captureTreeNode = this.captureTreeMode ? new CaptureTreeNode() : null;
        Arrays.fill(this.groups, -1);
        this.resetRecursions();
        this.activity = 0;
        this.acceptMode = 0;
        boolean result = this.parentPattern.root.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    boolean match(int from, int anchor) {
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = from = from < 0 ? 0 : from;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        this.genData();
        this.captureTree = null;
        Arrays.fill(this.groups, -1);
        this.resetRecursions();
        this.activity = 0;
        this.captureTreeNode = this.captureTreeMode ? new CaptureTreeNode() : null;
        this.acceptMode = anchor;
        boolean result = this.parentPattern.matchRoot.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int beginIndex, int endIndex) {
        return this.text.subSequence(beginIndex, endIndex);
    }

    char charAt(int i) {
        return this.text.charAt(i);
    }

    int getMatchedGroupIndex(String name) {
        Objects.requireNonNull(name, "Group name");
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (!this.parentPattern.groupIndices().containsKey(name)) {
            throw new IllegalArgumentException("No group with name <" + name + ">");
        }
        return this.parentPattern.groupIndices().get(name);
    }

    void setGroup0(CharSequence seq, int start, int end) {
        if (this.captureTreeMode) {
            Capture capture;
            this.captureTreeNode.capture = capture = new Capture(seq, start, end);
        }
        this.groups[0] = start;
        this.groups[1] = end;
    }
}

