/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.ISpellInteractibleBlock;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.entities.ISpellInteractibleEntity;
import com.mna.api.events.ComponentApplyingEvent;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.ISpellHelper;
import com.mna.api.spells.SpellCastingResult;
import com.mna.api.spells.SpellCastingResultCode;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.SpellReagent;
import com.mna.api.spells.adjusters.SpellAdjustingContext;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.base.SpellBlacklistResult;
import com.mna.api.spells.collections.Shapes;
import com.mna.api.spells.parts.Modifier;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedSpellEffect;
import com.mna.capabilities.chunkdata.ChunkMagicProvider;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.targeting.SpellProjectile;
import com.mna.entities.utility.SpellFX;
import com.mna.events.EventDispatcher;
import com.mna.factions.Factions;
import com.mna.interop.CuriosInterop;
import com.mna.inventory.InventoryRitualKit;
import com.mna.items.ItemInit;
import com.mna.items.artifice.charms.ItemContingencyCharm;
import com.mna.items.ritual.ItemPractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.sorcery.ItemBookOfRote;
import com.mna.network.ServerMessageDispatcher;
import com.mna.spells.NameProcessors;
import com.mna.spells.SpellAdjuster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.InventoryUtilities;
import com.mna.tools.math.MathUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class SpellCaster
implements ISpellHelper {
    private static ArrayList<SpellAdjuster> _adjusters = new ArrayList();
    private static ArrayList<Item> _cooldownItems = new ArrayList();

    public static SpellCastingResult PlayerCast(ItemStack stack, Player caster, InteractionHand hand, Vec3 casterPosition, Vec3 casterLook, Level world, boolean consumeMana, boolean isCurioCast) {
        try {
            List missingRequired;
            IPlayerMagic magic = null;
            IPlayerProgression progression = null;
            if (caster.m_21124_((MobEffect)EffectInit.SILENCE.get()) != null) {
                return SpellCastingResultCode.SILENCED.createResult();
            }
            magic = (IPlayerMagic)caster.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
            progression = (IPlayerProgression)caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
            if (magic == null || progression == null) {
                return SpellCastingResultCode.CAPABILITY_MISSING.createResult();
            }
            if (!magic.isMagicUnlocked() && consumeMana) {
                if (!world.f_46443_) {
                    caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.no-magic"));
                }
                return SpellCastingResultCode.NOT_UNLOCKED_MAGIC.createResult();
            }
            SpellRecipe recipe = SpellRecipe.fromNBT(stack.m_41783_());
            if (!recipe.isValid()) {
                return SpellCastingResultCode.INVALID_RECIPE.createResult();
            }
            if (consumeMana && !caster.m_7500_() && recipe.getTier(world) > progression.getTier()) {
                if (!world.f_46443_) {
                    caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.tier-fail"));
                }
                return SpellCastingResultCode.INSUFFICIENT_TIER.createResult();
            }
            if (consumeMana && !caster.m_7500_() && recipe.getComplexity() > (float)progression.getTierMaxComplexity()) {
                if (!world.f_46443_) {
                    caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.complexity-fail"));
                }
                return SpellCastingResultCode.TOO_COMPLEX.createResult();
            }
            HashMap<Item, Boolean> missing = SpellCaster.checkReagents(caster, hand, recipe);
            if (consumeMana && !caster.m_7500_() && (missingRequired = missing.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).collect(Collectors.toList())).size() > 0) {
                if (!world.f_46443_) {
                    if (missing.size() > 1) {
                        caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.reagents-missing.multi"));
                    } else {
                        caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.reagents-missing.single").m_7220_((Component)Component.m_237115_((String)((Item)((Map.Entry)missingRequired.get(0)).getKey()).m_5524_())));
                    }
                }
                return SpellCastingResultCode.MISSING_REAGENTS.createResult();
            }
            if (!EventDispatcher.DispatchSpellCast(recipe, caster)) {
                return SpellCastingResultCode.CANCELED_BY_EVENT.createResult();
            }
            if (caster instanceof ServerPlayer) {
                CustomAdvancementTriggers.CAST_SPELL.trigger((ServerPlayer)caster, recipe);
            }
            SpellCaster.applyAdjusters(stack, (LivingEntity)caster, hand, isCurioCast, recipe, SpellCastStage.CASTING);
            if (!world.f_46443_ && recipe.isMysterious()) {
                recipe.setMysterious(false);
                recipe.writeToNBT(stack.m_41784_());
            }
            float manaCost = recipe.getManaCost();
            if (!caster.m_7500_() && !magic.getCastingResource().hasEnough((LivingEntity)caster, manaCost) && consumeMana) {
                return SpellCastingResultCode.NOT_ENOUGH_MANA.createResult();
            }
            SpellContext context = new SpellContext(world, recipe);
            context.setMissingReagents(missing.keySet().stream().toList());
            SpellCastingResult subCast = SpellCaster.Affect(stack, recipe, world, new SpellSource((LivingEntity)caster, hand), null, context);
            if (!subCast.getCode().isConsideredSuccess()) {
                return subCast;
            }
            if (consumeMana) {
                if (!recipe.canFactionCraft(progression)) {
                    recipe.usedByPlayer(caster);
                }
                if (((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).isChanneled()) {
                    magic.getCastingResource().consume((LivingEntity)caster, manaCost * 0.25f);
                } else {
                    magic.getCastingResource().consume((LivingEntity)caster, manaCost);
                    SpellCaster.AddAffinityAndMagicXP(recipe, caster);
                }
                if (caster instanceof ServerPlayer && magic.getCastingResource().getAmount() <= magic.getCastingResource().getMaxAmount() * 0.1f) {
                    ItemContingencyCharm.CheckAndConsumeCharmCharge((ServerPlayer)caster, ItemContingencyCharm.ContingencyEvent.LOW_CASTING_RESOURCE);
                }
                SpellCaster.consumeReagents(caster, hand, recipe, subCast);
            }
            return subCast;
        }
        catch (Throwable t) {
            try {
                caster.m_213846_((Component)Component.m_237115_((String)"item.mna.spell.fatal_error"));
            }
            catch (Throwable subt) {
                ManaAndArtifice.LOGGER.error("Error notifying caster about spell cast failure:");
                ManaAndArtifice.LOGGER.error((Object)subt);
            }
            ManaAndArtifice.LOGGER.error((Object)t);
            return SpellCastingResultCode.EXCEPTION_THROWN.createResult();
        }
    }

    public static SpellCastingResult Affect(@Nullable ItemStack stack, ISpellDefinition recipe, Level world, SpellSource source) {
        return SpellCaster.Affect(stack, recipe, world, source, null, null);
    }

    public static SpellCastingResult Affect(@Nullable ItemStack stack, ISpellDefinition recipe, Level world, SpellSource source, SpellTarget targetHint) {
        return SpellCaster.Affect(stack, recipe, world, source, targetHint, null);
    }

    public static SpellCastingResult Affect(@Nullable ItemStack stack, ISpellDefinition recipe, Level world, SpellSource source, SpellTarget targetHint, SpellContext context) {
        try {
            if (!recipe.isValid()) {
                return SpellCastingResultCode.INVALID_RECIPE.createResult();
            }
            Shape shape = recipe.getShape().getPart();
            if (shape == null || recipe.countComponents() == 0) {
                return SpellCastingResultCode.INVALID_RECIPE.createResult();
            }
            SpellBlacklistResult result = shape.canBeCastAt(world, source.getOrigin());
            if (result != SpellBlacklistResult.ALLOWED) {
                if (source.isPlayerCaster() && !world.f_46443_) {
                    source.getPlayer().m_213846_((Component)Component.m_237115_((String)result.getMessageTranslationKey().toString()));
                }
                return SpellCastingResultCode.BLOCKED_BY_CONFIG.createResult();
            }
            for (int i = 0; i < recipe.countComponents(); ++i) {
                result = recipe.getComponent(i).getPart().canBeCastAt(world, source.getOrigin());
                if (result == SpellBlacklistResult.ALLOWED) continue;
                if (source.isPlayerCaster() && !world.f_46443_) {
                    source.getPlayer().m_213846_((Component)Component.m_237115_((String)result.getMessageTranslationKey().toString()));
                }
                return SpellCastingResultCode.BLOCKED_BY_CONFIG.createResult();
            }
            List<SpellTarget> targets = null;
            if (targetHint != null) {
                targets = shape.TargetNPCCast(source, world, recipe.getShape(), recipe, targetHint);
            }
            if (targetHint == null || targets == null || targets.size() == 0 || targets.get(0) == SpellTarget.NPC_CAST_ASSIST_NOT_IMPLEMENTED) {
                targets = shape.Target(source, world, recipe.getShape(), recipe);
            }
            if (targets == null || targets.size() == 0 || targets.get(0) == SpellTarget.NONE) {
                return SpellCastingResultCode.NO_TARGET.createResult();
            }
            if (!world.f_46443_ && !((ServerLevel)world).m_7654_().m_129799_() && recipe.isHarmful()) {
                MutableBoolean pvpdenied = new MutableBoolean(false);
                recipe.iterateComponents(c -> {
                    if (((SpellEffect)c.getPart()).getUseTag() == SpellPartTags.HARMFUL) {
                        pvpdenied.setTrue();
                    }
                });
                if (pvpdenied.booleanValue()) {
                    targets = targets.stream().filter(t -> !t.isEntity() || !(t.getEntity() instanceof Player) || t.getEntity() == source.getCaster()).collect(Collectors.toList());
                }
                if (targets.size() == 0) {
                    return SpellCastingResultCode.NO_TARGET.createResult();
                }
            }
            SoundEvent spellSound = SFX.Spell.Cast.ForAffinity(recipe.getHighestAffinity());
            if (stack != null) {
                spellSound = NameProcessors.checkAndOverrideSound(recipe, stack.m_41786_().getString(), spellSound);
            }
            if (spellSound != null && source.getCaster() != null) {
                float f;
                float pitch = (float)((double)0.9f + Math.random() * (double)0.1f);
                MobEffectInstance efct = source.getCaster().m_21124_((MobEffect)EffectInit.REDUCE.get());
                if (efct != null) {
                    f = 0.1f * (float)efct.m_19564_();
                    pitch += f;
                }
                if ((efct = source.getCaster().m_21124_((MobEffect)EffectInit.ENLARGE.get())) != null) {
                    f = 0.05f * (float)efct.m_19564_();
                    pitch -= f;
                }
                world.m_6269_(null, (Entity)source.getCaster(), spellSound, SoundSource.PLAYERS, 0.5f, pitch);
            }
            if (!world.f_46443_) {
                world.m_46745_(BlockPos.m_274446_((Position)source.getOrigin())).getCapability(ChunkMagicProvider.MAGIC).ifPresent(cm -> cm.addResidualMagic(recipe.getManaCost()));
            }
            if (shape.spawnsTargetEntity()) {
                HashMap<SpellEffect, ComponentApplicationResult> targetResult = new HashMap<SpellEffect, ComponentApplicationResult>();
                for (IModifiedSpellPart iModifiedSpellPart : recipe.getComponents()) {
                    targetResult.put((SpellEffect)iModifiedSpellPart.getPart(), ComponentApplicationResult.TARGET_ENTITY_SPAWNED);
                }
                if (shape.isChanneled()) {
                    return SpellCastingResultCode.CHANNEL.createResult(targetResult);
                }
                return SpellCastingResultCode.SUCCESS.createResult(targetResult);
            }
            if (targets.size() == 1) {
                boolean bl;
                SpellTarget target2 = targets.get(0);
                BlockState state = world.m_8055_(target2.getBlock());
                if (state.m_60734_() instanceof ISpellInteractibleBlock && ((ISpellInteractibleBlock)state.m_60734_()).onHitBySpell(world, target2.getBlock(), recipe)) {
                    return SpellCastingResultCode.SPELL_INTERACTIBLE_BLOCK_HIT.createResult();
                }
                if (target2.isEntity() && target2.getEntity() instanceof ISpellInteractibleEntity && (bl = ((ISpellInteractibleEntity)target2.getEntity()).onShapeTarget(recipe, source))) {
                    return SpellCastingResultCode.SPELL_INTERACTIBLE_ENTITY_HIT.createResult();
                }
            }
            HashMap<SpellEffect, ComponentApplicationResult> mergedComponentResults = new HashMap<SpellEffect, ComponentApplicationResult>();
            if (!world.f_46443_) {
                SpellContext iteratorContext = context == null ? new SpellContext(world, recipe) : context;
                targets.forEach(target -> {
                    HashMap<SpellEffect, ComponentApplicationResult> componentResults = SpellCaster.ApplyComponents(recipe, source, target, iteratorContext);
                    SpellCaster.mergeComponentResults(mergedComponentResults, componentResults);
                    List<SpellEffect> appliedEffects = componentResults.entrySet().stream().map(e -> e.getValue() == ComponentApplicationResult.SUCCESS ? (SpellEffect)e.getKey() : null).filter(e -> e != null).collect(Collectors.toList());
                    if (appliedEffects.size() > 0) {
                        SpellCaster.spawnClientFX(world, target.getPosition(), Vec3.f_82478_, source, appliedEffects);
                    }
                });
            }
            return mergedComponentResults.values().stream().anyMatch(c -> c == ComponentApplicationResult.SUCCESS || c == ComponentApplicationResult.DELAYED) ? SpellCastingResultCode.SUCCESS.createResult(mergedComponentResults) : SpellCastingResultCode.NO_TARGET.createResult(mergedComponentResults);
        }
        catch (Throwable t2) {
            try {
                if (source.getCaster() != null && source.getCaster() instanceof Player) {
                    ((Player)source.getCaster()).m_213846_((Component)Component.m_237115_((String)"item.mna.spell.fatal_error"));
                }
            }
            catch (Throwable subt) {
                ManaAndArtifice.LOGGER.error("Error notifying caster about spell cast failure:");
                ManaAndArtifice.LOGGER.error((Object)subt);
            }
            ManaAndArtifice.LOGGER.error((Object)t2);
            return SpellCastingResultCode.EXCEPTION_THROWN.createResult();
        }
    }

    public static void mergeComponentResults(HashMap<SpellEffect, ComponentApplicationResult> mainList, HashMap<SpellEffect, ComponentApplicationResult> toMerge) {
        toMerge.forEach((c, r) -> {
            if (mainList.containsKey(c)) {
                if (r.is_success) {
                    mainList.put((SpellEffect)c, (ComponentApplicationResult)((Object)r));
                }
            } else {
                mainList.put((SpellEffect)c, (ComponentApplicationResult)((Object)r));
            }
        });
    }

    public static HashMap<SpellEffect, ComponentApplicationResult> ApplyComponents(ISpellDefinition recipe, SpellSource source, SpellTarget target, SpellContext context) {
        List<SpellEffect> appliedEffects;
        HashMap<SpellEffect, ComponentApplicationResult> results = new HashMap<SpellEffect, ComponentApplicationResult>();
        if (!context.getServerLevel().m_7654_().m_129799_() && recipe.isHarmful()) {
            MutableBoolean pvpdenied = new MutableBoolean(false);
            recipe.iterateComponents(c -> {
                if (((SpellEffect)c.getPart()).getUseTag() == SpellPartTags.HARMFUL) {
                    pvpdenied.setTrue();
                }
            });
            if (pvpdenied.booleanValue() && target.isEntity() && target.getEntity() instanceof Player && target.getEntity() != source.getCaster()) {
                recipe.iterateComponents(c -> results.put((SpellEffect)c.getPart(), ComponentApplicationResult.FAIL));
                return results;
            }
        }
        recipe.iterateComponents(c -> {
            int delayInSeconds = (int)(c.getValue(Attribute.DELAY) * 20.0f);
            if (MinecraftForge.EVENT_BUS.post((Event)new ComponentApplyingEvent(source, context, target, (SpellEffect)c.getPart()))) {
                return;
            }
            if (target.isBlock() && ((SpellEffect)c.getPart()).targetsBlocks() && !context.hasBlockBeenAffected((SpellEffect)c.getPart(), target.getBlock())) {
                if (delayInSeconds == 0) {
                    ComponentApplicationResult cRes = null;
                    try {
                        cRes = ((SpellEffect)c.getPart()).ApplyEffect(source, target, (IModifiedSpellPart<SpellEffect>)c, context);
                    }
                    catch (Throwable t) {
                        ManaAndArtifice.LOGGER.error((Object)t);
                        cRes = ComponentApplicationResult.FAIL;
                    }
                    results.put((SpellEffect)c.getPart(), cRes);
                    context.addAffectedBlock((SpellEffect)c.getPart(), target.getBlock());
                } else {
                    DelayedEventQueue.pushEvent((Level)context.getServerLevel(), new TimedDelayedSpellEffect("" + context.getServerLevel().m_46467_(), delayInSeconds, source, target, (IModifiedSpellPart<SpellEffect>)c, context));
                    results.put((SpellEffect)c.getPart(), ComponentApplicationResult.DELAYED);
                }
            } else if (target.isEntity() && ((SpellEffect)c.getPart()).targetsEntities() && !context.hasEntityBeenAffected((SpellEffect)c.getPart(), target.getEntity())) {
                if (delayInSeconds == 0) {
                    ComponentApplicationResult cRes = null;
                    try {
                        cRes = ((SpellEffect)c.getPart()).ApplyEffect(source, target, (IModifiedSpellPart<SpellEffect>)c, context);
                    }
                    catch (Throwable t) {
                        ManaAndArtifice.LOGGER.error((Object)t);
                        cRes = ComponentApplicationResult.FAIL;
                    }
                    results.put((SpellEffect)c.getPart(), cRes);
                    context.addAffectedEntity((SpellEffect)c.getPart(), target.getEntity());
                } else {
                    DelayedEventQueue.pushEvent((Level)context.getServerLevel(), new TimedDelayedSpellEffect("" + context.getServerLevel().m_46467_(), delayInSeconds, source, target, (IModifiedSpellPart<SpellEffect>)c, context));
                    results.put((SpellEffect)c.getPart(), ComponentApplicationResult.DELAYED);
                }
            }
        });
        ServerLevel world = context.getServerLevel();
        if (!world.f_46443_ && !recipe.getShape().getPart().isChanneled() && (appliedEffects = results.entrySet().stream().map(e -> e.getValue() == ComponentApplicationResult.SUCCESS ? (SpellEffect)e.getKey() : null).filter(e -> e != null).collect(Collectors.toList())).size() > 0) {
            SpellCaster.spawnClientFX((Level)context.getServerLevel(), target.getPosition(), Vec3.f_82478_, source, appliedEffects);
        }
        return results;
    }

    public static void AddAffinityAndMagicXP(SpellRecipe recipe, Player caster) {
        SpellCaster.AddAffinityAndMagicXP(recipe, caster, -1);
    }

    public static void AddAffinityAndMagicXP(SpellRecipe recipe, Player caster, int channelDuration) {
        if (caster == null || recipe == null || !recipe.isValid()) {
            return;
        }
        caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> {
            caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(progression -> {
                int xp = (int)recipe.getComplexity();
                float affinity = 0.1f;
                if (channelDuration > -1) {
                    int maxChannelTime = ((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).maxChannelTime(recipe.getShape());
                    xp = (int)((float)xp * ((float)channelDuration / (float)Math.max(1, maxChannelTime)));
                    affinity *= (float)channelDuration / (float)Math.max(1, maxChannelTime);
                }
                magic.addMagicXP(xp, caster, (IPlayerProgression)progression);
                if (((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).grantComponentRoteXP() && !CuriosInterop.GetSingleItem((LivingEntity)caster, (Item)ItemInit.BELT_AFFINITY_LOCK.get()).isPresent()) {
                    for (Map.Entry<Affinity, Float> e : recipe.getAffinity().entrySet()) {
                        magic.shiftAffinity(caster, e.getKey(), affinity * e.getValue().floatValue());
                    }
                }
            });
            if (!caster.m_9236_().m_5776_()) {
                caster.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(rote -> {
                    if (rote.addRoteXP(caster, (ISpellComponent)((ModifiedSpellPart)recipe.getShape()).getPart(), channelDuration == -1 ? 1.0f : (float)channelDuration)) {
                        SpellCaster.sendRoteMessage(caster, ((ModifiedSpellPart)recipe.getShape()).getPart());
                    }
                    if (((Shape)((ModifiedSpellPart)recipe.getShape()).getPart()).grantComponentRoteXP()) {
                        recipe.iterateComponents(c -> SpellCaster.addComponentXP(caster, magic, rote, (SpellEffect)c.getPart()));
                    }
                    for (int i = 0; i < recipe.countModifiers(); ++i) {
                        if (!rote.addRoteXP(caster, recipe.getModifier(i))) continue;
                        SpellCaster.sendRoteMessage(caster, recipe.getModifier(i));
                    }
                });
            }
        });
    }

    public static void addComponentRoteProgress(Player caster, SpellEffect c) {
        SpellCaster.addComponentXP(caster, (IPlayerMagic)caster.getCapability(PlayerMagicProvider.MAGIC).orElse(null), (IPlayerRoteSpells)caster.getCapability(PlayerRoteSpellsProvider.ROTE).orElse(null), c);
    }

    public static void addComponentXP(Player caster, IPlayerMagic magic, IPlayerRoteSpells rote, SpellEffect c) {
        float oppositeDepth;
        float detriment;
        float mainDepth = Math.min(magic.getAffinityDepth(c.getAffinity()), 90.0f);
        float bonus = mainDepth / 100.0f;
        float xpAdd = 1.0f + bonus - (detriment = (oppositeDepth = Math.min(magic.getAffinityDepth(c.getAffinity().getOpposite()), 90.0f)) / 100.0f);
        if (rote.addRoteXP(caster, c, xpAdd)) {
            SpellCaster.sendRoteMessage(caster, c);
        }
    }

    public static void sendRoteMessage(Player caster, ISpellComponent component) {
        MutableComponent roteMessage = Component.m_237110_((String)"event.mna.spell_part_rote", (Object[])new Object[]{Component.m_237115_((String)component.getRegistryName().toString())}).m_130940_(ChatFormatting.GOLD);
        caster.m_9236_().m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SFX.Event.Player.SPELL_CREATED, SoundSource.PLAYERS, 1.0f, 1.0f);
        caster.m_213846_((Component)roteMessage);
    }

    public static void spawnClientFX(Level world, Vec3 position, Vec3 normal, SpellSource source, SpellEffect ... effects) {
        SpellCaster.spawnClientFX(world, position, normal, source, Arrays.asList(effects));
    }

    public static void spawnClientFX(Level world, Vec3 position, Vec3 normal, SpellSource source, List<SpellEffect> effects) {
        if (!world.m_46749_(BlockPos.m_274446_((Position)position))) {
            return;
        }
        SpellRecipe recipe = new SpellRecipe();
        effects.forEach(e -> recipe.addComponent((SpellEffect)e));
        SpellFX fx = new SpellFX((EntityType)EntityInit.SPELL_FX.get(), world);
        fx.setCasterUUID((LivingEntity)source.getPlayer());
        fx.setRecipe(recipe);
        fx.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        fx.m_20256_(normal);
        world.m_7967_((Entity)fx);
    }

    public static float getComplexity(ItemStack spellStack) {
        return SpellCaster.getComplexity(spellStack.m_41783_());
    }

    public static float getComplexity(CompoundTag spellNBT) {
        SpellRecipe recipe = SpellRecipe.fromNBT(spellNBT);
        if (recipe == null || !recipe.isValid()) {
            return 0.0f;
        }
        return recipe.getComplexity();
    }

    public static void registerAdjuster(Predicate<SpellAdjustingContext> executeCheck, Consumer<SpellAdjustingContext> adjuster) {
        _adjusters.add(new SpellAdjuster(executeCheck, adjuster));
    }

    public static void registerAdjuster(Predicate<SpellAdjustingContext> executeCheck, BiConsumer<ISpellDefinition, LivingEntity> adjuster) {
        _adjusters.add(new SpellAdjuster(executeCheck, adjuster));
    }

    public static void applyAdjusters(ItemStack stack, LivingEntity caster, InteractionHand hand, boolean curioCast, ISpellDefinition recipe, SpellCastStage stage) {
        for (SpellAdjuster adjuster : _adjusters) {
            if (!adjuster.check(stage, stack, recipe, caster, hand, curioCast)) continue;
            adjuster.modify(stack, recipe, caster, hand, curioCast);
        }
    }

    public static boolean consumeChanneledMana(Player player, ItemStack stack) {
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return false;
        }
        SpellRecipe spell = SpellRecipe.fromNBT(stack.m_41783_());
        if (spell == null || !spell.isValid()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        SpellCaster.applyAdjusters(stack, (LivingEntity)player, player.m_7655_(), false, spell, SpellCastStage.CALCULATING_MANA_COST);
        float manaCost = spell.getManaCost();
        if (!magic.getCastingResource().hasEnough((LivingEntity)player, manaCost)) {
            return false;
        }
        magic.getCastingResource().consume((LivingEntity)player, manaCost);
        return true;
    }

    public static final void setCooldown(ItemStack stack, Player player, int durationInTicks) {
        IPlayerProgression progression;
        Item item = stack.m_41720_();
        if (!_cooldownItems.contains(item)) {
            _cooldownItems.add(item);
        }
        if ((progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) != null && progression.getAlliedFaction() == Factions.DEMONS) {
            int flameLevel = stack.getEnchantmentLevel(Enchantments.f_44981_);
            durationInTicks = player.m_6060_() && flameLevel > 0 ? (int)((float)durationInTicks * 0.333f) : (int)((double)durationInTicks * 0.75);
        }
        int quickCharge = stack.getEnchantmentLevel(Enchantments.f_44960_);
        durationInTicks = (int)((float)durationInTicks * (1.0f - 0.1f * (float)quickCharge));
        for (Item cdItem : _cooldownItems) {
            player.m_36335_().m_41524_(cdItem, durationInTicks);
        }
    }

    private static List<Pair<IItemHandler, Direction>> getReagentSearchInventories(Player caster) {
        ArrayList<Pair<IItemHandler, Direction>> output = new ArrayList<Pair<IItemHandler, Direction>>();
        CuriosInterop.GetSingleItem((LivingEntity)caster, (Item)ItemInit.PRACTITIONERS_POUCH.get(), (Item)ItemInit.MITHIONS_MAGNIFICENT_MBAG.get()).ifPresent(result -> {
            ItemStack invStack = result.stack();
            if (invStack.m_41619_() || !(invStack.m_41720_() instanceof ItemPractitionersPouch)) {
                return;
            }
            ItemPractitionersPouch item = (ItemPractitionersPouch)invStack.m_41720_();
            Pair<IItemHandler, Direction> remoteInv = item.resolveRemoteInventory(invStack, caster.m_9236_());
            if (remoteInv.getFirst() != null) {
                output.add(remoteInv);
            }
            if (item.getPatchLevel(invStack, PractitionersPouchPatches.RIFT) > 0) {
                caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> output.add(new Pair((Object)new InvWrapper((Container)m.getRiftInventory()), (Object)Direction.UP)));
            }
            InventoryRitualKit kit = new InventoryRitualKit(invStack);
            output.add(new Pair((Object)kit, (Object)Direction.UP));
        });
        for (int i = 0; i < caster.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = caster.m_150109_().m_8020_(i);
            if (invStack.m_41619_() || !(invStack.m_41720_() instanceof ItemPractitionersPouch)) continue;
            ItemPractitionersPouch item = (ItemPractitionersPouch)invStack.m_41720_();
            Pair<IItemHandler, Direction> remoteInv = item.resolveRemoteInventory(invStack, caster.m_9236_());
            if (remoteInv.getFirst() != null) {
                output.add(remoteInv);
            }
            if (item.getPatchLevel(invStack, PractitionersPouchPatches.RIFT) > 0) {
                caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> output.add(new Pair((Object)new InvWrapper((Container)m.getRiftInventory()), (Object)Direction.UP)));
            }
            InventoryRitualKit kit = new InventoryRitualKit(invStack);
            output.add((Pair<IItemHandler, Direction>)new Pair((Object)kit, (Object)Direction.UP));
        }
        output.add(new Pair((Object)new InvWrapper((Container)caster.m_150109_()), (Object)Direction.UP));
        return output;
    }

    private static final HashMap<Item, Boolean> checkReagents(Player caster, InteractionHand hand, SpellRecipe recipe) {
        HashMap<Item, Boolean> missing = new HashMap<Item, Boolean>();
        if (caster.m_7500_()) {
            return missing;
        }
        List<Pair<IItemHandler, Direction>> inventories = SpellCaster.getReagentSearchInventories(caster);
        for (SpellReagent reagent : recipe.getReagents(caster, hand, null)) {
            if (InventoryUtilities.consumeAcrossInventories(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT(), true, inventories)) continue;
            missing.put(reagent.getReagentStack().m_41720_(), reagent.getOptional());
        }
        return missing;
    }

    public static final boolean consumeReagents(Player caster, InteractionHand hand, List<SpellReagent> reagents) {
        if (caster.m_7500_() || caster.m_9236_().m_5776_()) {
            return true;
        }
        List<Pair<IItemHandler, Direction>> inventories = SpellCaster.getReagentSearchInventories(caster);
        boolean output = true;
        for (SpellReagent reagent : reagents) {
            output &= InventoryUtilities.consumeAcrossInventories(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT(), false, inventories);
        }
        return output;
    }

    public static final boolean consumeReagents(Player caster, InteractionHand hand, ISpellDefinition recipe, SpellCastingResult componentResults) {
        if (caster.m_7500_() || caster.m_9236_().m_5776_()) {
            return true;
        }
        List<Pair<IItemHandler, Direction>> inventories = SpellCaster.getReagentSearchInventories(caster);
        boolean output = true;
        for (SpellReagent reagent : recipe.getReagents(caster, hand, componentResults)) {
            if (!reagent.getConsume()) continue;
            output &= InventoryUtilities.consumeAcrossInventories(reagent.getReagentStack(), reagent.getIgnoreDurability(), reagent.getCompareNBT(), false, inventories);
        }
        return output;
    }

    @Override
    public SpellCastingResult affect(ItemStack stack, ISpellDefinition spell, Level world, SpellSource source) {
        return SpellCaster.Affect(stack, spell, world, source, null, null);
    }

    @Override
    public SpellCastingResult affect(ItemStack stack, ISpellDefinition spell, Level world, SpellSource source, SpellTarget targetHint) {
        return SpellCaster.Affect(stack, spell, world, source, targetHint, null);
    }

    @Override
    public SpellCastingResult affect(ItemStack stack, ISpellDefinition spell, Level world, SpellSource source, SpellTarget targetHint, SpellContext context) {
        return SpellCaster.Affect(stack, spell, world, source, targetHint, context);
    }

    @Override
    public ISpellDefinition createSpell(Shape shape, SpellEffect component, Modifier ... modifiers) {
        SpellRecipe recipe = new SpellRecipe();
        recipe.setShape(shape);
        recipe.addComponent(component);
        for (int i = 0; i < Math.min(3, modifiers.length); ++i) {
            recipe.setModifier(modifiers[i], i);
        }
        return recipe;
    }

    @Override
    public ISpellDefinition parseSpellDefinition(ItemStack stack) {
        return this.parseSpellDefinition(stack, null);
    }

    @Override
    public ISpellDefinition parseSpellDefinition(ItemStack stack, @Nullable Player player) {
        CompoundTag tag = stack.m_41784_();
        if (stack.m_41720_() == ItemInit.ROTE_BOOK.get()) {
            tag = player == null ? ((ItemBookOfRote)ItemInit.ROTE_BOOK.get()).getSelectedStack(stack, player).m_41784_() : ((ItemBookOfRote)ItemInit.ROTE_BOOK.get()).getSpellCompound(stack, player);
        }
        return SpellRecipe.fromNBT(tag);
    }

    @Override
    public SpellCastingResult playerCast(ItemStack stack, Player caster, InteractionHand hand, boolean consumeMana, boolean isCurioCast) {
        return SpellCaster.PlayerCast(stack, caster, hand, caster.m_20182_(), caster.m_20154_(), caster.m_9236_(), consumeMana, isCurioCast);
    }

    @Override
    public void writeSpellDefinition(ISpellDefinition spell, ItemStack stack) {
        spell.writeToNBT(stack.m_41784_());
    }

    @Override
    public void registerSpellCastingItem(Item item) {
        _cooldownItems.add(item);
    }

    @Override
    public void registerSpellAdjuster(Predicate<SpellAdjustingContext> predicate, BiConsumer<ISpellDefinition, LivingEntity> adjuster) {
        SpellCaster.registerAdjuster(predicate, adjuster);
    }

    @Override
    public void registerSpellAdjuster(Predicate<SpellAdjustingContext> predicate, Consumer<SpellAdjustingContext> adjuster) {
        SpellCaster.registerAdjuster(predicate, adjuster);
    }

    @Override
    public IForgeRegistry<Shape> getShapeRegistry() {
        return Registries.Shape.get();
    }

    @Override
    public IForgeRegistry<SpellEffect> getComponentRegistry() {
        return Registries.SpellEffect.get();
    }

    @Override
    public IForgeRegistry<Modifier> getModifierRegistry() {
        return Registries.Modifier.get();
    }

    @Override
    public boolean containsSpell(ItemStack stack) {
        return SpellRecipe.stackContainsSpell(stack);
    }

    @Override
    public boolean reflectSpell(Level level, @Nullable LivingEntity reflector, ISpellDefinition spell, SpellSource source, Vec3 position, Vec3 forward, boolean forwardOnly) {
        if (!spell.isValid()) {
            return true;
        }
        if (!source.hasCasterReference()) {
            return true;
        }
        Vec3 direction = position.m_82546_(source.getOrigin()).m_82541_();
        float angleDeg = (float)(Math.acos(forward.m_82526_(direction)) * 180.0 / Math.PI);
        if (!forwardOnly || angleDeg > 120.0f && angleDeg < 170.0f) {
            if (!level.m_5776_()) {
                Vec3 reflect = MathUtils.reflect(forward, direction);
                Shape shape = spell.getShape().getPart();
                CompoundTag spellData = new CompoundTag();
                spell.writeToNBT(spellData);
                if (shape != Shapes.BEAM) {
                    if (shape == Shapes.PROJECTILE) {
                        SpellProjectile newProjectile = new SpellProjectile(reflector, level);
                        newProjectile.setSpellRecipe(spellData);
                        newProjectile.shoot((Entity)reflector, reflect, 1.0f, 0.1f);
                        level.m_7967_((Entity)newProjectile);
                    } else if (shape == Shapes.BOLT) {
                        ServerMessageDispatcher.sendParticleSpawn(position.m_7096_(), position.m_7098_(), position.m_7094_(), position.m_7096_() + reflect.f_82479_ * 8.0, position.m_7098_() + reflect.f_82480_ * 8.0, position.m_7094_() + reflect.f_82481_ * 8.0, 0, 64.0f, (ResourceKey<Level>)level.m_46472_(), (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()));
                    }
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void spawnSpellVFX(Level world, Vec3 position, Vec3 normal, SpellSource source, SpellEffect part) {
        SpellCaster.spawnClientFX(world, position, normal, source, part);
    }

    @Override
    public void setCooldown(ItemStack stack, Player player, ISpellDefinition spell) {
        SpellCaster.setCooldown(stack, player, spell.getCooldown((LivingEntity)player));
    }

    static {
        _cooldownItems.add((Item)ItemInit.SPELL.get());
        _cooldownItems.add((Item)ItemInit.SPELL_BOOK.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_COUNCIL.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_DEMON.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_FEY.get());
        _cooldownItems.add((Item)ItemInit.GRIMOIRE_UNDEAD.get());
        _cooldownItems.add((Item)ItemInit.ROTE_BOOK.get());
        _cooldownItems.add((Item)ItemInit.PUNKIN_STAFF.get());
        _cooldownItems.add((Item)ItemInit.STAFF_AMETHYST.get());
        _cooldownItems.add((Item)ItemInit.STAFF_AUM.get());
        _cooldownItems.add((Item)ItemInit.STAFF_CERUBLOSSOM.get());
        _cooldownItems.add((Item)ItemInit.STAFF_CHIMERITE.get());
        _cooldownItems.add((Item)ItemInit.STAFF_DESERTNOVA.get());
        _cooldownItems.add((Item)ItemInit.STAFF_EMERALD.get());
        _cooldownItems.add((Item)ItemInit.STAFF_GLASS.get());
        _cooldownItems.add((Item)ItemInit.STAFF_GOLD.get());
        _cooldownItems.add((Item)ItemInit.STAFF_IRON.get());
        _cooldownItems.add((Item)ItemInit.STAFF_LAPIS.get());
        _cooldownItems.add((Item)ItemInit.STAFF_NETHERQUARTZ.get());
        _cooldownItems.add((Item)ItemInit.STAFF_PRISMARINECRYSTAL.get());
        _cooldownItems.add((Item)ItemInit.STAFF_PRISMARINESHARD.get());
        _cooldownItems.add((Item)ItemInit.STAFF_REDSTONE.get());
        _cooldownItems.add((Item)ItemInit.STAFF_SKULL.get());
        _cooldownItems.add((Item)ItemInit.STAFF_TARMA.get());
        _cooldownItems.add((Item)ItemInit.STAFF_VINTEUM.get());
        _cooldownItems.add((Item)ItemInit.STAFF_WAKEBLOOM.get());
        _cooldownItems.add((Item)ItemInit.WAND_AMETHYST.get());
        _cooldownItems.add((Item)ItemInit.WAND_AUM.get());
        _cooldownItems.add((Item)ItemInit.WAND_CERUBLOSSOM.get());
        _cooldownItems.add((Item)ItemInit.WAND_CHIMERITE.get());
        _cooldownItems.add((Item)ItemInit.WAND_DESERTNOVA.get());
        _cooldownItems.add((Item)ItemInit.WAND_EMERALD.get());
        _cooldownItems.add((Item)ItemInit.WAND_GLASS.get());
        _cooldownItems.add((Item)ItemInit.WAND_GOLD.get());
        _cooldownItems.add((Item)ItemInit.WAND_IRON.get());
        _cooldownItems.add((Item)ItemInit.WAND_LAPIS.get());
        _cooldownItems.add((Item)ItemInit.WAND_NETHERQUARTZ.get());
        _cooldownItems.add((Item)ItemInit.WAND_PRISMARINECRYSTAL.get());
        _cooldownItems.add((Item)ItemInit.WAND_PRISMARINESHARD.get());
        _cooldownItems.add((Item)ItemInit.WAND_REDSTONE.get());
        _cooldownItems.add((Item)ItemInit.WAND_SKULL.get());
        _cooldownItems.add((Item)ItemInit.WAND_TARMA.get());
        _cooldownItems.add((Item)ItemInit.WAND_VINTEUM.get());
        _cooldownItems.add((Item)ItemInit.WAND_WAKEBLOOM.get());
        _cooldownItems.add((Item)ItemInit.HELLFIRE_STAFF.get());
        _cooldownItems.add((Item)ItemInit.ASTRO_BLADE.get());
    }
}

