/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.capabilities.IRitualTeleportLocation;
import com.mna.api.capabilities.IWorldMagic;
import com.mna.api.faction.IFaction;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.Portal;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemWorldCharm;
import com.mna.tools.TeleportHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualEffectGate
extends RitualEffect {
    public RitualEffectGate(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        List<ItemStack> reagents = context.getCollectedReagents();
        if (reagents.size() == 11 && !context.getLevel().f_46443_) {
            ServerLevel targetWorld;
            ResourceKey worldKey;
            ItemStack reagentNine = reagents.get(9);
            ResourceKey resourceKey = worldKey = !reagentNine.m_41619_() && reagentNine.m_41720_() instanceof ItemWorldCharm ? ((ItemWorldCharm)reagentNine.m_41720_()).GetWorldTarget(reagentNine) : context.getLevel().m_46472_();
            if (worldKey == null) {
                worldKey = context.getLevel().m_46472_();
            }
            if ((targetWorld = TeleportHelper.resolveRegistryKey((ServerLevel)context.getLevel(), worldKey.m_135782_())) == null) {
                context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/return.world_not_found"));
                return false;
            }
            LazyOptional worldMagicContainer = targetWorld.getCapability(WorldMagicProvider.MAGIC);
            if (worldMagicContainer.isPresent()) {
                IWorldMagic worldMagic = (IWorldMagic)worldMagicContainer.orElse(null);
                ItemStack reagentEight = reagents.get(8);
                DyeColor portalColor = null;
                boolean rtp = false;
                if (!reagentEight.m_41619_()) {
                    DyeColor dyeColor = portalColor = reagentEight.m_41720_() instanceof DyeItem ? ((DyeItem)reagents.get(8).m_41720_()).m_41089_() : null;
                    if (reagentEight.m_41720_() == ItemInit.GREATER_MOTE_ENDER.get()) {
                        rtp = true;
                    }
                }
                ArrayList<ResourceLocation> runes = new ArrayList<ResourceLocation>();
                for (int i = 0; i < 8; ++i) {
                    runes.add(ForgeRegistries.ITEMS.getKey((Object)reagents.get(i).m_41720_()));
                }
                IRitualTeleportLocation teleportTarget = worldMagic.getRitualTeleportBlockLocation(runes, (ResourceKey<Level>)worldKey);
                if (teleportTarget == null && !rtp) {
                    context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/return.not_found"));
                    return false;
                }
                Portal portal = new Portal((EntityType)EntityInit.PORTAL_ENTITY.get(), context.getLevel());
                portal.m_146884_(Vec3.m_82539_((Vec3i)context.getCenter()));
                if (!rtp) {
                    portal.setTeleportBlockPos(teleportTarget.getPos().m_7494_(), teleportTarget.getWorldType());
                }
                portal.setPermanent();
                if (portalColor != null) {
                    portal.setDyeColor(portalColor);
                }
                if (rtp) {
                    portal.setRTP();
                }
                if (context.getCaster() != null) {
                    IPlayerProgression p = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                    IPlayerMagic m = (IPlayerMagic)context.getCaster().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
                    if (p != null && m != null && p.hasAlliedFaction()) {
                        IFaction faction = p.getAlliedFaction();
                        int idx = 0;
                        ResourceLocation castingResource = m.getCastingResource().getRegistryName();
                        for (int i = 0; i < p.getAlliedFaction().getCastingResources().length; i = (int)((byte)(i + 1))) {
                            if (!faction.getCastingResources()[i].equals((Object)castingResource)) continue;
                            idx = i;
                            break;
                        }
                        portal.setRenderData(p.getAlliedFaction(), (byte)idx);
                    }
                }
                context.getLevel().m_7967_((Entity)portal);
                return true;
            }
        }
        return false;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

