/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.FlatLands;
import com.mna.items.ItemInit;
import com.mna.items.runes.ItemRuneMarking;
import com.mna.tools.math.MathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RitualEffectFlatLands
extends RitualEffect {
    public static final int MAX_DISTANCE = 80;

    public RitualEffectFlatLands(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        ItemStack location_rune_a = ItemStack.f_41583_;
        ItemStack location_rune_b = ItemStack.f_41583_;
        for (ItemStack stack : context.getCollectedReagents(i -> i.m_41720_() == ItemInit.RUNE_MARKING.get())) {
            if (location_rune_a.m_41619_()) {
                location_rune_a = stack;
                continue;
            }
            location_rune_b = stack;
            break;
        }
        if (location_rune_a.m_41619_() || location_rune_b.m_41619_()) {
            this.dropCollectedReagents(context);
            return false;
        }
        BlockPos location_a = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(location_rune_a);
        BlockPos location_b = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(location_rune_b);
        if (location_a == null || location_b == null) {
            this.dropCollectedReagents(context);
            return false;
        }
        if (!location_a.m_123314_((Vec3i)context.getCenter(), 80.0) && !location_b.m_123314_((Vec3i)context.getCenter(), 80.0)) {
            context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/flat_lands.tooFar"));
            this.dropCollectedReagents(context);
            return false;
        }
        AABB bb = MathUtils.createInclusiveBB(location_a, location_b);
        if (bb.m_82362_() > 80.0 || bb.m_82376_() > 80.0 || bb.m_82385_() > 80.0) {
            context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/flat_lands.tooBig"));
            this.dropCollectedReagents(context);
            return false;
        }
        FlatLands flat_lands = new FlatLands((EntityType)EntityInit.FLAT_LANDS.get(), context.getLevel());
        flat_lands.m_146884_(Vec3.m_82512_((Vec3i)context.getCenter().m_6630_(2)));
        flat_lands.setCaster(context.getCaster());
        flat_lands.setBounds(bb);
        context.getLevel().m_7967_((Entity)flat_lands);
        return true;
    }

    private void dropCollectedReagents(IRitualContext context) {
        Vec3 drop = Vec3.m_82512_((Vec3i)context.getCenter().m_7494_());
        context.getCollectedReagents().forEach(is -> {
            ItemEntity ie = new ItemEntity(context.getLevel(), drop.f_82479_, drop.f_82480_, drop.f_82481_, is);
            context.getLevel().m_7967_((Entity)ie);
        });
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }
}

