/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.factions.Factions;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemEntityCrystal;
import com.mna.tools.EntityUtil;
import com.mna.tools.SummonUtils;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class RitualEffectConsumeCrystalSoul
extends RitualEffect {
    public RitualEffectConsumeCrystalSoul(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public Component canRitualStart(IRitualContext context) {
        if (context.getCaster() == null) {
            return Component.m_237113_((String)"No player reference found for ritual, aborting.");
        }
        IPlayerProgression p = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (p == null || p.getAlliedFaction() != Factions.UNDEAD) {
            return Component.m_237115_((String)"mna:rituals/consume_crystal_soul.not_undead");
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        ItemStack crystalStack = ItemStack.f_41583_;
        for (ItemStack stack : context.getCollectedReagents()) {
            if (stack.m_41720_() != ItemInit.ENTITY_ENTRAPMENT_CRYSTAL.get()) continue;
            crystalStack = stack;
            break;
        }
        if (crystalStack.m_41619_() || ItemEntityCrystal.getEntityType(crystalStack) == null) {
            context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/consume_crystal_soul.crystal_empty"));
            return false;
        }
        Entity e = ItemEntityCrystal.restoreEntity(context.getLevel(), crystalStack);
        if (SummonUtils.isSummon(e)) {
            context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/consume_crystal_soul.no_summons"));
            return false;
        }
        float souls = EntityUtil.getSoulsRestored(context.getCaster(), e) * 20.0f;
        context.getCaster().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().restore(souls));
        Vec3 center = Vec3.m_82512_((Vec3i)context.getCenter());
        ItemEntity itemEntity = new ItemEntity(context.getLevel(), center.f_82479_, center.f_82480_, center.f_82481_, new ItemStack((ItemLike)Items.f_42415_));
        context.getLevel().m_7967_((Entity)itemEntity);
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

