/*
 * Decompiled with CFR 0.152.
 */
package com.mna.particles.emitter;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.particles.types.movers.ParticleBezierMover;
import com.mna.particles.types.movers.ParticleLerpMover;
import com.mna.particles.types.movers.ParticleOrbitMover;
import com.mna.particles.types.movers.ParticleSphereOrbitMover;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EmitterData {
    public int[] rgbStart = new int[]{-1, -1, -1, 255};
    public float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
    public float[] offset = new float[]{0.0f, 0.0f, 0.0f};
    public float[] target = new float[]{0.0f, 0.0f, 0.0f};
    public float[] spread = new float[]{0.0f, 0.0f, 0.0f};
    public float scale = 0.25f;
    public float gravity;
    public int amount = 1;
    public int rate = 1;
    public int age;
    public boolean randomColor;
    public boolean randomSpeed;
    public boolean randomTarget;
    public boolean randomScale;
    public boolean collision;
    public boolean mirror;
    public boolean enabled = false;
    public boolean showInFirstPerson;
    public ParticleControllerTypes controller = ParticleControllerTypes.VELOCITY;
    public ParticleTypes type = ParticleTypes.FLAME;

    public CompoundTag getTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_("rgbStart", this.rgbStart);
        this.writeFloatArray(tag, "velocity", this.velocity);
        this.writeFloatArray(tag, "offset", this.offset);
        this.writeFloatArray(tag, "target", this.target);
        this.writeFloatArray(tag, "spread", this.spread);
        tag.m_128350_("scale", this.scale);
        tag.m_128350_("gravity", this.gravity);
        tag.m_128405_("amount", this.amount);
        tag.m_128405_("age", this.age);
        tag.m_128405_("rate", this.rate);
        tag.m_128379_("randomColor", this.randomColor);
        tag.m_128379_("randomSpeed", this.randomSpeed);
        tag.m_128379_("randomTarget", this.randomTarget);
        tag.m_128379_("randomScale", this.randomScale);
        tag.m_128379_("collision", this.collision);
        tag.m_128379_("mirror", this.mirror);
        tag.m_128379_("enabled", this.enabled);
        tag.m_128379_("showInFirstPerson", this.showInFirstPerson);
        tag.m_128359_("controller", this.controller.name());
        tag.m_128359_("type", this.type.name());
        return tag;
    }

    public static EmitterData fromTag(CompoundTag tag) {
        EmitterData inst = new EmitterData();
        if (tag.m_128441_("rgbStart")) {
            inst.rgbStart = tag.m_128465_("rgbStart");
        }
        if (inst.rgbStart.length < 4) {
            inst.rgbStart = new int[4];
        }
        inst.velocity = EmitterData.readFloatArray(tag, "velocity", 3);
        inst.offset = EmitterData.readFloatArray(tag, "offset", 3);
        inst.target = EmitterData.readFloatArray(tag, "target", 3);
        inst.spread = EmitterData.readFloatArray(tag, "spread", 3);
        if (tag.m_128441_("scale")) {
            inst.scale = tag.m_128457_("scale");
        }
        if (tag.m_128441_("gravity")) {
            inst.gravity = tag.m_128457_("gravity");
        }
        if (tag.m_128441_("age")) {
            inst.age = tag.m_128451_("age");
        }
        if (tag.m_128441_("rate")) {
            inst.rate = tag.m_128451_("rate");
        }
        if (tag.m_128441_("amount")) {
            inst.amount = tag.m_128451_("amount");
        }
        if (tag.m_128441_("randomColor")) {
            inst.randomColor = tag.m_128471_("randomColor");
        }
        if (tag.m_128441_("randomSpeed")) {
            inst.randomSpeed = tag.m_128471_("randomSpeed");
        }
        if (tag.m_128441_("randomTarget")) {
            inst.randomTarget = tag.m_128471_("randomTarget");
        }
        if (tag.m_128441_("randomScale")) {
            inst.randomScale = tag.m_128471_("randomScale");
        }
        if (tag.m_128441_("collision")) {
            inst.collision = tag.m_128471_("collision");
        }
        if (tag.m_128441_("mirror")) {
            inst.mirror = tag.m_128471_("mirror");
        }
        if (tag.m_128441_("enabled")) {
            inst.enabled = tag.m_128471_("enabled");
        }
        if (tag.m_128441_("showInFirstPerson")) {
            inst.showInFirstPerson = tag.m_128471_("showInFirstPerson");
        }
        if (tag.m_128441_("controller")) {
            inst.controller = ParticleControllerTypes.valueOf(tag.m_128461_("controller"));
        }
        if (tag.m_128441_("type")) {
            inst.type = ParticleTypes.valueOf(tag.m_128461_("type"));
        }
        return inst;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawn(Level world, Vec3 origin, Vec3 forward) {
        if (!this.enabled || Minecraft.m_91087_().m_91104_() || this.rate < 1) {
            return;
        }
        if (world.m_46467_() % (long)this.rate != 0L) {
            return;
        }
        if (this.mirror) {
            int i = 0;
            while ((double)i < Math.ceil((float)this.amount / 2.0f)) {
                this.spawnSingleParticle(world, origin, forward, false);
                this.spawnSingleParticle(world, origin, forward, true);
                ++i;
            }
        } else {
            for (int i = 0; i < this.amount; ++i) {
                this.spawnSingleParticle(world, origin, forward, false);
            }
        }
    }

    private void spawnSingleParticle(Level world, Vec3 origin, Vec3 forward, boolean mirror) {
        MAParticleType pfx = this.getPFX();
        if (pfx == null) {
            return;
        }
        switch (this.controller) {
            case ORBIT: 
            case RING: {
                forward = new Vec3(1.0, 0.0, 0.0);
            }
        }
        if (this.randomColor) {
            pfx.setColor(Math.random() * 255.0, Math.random() * 255.0, Math.random() * 255.0);
        }
        if (this.rgbStart.length == 3) {
            pfx.setColor(this.rgbStart[0], this.rgbStart[1], this.rgbStart[2]);
        } else if (this.rgbStart.length == 4) {
            pfx.setColor(this.rgbStart[0], this.rgbStart[1], this.rgbStart[2], this.rgbStart[3]);
        }
        if (this.randomScale) {
            pfx.setScale((float)Math.random() * this.scale);
        } else {
            pfx.setScale(this.scale);
        }
        pfx.setGravity(this.gravity / 50.0f);
        if (this.age > 0) {
            pfx.setMaxAge(this.age);
        }
        pfx.setPhysics(this.collision);
        Vec3 side = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        Vec3 paramOffset = this.computeVec3(this.offset, this.spread);
        if (mirror) {
            paramOffset = new Vec3(paramOffset.f_82479_ * -1.0, paramOffset.f_82480_, paramOffset.f_82481_);
        }
        Vec3 xOffset = side.m_82490_(paramOffset.f_82481_);
        Vec3 zOffset = forward.m_82490_(paramOffset.f_82479_);
        Vec3 spawnPos = origin.m_82520_(0.0, paramOffset.f_82480_, 0.0).m_82549_(xOffset).m_82549_(zOffset);
        Vec3 paramVel = this.computeVec3(this.velocity, this.randomSpeed);
        if (mirror) {
            paramVel = new Vec3(paramVel.f_82479_ * -1.0, paramVel.f_82480_, paramVel.f_82481_);
        }
        Vec3 xVel = side.m_82490_(paramVel.f_82479_);
        Vec3 zVel = forward.m_82490_(paramVel.f_82481_);
        Vec3 vel = xVel.m_82549_(zVel).m_82520_(0.0, paramVel.f_82480_, 0.0);
        if (this.type != ParticleTypes.LIGHTNING) {
            switch (this.controller) {
                case BEZIER: {
                    Vec3 targetPos = origin.m_82549_(this.computeVec3(this.target, this.randomTarget ? this.spread : null));
                    if (mirror) {
                        targetPos = new Vec3(targetPos.f_82479_ * -1.0, targetPos.f_82480_, targetPos.f_82481_);
                    }
                    pfx.setMover(new ParticleBezierMover(spawnPos, targetPos));
                    break;
                }
                case LERP: {
                    Vec3 targetPos = origin.m_82549_(this.computeVec3(this.target, this.randomTarget ? this.spread : null));
                    if (mirror) {
                        targetPos = new Vec3(targetPos.f_82479_ * -1.0, targetPos.f_82480_, targetPos.f_82481_);
                    }
                    pfx.setMover(new ParticleLerpMover(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_));
                    break;
                }
                case ORBIT: {
                    pfx.setMover(new ParticleOrbitMover(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_));
                    break;
                }
                case RING: {
                    pfx.setMover(new ParticleSphereOrbitMover(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, vel.f_82479_, vel.f_82480_ * 180.0, vel.f_82481_));
                    break;
                }
            }
            world.m_7106_((ParticleOptions)pfx, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        } else {
            Vec3 targetPos = origin.m_82549_(this.computeVec3(this.target, this.randomTarget ? this.spread : null));
            if (mirror) {
                targetPos = new Vec3(targetPos.f_82479_ * -1.0, targetPos.f_82480_, targetPos.f_82481_);
            }
            world.m_7106_((ParticleOptions)pfx, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
        }
    }

    private Vec3 computeVec3(float[] array, float[] spread) {
        if (spread == null) {
            return new Vec3((double)array[0], (double)array[1], (double)array[2]);
        }
        return new Vec3((double)(-spread[0] + array[0]) + (double)(spread[0] * 2.0f) * Math.random(), (double)(-spread[1] + array[1]) + (double)(spread[1] * 2.0f) * Math.random(), (double)(-spread[2] + array[2]) + (double)(spread[2] * 2.0f) * Math.random());
    }

    private Vec3 computeVec3(float[] array, boolean random) {
        if (random) {
            return new Vec3((double)array[0] * Math.random(), (double)array[1] * Math.random(), (double)array[2] * Math.random());
        }
        return new Vec3((double)array[0], (double)array[1], (double)array[2]);
    }

    private static float[] readFloatArray(CompoundTag tag, String key, int minLength) {
        if (!tag.m_128441_(key)) {
            return new float[minLength];
        }
        CompoundTag subElem = tag.m_128469_(key);
        int len = subElem.m_128451_("length");
        float[] output = new float[Math.max(len, minLength)];
        for (int i = 0; i < len; ++i) {
            output[i] = subElem.m_128457_("e" + i);
        }
        return output;
    }

    private void writeFloatArray(CompoundTag tag, String key, float[] value) {
        CompoundTag subElem = new CompoundTag();
        subElem.m_128405_("length", value.length);
        for (int i = 0; i < value.length; ++i) {
            subElem.m_128350_("e" + i, value[i]);
        }
        tag.m_128365_(key, (Tag)subElem);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private MAParticleType getPFX() {
        switch (this.type) {
            case AIR: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get()));
            }
            case ARCANE: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get()));
            }
            case BLUEFLAME: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_FLAME.get()));
            }
            case BLUESPARKLE: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get()));
            }
            case BONE: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BONE.get()));
            }
            case COZY_SMOKE: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.COZY_SMOKE.get()));
            }
            case DRIP: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DRIP.get()));
            }
            case DUST: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get()));
            }
            case EARTH: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get()));
            }
            case ENCHANT: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENCHANT.get()));
            }
            case ENDER: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get()));
            }
            case FLAME: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get()));
            }
            case FROST: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get()));
            }
            case GLOW: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.GLOW.get()));
            }
            case HEART: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HEART.get()));
            }
            case LIGHTNING: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get()));
            }
            case MAGELIGHT: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get()));
            }
            case SOUL: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SOUL.get()));
            }
            case SPARKLE: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get()));
            }
            case TRAIL: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL_VELOCITY.get()));
            }
            case WATER: {
                return new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get()));
            }
        }
        return null;
    }

    public static enum ParticleControllerTypes {
        VELOCITY,
        ORBIT,
        RING,
        LERP,
        BEZIER;

    }

    public static enum ParticleTypes {
        AIR,
        ARCANE,
        BLUEFLAME,
        BLUESPARKLE,
        BONE,
        COZY_SMOKE,
        DRIP,
        DUST,
        EARTH,
        ENCHANT,
        ENDER,
        FLAME,
        FROST,
        GLOW,
        HEART,
        LIGHTNING,
        MAGELIGHT,
        SOUL,
        SPARKLE,
        TRAIL,
        WATER;

    }
}

