/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.items.sorcery.ItemSpellBook;
import com.mna.network.messages.BaseServerMessage;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import top.theillusivec4.curios.api.SlotContext;

public class SpellBookSlotChangeMessage
extends BaseServerMessage {
    private int slot;
    private InteractionHand hand;
    private SlotContext context;

    public SpellBookSlotChangeMessage(int slot, InteractionHand hand, @Nullable SlotContext context) {
        this.slot = slot;
        this.hand = hand;
        this.context = context;
        this.messageIsValid = true;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Nullable
    public SlotContext getContext() {
        return this.context;
    }

    public int getSlot() {
        return this.slot;
    }

    public SpellBookSlotChangeMessage() {
        this.messageIsValid = false;
    }

    public static SpellBookSlotChangeMessage decode(FriendlyByteBuf buf) {
        SpellBookSlotChangeMessage msg = new SpellBookSlotChangeMessage();
        try {
            msg.slot = buf.readInt();
            msg.hand = InteractionHand.values()[buf.readInt() % InteractionHand.values().length];
            if (buf.readBoolean()) {
                msg.context = new SlotContext(buf.m_130277_(), null, buf.readInt(), false, false);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ManaweavePatternDrawnMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SpellBookSlotChangeMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.slot);
        buf.writeInt(msg.hand.ordinal());
        if (msg.context != null) {
            buf.writeBoolean(true);
            buf.m_130070_(msg.context.getIdentifier());
            buf.writeInt(msg.context.getIndex());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        ItemSpellBook.handleSlotChangeMessage(this, player);
    }
}

