/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemModifierBook;
import com.mna.network.messages.BaseServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class SelectedModifierMessage
extends BaseServerMessage {
    private ResourceLocation modifierRLoc;
    private boolean offhand;

    public SelectedModifierMessage(ResourceLocation modifierRLoc, boolean offhand) {
        this.modifierRLoc = modifierRLoc;
        this.offhand = offhand;
        this.messageIsValid = true;
    }

    public SelectedModifierMessage() {
        this.messageIsValid = false;
    }

    public ResourceLocation getModifierRLoc() {
        return this.modifierRLoc;
    }

    public boolean isOffhand() {
        return this.offhand;
    }

    public static SelectedModifierMessage decode(FriendlyByteBuf buf) {
        SelectedModifierMessage msg = new SelectedModifierMessage();
        try {
            msg.modifierRLoc = buf.m_130281_();
            msg.offhand = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading SelectedModifierMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SelectedModifierMessage msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.modifierRLoc);
        buf.writeBoolean(msg.isOffhand());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        ItemStack stack;
        ItemStack itemStack = stack = this.isOffhand() ? player.m_21206_() : player.m_21205_();
        if (stack.m_41720_() == ItemInit.MODIFIER_BOOK.get()) {
            ItemModifierBook.setModifier(stack, this.getModifierRLoc());
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Error setting selected modifier, couldn't verify held item"));
        }
    }
}

