/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.network.ServerMessageDispatcher;
import com.mna.network.messages.BaseServerMessage;
import com.mna.recipes.multiblock.MultiblockDefinition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class MultiblockSyncRequestMessage
extends BaseServerMessage {
    private int entityID;
    private ResourceLocation recipeID;

    private MultiblockSyncRequestMessage() {
        this.messageIsValid = false;
    }

    public MultiblockSyncRequestMessage(int entityID, ResourceLocation recipe) {
        this();
        this.entityID = entityID;
        this.recipeID = recipe;
        this.messageIsValid = true;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public ResourceLocation getRecipe() {
        return this.recipeID;
    }

    public static MultiblockSyncRequestMessage decode(FriendlyByteBuf buf) {
        MultiblockSyncRequestMessage msg = new MultiblockSyncRequestMessage();
        try {
            msg.entityID = buf.readInt();
            msg.recipeID = buf.m_130281_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MultiblockSyncRequestMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(MultiblockSyncRequestMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getEntityID());
        buf.m_130085_(msg.getRecipe());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        Entity entity = player.m_9236_().m_6815_(this.getEntityID());
        if (entity != null && entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            entity.m_9236_().m_7465_().m_44043_(this.getRecipe()).ifPresent(r -> {
                if (r instanceof MultiblockDefinition) {
                    MultiblockDefinition mbd = (MultiblockDefinition)r;
                    ServerMessageDispatcher.sendStructureSyncMessage(mbd, serverPlayer);
                }
            });
        }
    }
}

