/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.items.artifice.ItemEnderDisk;
import com.mna.network.messages.BaseServerMessage;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class EnderDiscPatternSetMessage
extends BaseServerMessage {
    private ArrayList<ResourceLocation> patterns;
    private ResourceLocation dimensionID;
    private int patternIndex;
    private String name;

    public EnderDiscPatternSetMessage(ArrayList<ResourceLocation> patterns, ResourceLocation dimensionID, int patternIndex, String name) {
        this.patterns = patterns;
        this.patternIndex = patternIndex;
        this.dimensionID = dimensionID;
        this.name = name;
        this.messageIsValid = true;
    }

    public EnderDiscPatternSetMessage() {
        this.messageIsValid = false;
    }

    public ArrayList<ResourceLocation> getPatterns() {
        return this.patterns;
    }

    public int getIndex() {
        return this.patternIndex;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getDimensionID() {
        return this.dimensionID;
    }

    public static EnderDiscPatternSetMessage decode(FriendlyByteBuf buf) {
        EnderDiscPatternSetMessage msg = new EnderDiscPatternSetMessage();
        try {
            msg.patternIndex = buf.readInt();
            msg.name = buf.m_130136_(Short.MAX_VALUE);
            msg.dimensionID = buf.m_130281_();
            int count = buf.readInt();
            msg.patterns = new ArrayList();
            for (int i = 0; i < count; ++i) {
                msg.patterns.add(buf.m_130281_());
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading EnderDiscPatternSetMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(EnderDiscPatternSetMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getIndex());
        buf.m_130070_(msg.getName());
        buf.m_130085_(msg.getDimensionID());
        buf.writeInt(msg.getPatterns().size());
        for (ResourceLocation rLoc : msg.getPatterns()) {
            buf.m_130085_(rLoc);
        }
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        ItemEnderDisk.setPattern(player.m_150109_().m_36056_(), this.getPatterns(), this.getDimensionID(), this.getIndex(), this.getName());
    }
}

