/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.api.items.IAreaItem;
import com.mna.network.messages.BaseServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class AdjustAreaMessage
extends BaseServerMessage {
    private Vector3f direction;
    private boolean grow;

    public AdjustAreaMessage(Vector3f direction, boolean grow) {
        this.direction = direction;
        this.grow = grow;
        this.messageIsValid = true;
    }

    public AdjustAreaMessage() {
        this.messageIsValid = false;
    }

    public static AdjustAreaMessage decode(FriendlyByteBuf buf) {
        AdjustAreaMessage msg = new AdjustAreaMessage();
        try {
            msg.direction = buf.m_269394_();
            msg.grow = buf.readBoolean();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading AdjustAreaMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(AdjustAreaMessage msg, FriendlyByteBuf buf) {
        buf.m_269582_(msg.direction);
        buf.writeBoolean(msg.grow);
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        ItemStack held = player.m_21205_();
        Item item = held.m_41720_();
        if (item instanceof IAreaItem) {
            IAreaItem areaItem = (IAreaItem)item;
            areaItem.adjust(held, this.direction, this.grow);
        }
    }
}

