/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.entities.rituals.Ritual;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SetRitualCollectedReagentsMessage
extends BaseClientMessage {
    CompoundTag reagentData;
    int entityID;

    public SetRitualCollectedReagentsMessage(CompoundTag data, int entityID) {
        this.reagentData = data;
        this.entityID = entityID;
        this.messageIsValid = true;
    }

    public SetRitualCollectedReagentsMessage() {
        this.messageIsValid = false;
    }

    public static SetRitualCollectedReagentsMessage decode(FriendlyByteBuf buf) {
        SetRitualCollectedReagentsMessage msg = new SetRitualCollectedReagentsMessage();
        try {
            msg.entityID = buf.readInt();
            msg.reagentData = buf.m_130260_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ManaweavePatternDrawnMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SetRitualCollectedReagentsMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityID);
        buf.m_130079_(message.reagentData);
    }

    @Override
    public void Handle(Level world, Player player) {
        Entity e = ManaAndArtifice.instance.proxy.getClientWorld().m_6815_(this.entityID);
        if (e != null && e instanceof Ritual) {
            ((Ritual)e).readCollectedReagents(this.reagentData.m_128437_("data", 10));
        }
    }
}

