/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.capabilities.entity.MAPFXProvider;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MAPFXMessage
extends BaseClientMessage {
    private long flags;
    private int entityID;

    public MAPFXMessage(int entityID, long flags) {
        this.flags = flags;
        this.entityID = entityID;
        this.messageIsValid = true;
    }

    public MAPFXMessage() {
        this.messageIsValid = false;
    }

    public long getFlags() {
        return this.flags;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static MAPFXMessage decode(FriendlyByteBuf buf) {
        MAPFXMessage msg = new MAPFXMessage();
        try {
            msg.flags = buf.readLong();
            msg.entityID = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MAPFXMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(MAPFXMessage msg, FriendlyByteBuf buf) {
        buf.writeLong(msg.getFlags());
        buf.writeInt(msg.getEntityID());
    }

    @Override
    public void Handle(Level world, Player player) {
        Entity e = world.m_6815_(this.getEntityID());
        if (e != null && e instanceof LivingEntity) {
            ((LivingEntity)e).getCapability(MAPFXProvider.MAPFX).ifPresent(p -> p.setFlags(this.getFlags()));
        }
    }
}

