/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.blocks.tileentities.LodestarTile;
import com.mna.network.messages.TileEntityClientMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LodestarLogicS2CMessage
extends TileEntityClientMessage {
    private int index;
    private int numMessages;
    private int totalDataSize;
    private byte[] buffer;

    public LodestarLogicS2CMessage(BlockPos pos, int index, int numMessages, int totalDataSize, byte[] buffer) {
        super(pos);
        this.index = index;
        this.numMessages = numMessages;
        this.totalDataSize = totalDataSize;
        this.buffer = buffer;
        this.messageIsValid = true;
    }

    public LodestarLogicS2CMessage() {
        super(null);
        this.messageIsValid = false;
    }

    public static LodestarLogicS2CMessage decode(FriendlyByteBuf buf) {
        LodestarLogicS2CMessage msg = new LodestarLogicS2CMessage();
        try {
            msg.pos = buf.m_130135_();
            msg.index = buf.readInt();
            msg.numMessages = buf.readInt();
            msg.totalDataSize = buf.readInt();
            msg.buffer = buf.m_130052_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading LodestarLogicSetMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(LodestarLogicS2CMessage msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.getPosition());
        buf.writeInt(msg.index);
        buf.writeInt(msg.numMessages);
        buf.writeInt(msg.totalDataSize);
        buf.m_130087_(msg.buffer);
    }

    @Override
    public void Handle(Level world, Player player) {
        BlockEntity blockEntity;
        if (world.m_46749_(this.pos) && (blockEntity = world.m_7702_(this.pos)) instanceof LodestarTile) {
            LodestarTile tile = (LodestarTile)blockEntity;
            tile.setLogicPartial(this.index, this.numMessages, this.totalDataSize, this.buffer, false);
        }
    }
}

