/*
 * Decompiled with CFR 0.152.
 */
package com.mna.loot.modifiers;

import com.google.common.base.Suppliers;
import com.mna.enchantments.framework.EnchantmentInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class BeheadingModifier
extends LootModifier {
    public static final Supplier<Codec<BeheadingModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> BeheadingModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.FLOAT.fieldOf("chancePerLevel").forGetter(m -> Float.valueOf(m.chancePerLevel))).and((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("mobType").forGetter(m -> m.mobType)).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("head").forGetter(m -> m.head)).apply((Applicative)inst, BeheadingModifier::new)));
    private final float chancePerLevel;
    private final Item head;
    private final EntityType<?> mobType;

    public BeheadingModifier(LootItemCondition[] conditions, float chancePerLevel, EntityType<?> mobType, Item head) {
        super(conditions);
        this.chancePerLevel = chancePerLevel;
        this.head = head;
        this.mobType = mobType;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LivingEntity killerLiving;
        int level;
        Entity dead = (Entity)context.m_78953_(LootContextParams.f_81455_);
        Entity killer = (Entity)context.m_78953_(LootContextParams.f_81458_);
        if (dead != null && killer != null && killer instanceof LivingEntity && dead.m_6095_().equals(this.mobType) && (level = Math.max((killerLiving = (LivingEntity)killer).m_21205_().getEnchantmentLevel((Enchantment)EnchantmentInit.BEHEADING.get()), killerLiving.m_21206_().getEnchantmentLevel((Enchantment)EnchantmentInit.BEHEADING.get()))) > 0 && Math.random() < (double)((float)level * this.chancePerLevel) && generatedLoot.stream().noneMatch(i -> i.m_41720_() == this.head)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.head));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

