/*
 * Decompiled with CFR 0.152.
 */
package com.mna.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.faction.IFaction;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PlayerFactionCheck
implements LootItemCondition {
    public static final LootItemConditionType PLAYER_FACTION = new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    private final ResourceLocation factionID;

    private PlayerFactionCheck(ResourceLocation factionID) {
        this.factionID = factionID;
    }

    public LootItemConditionType m_7940_() {
        return PLAYER_FACTION;
    }

    public boolean test(LootContext context) {
        Player lastPlayer = (Player)context.m_78953_(LootContextParams.f_81456_);
        if (lastPlayer == null || this.factionID == null) {
            return false;
        }
        MutableBoolean factionMatch = new MutableBoolean(false);
        lastPlayer.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.getAlliedFaction() != null) {
                IFaction faction = (IFaction)Registries.Factions.get().getValue(this.factionID);
                factionMatch.setValue(faction == p.getAlliedFaction());
            }
        });
        return factionMatch.booleanValue();
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PlayerFactionCheck> {
        public void serialize(JsonObject json, PlayerFactionCheck check, JsonSerializationContext context) {
            json.addProperty("faction", check.factionID.toString());
        }

        public PlayerFactionCheck deserialize(JsonObject p_230423_1_, JsonDeserializationContext p_230423_2_) {
            try {
                ResourceLocation factionID = new ResourceLocation(GsonHelper.m_13906_((JsonObject)p_230423_1_, (String)"faction"));
                return new PlayerFactionCheck(factionID);
            }
            catch (Exception ex) {
                ManaAndArtifice.LOGGER.catching((Throwable)ex);
                return new PlayerFactionCheck(null);
            }
        }
    }
}

