/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.faction.FactionIDs;
import com.mna.api.items.inventory.ISpellBookInventory;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.gui.containers.providers.NamedGrimoire;
import com.mna.items.renderers.books.CouncilGrimoireBookRenderer;
import com.mna.items.renderers.books.DemonGrimoireBookRenderer;
import com.mna.items.renderers.books.FeyGrimoireBookRenderer;
import com.mna.items.renderers.books.GrimoireBookRenderer;
import com.mna.items.renderers.books.UndeadGrimoireBookRenderer;
import com.mna.items.sorcery.ItemSpellBook;
import com.mna.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;

public class ItemSpellGrimoire
extends ItemSpellBook {
    private final boolean showSubtitle;
    private final ResourceLocation forFaction;

    public ItemSpellGrimoire() {
        this(null, false);
    }

    public ItemSpellGrimoire(ResourceLocation faction, boolean renderBook) {
        super(renderBook);
        this.tier = faction == null ? 3 : 4;
        this.showSubtitle = faction != null;
        this.forFaction = faction;
    }

    public ItemSpellGrimoire(Item.Properties properties, @Nullable ResourceLocation faction, @Nullable ResourceLocation openModel, @Nullable ResourceLocation closedModel, boolean renderInFirstPerson) {
        super(properties, openModel, closedModel, renderInFirstPerson);
        this.tier = faction == null ? 3 : 4;
        this.showSubtitle = faction != null;
        this.forFaction = faction;
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> {
                if (ItemSpellGrimoire.this.forFaction == FactionIDs.COUNCIL) {
                    return new CouncilGrimoireBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
                if (ItemSpellGrimoire.this.forFaction == FactionIDs.DEMONS) {
                    return new DemonGrimoireBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
                if (ItemSpellGrimoire.this.forFaction == FactionIDs.FEY) {
                    return new FeyGrimoireBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
                if (ItemSpellGrimoire.this.forFaction == FactionIDs.UNDEAD) {
                    return new UndeadGrimoireBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
                }
                return new GrimoireBookRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            });

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedGrimoire();
    }

    @Override
    public ISpellBookInventory getInventory(ItemStack item, IPlayerMagic magic) {
        if (magic == null) {
            return null;
        }
        return magic.getGrimoireInventory();
    }

    @Override
    public CompoundTag getSpellCompound(ItemStack stack, Player player) {
        if (player == null) {
            return new CompoundTag();
        }
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null) {
            return new CompoundTag();
        }
        ItemStack selectedStack = magic.getGrimoireInventory().m_8020_(ItemSpellGrimoire.getActiveSpellSlot(stack));
        return selectedStack.m_41783_();
    }

    @Override
    public int m_8105_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("cur_spell_use_duration")) {
            return tag.m_128451_("cur_spell_use_duration");
        }
        return 9999;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack bookStack;
        ItemStack selectedStack;
        SpellRecipe recipe;
        if (!world.f_46443_ && (recipe = SpellRecipe.fromNBT((selectedStack = this.getSelectedStack(bookStack = player.m_21120_(hand), player)).m_41783_())).isValid()) {
            CompoundTag bookTag = bookStack.m_41784_();
            bookTag.m_128405_("cur_spell_use_duration", recipe.getMaxChannelTime());
            bookStack.m_41751_(bookTag);
        }
        return super.m_7203_(world, player, hand);
    }

    @Override
    protected ItemStack getSelectedStack(ItemStack bookStack, @Nullable Player player) {
        SimpleContainer bookInv;
        if (bookStack.m_41720_() instanceof ItemSpellBook && (bookInv = (SimpleContainer)this.getInventory(bookStack, player != null ? (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null) : null)) != null) {
            ItemStack selectedStack = bookInv.m_8020_(ItemSpellGrimoire.getActiveSpellSlot(bookStack));
            return selectedStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.showSubtitle) {
            tooltip.add((Component)Component.m_237115_((String)(stack.m_41778_() + ".subtitle")));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        return compoundnbt != null && compoundnbt.m_128425_("color", 99) ? compoundnbt.m_128451_("color") : 5841080;
    }
}

