/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.runes;

import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.items.IPositionalItem;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.items.ItemInit;
import com.mna.items.renderers.MarkingRuneRenderer;
import com.mna.items.runes.ItemRune;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemRuneMarking
extends ItemRune
implements IPositionalItem<ItemRuneMarking>,
DyeableLeatherItem {
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new MarkingRuneRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.getLocation(stack) == null ? 64 : 1;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state;
        ItemStack stack = context.m_43722_();
        if (!context.m_43723_().m_6047_() && (state = context.m_43725_().m_8055_(context.m_8083_())).m_60734_() == Blocks.f_152476_) {
            return super.m_6225_(context);
        }
        IPlayerMagic magic = (IPlayerMagic)context.m_43723_().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            if (context.m_43725_().m_5776_()) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.rune_marking.no_magic").m_130940_(ChatFormatting.GOLD));
            }
            return InteractionResult.FAIL;
        }
        if (context.m_43724_() == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        boolean didSplit = false;
        if (stack.m_41613_() > 1) {
            stack.m_41774_(1);
            stack = new ItemStack((ItemLike)ItemInit.RUNE_MARKING.get());
            didSplit = true;
        }
        this.setLocation(stack, context.m_8083_(), context.m_43719_(), context.m_43725_());
        if (didSplit && !context.m_43723_().m_36356_(stack)) {
            context.m_43723_().m_36176_(stack, true);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        BlockPos pos = this.getLocation(stack);
        if (pos != null) {
            Direction face;
            tooltip.add((Component)Component.m_237110_((String)"item.mna.rune_marking.setPosition", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
            MutableComponent block = (MutableComponent)this.getBlockName(stack);
            if (block != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.mna.rune_marking.blockWhenSet", (Object[])new Object[]{block.getString()}).m_130940_(ChatFormatting.GOLD));
            }
            if ((face = this.getFace(stack)) != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.mna.rune_marking.face", (Object[])new Object[]{face.toString()}).m_130940_(ChatFormatting.GOLD));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.rune_marking.noPosition"));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.getLocation(stack) != null;
    }

    @Override
    public void setLocation(ItemStack stack, BlockPos pos, Direction face, Level world) {
        CompoundTag nbt = stack.m_41698_("mark");
        nbt.m_128405_("x", pos.m_123341_());
        nbt.m_128405_("y", pos.m_123342_());
        nbt.m_128405_("z", pos.m_123343_());
        nbt.m_128405_("face", face.m_122411_());
        if (world.m_46749_(pos)) {
            Block block = world.m_8055_(pos).m_60734_();
            nbt.m_128359_("block", new ItemStack((ItemLike)block).m_41778_());
            nbt.m_128359_("block_id", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        }
    }

    @Override
    public void setLocation(ItemStack stack, BlockPos pos, Direction face) {
        CompoundTag nbt = stack.m_41698_("mark");
        nbt.m_128405_("x", pos.m_123341_());
        nbt.m_128405_("y", pos.m_123342_());
        nbt.m_128405_("z", pos.m_123343_());
        nbt.m_128405_("face", face.m_122411_());
    }

    @Override
    public void setLocation(ItemStack stack, DirectionalPoint point) {
        CompoundTag nbt = stack.m_41698_("mark");
        nbt.m_128405_("x", point.getPosition().m_123341_());
        nbt.m_128405_("y", point.getPosition().m_123342_());
        nbt.m_128405_("z", point.getPosition().m_123343_());
        nbt.m_128405_("face", point.getDirection().m_122411_());
        if (point.getBlockName() != null) {
            nbt.m_128359_("block", point.getBlockName());
        }
        if (point.getBlockID() != null) {
            nbt.m_128359_("block_id", point.getBlockID());
        }
    }

    @Override
    @Nullable
    public DirectionalPoint getDirectionalPoint(ItemStack stack) {
        ResourceLocation block = this.getMarkedBlockId(stack);
        return new DirectionalPoint(this.getLocation(stack), this.getFace(stack), this.getBlockTranslateKey(stack), block != null ? block.toString() : null);
    }

    @Override
    @Nullable
    public BlockPos getLocation(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41698_("mark");
        if (nbt.m_128441_("x") && nbt.m_128441_("y") && nbt.m_128441_("z")) {
            return new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
        }
        return null;
    }

    @Override
    public Direction getFace(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Direction.DOWN;
        }
        CompoundTag nbt = stack.m_41698_("mark");
        if (nbt.m_128441_("face")) {
            return Direction.m_122376_((int)nbt.m_128451_("face"));
        }
        return Direction.DOWN;
    }

    @Override
    @Nullable
    public String getBlockTranslateKey(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41698_("mark");
        return nbt.m_128441_("block") ? nbt.m_128461_("block") : null;
    }

    @Override
    public ResourceLocation getMarkedBlockId(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41698_("mark");
        return nbt.m_128441_("block_id") ? new ResourceLocation(nbt.m_128461_("block_id")) : null;
    }

    @Override
    @Nullable
    public Component getBlockName(ItemStack stack) {
        String blockID;
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag nbt = stack.m_41698_("mark");
        if (nbt.m_128441_("block") && (blockID = nbt.m_128461_("block")) != null) {
            return Component.m_237115_((String)blockID);
        }
        return null;
    }

    @Override
    public void copyPositionFrom(ItemStack source, ItemStack destination) {
        if (!(source.m_41720_() instanceof IPositionalItem) || !(destination.m_41720_() instanceof IPositionalItem)) {
            return;
        }
        CompoundTag srcNbt = source.m_41698_("mark");
        CompoundTag destNbt = destination.m_41698_("mark");
        destNbt.m_128405_("x", srcNbt.m_128451_("x"));
        destNbt.m_128405_("y", srcNbt.m_128451_("y"));
        destNbt.m_128405_("z", srcNbt.m_128451_("z"));
        destNbt.m_128405_("face", srcNbt.m_128451_("face"));
        destNbt.m_128359_("block", srcNbt.m_128461_("block"));
        if (srcNbt.m_128441_("block_id")) {
            destNbt.m_128359_("block_id", srcNbt.m_128461_("block_id"));
        }
    }
}

