/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.renderers;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.items.ItemInit;
import com.mna.items.SpellIconList;
import com.mna.items.sorcery.ItemSpell;
import com.mna.spells.crafting.SpellRecipe;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemSpellRenderer
extends BlockEntityWithoutLevelRenderer {
    private static HashMap<Integer, BakedModel> bakedSpellModels;
    private BakedModel defaultSpellModel;
    private BakedModel defaultBangleModel;
    public static final ResourceLocation location_spell;
    public static final ResourceLocation location_bangle;

    public ItemSpellRenderer(BlockEntityRenderDispatcher berd, EntityModelSet ems) {
        super(berd, ems);
        if (bakedSpellModels == null) {
            bakedSpellModels = new HashMap();
        }
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext ItemDisplayContext2, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (ItemDisplayContext2 != ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            if (ItemDisplayContext2 != ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                if (ItemDisplayContext2 == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                    this.renderArm(matrixStack, buffer, combinedLight, HumanoidArm.RIGHT);
                    this.spawnFirstPersonParticlesForStack(stack, HumanoidArm.RIGHT);
                } else if (ItemDisplayContext2 == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                    this.renderArm(matrixStack, buffer, combinedLight, HumanoidArm.LEFT);
                    this.spawnFirstPersonParticlesForStack(stack, HumanoidArm.LEFT);
                } else {
                    this.renderDefaultSpellItem(stack, ItemDisplayContext2, matrixStack, buffer, combinedLight, combinedOverlay);
                }
            }
        }
    }

    private void renderDefaultSpellItem(ItemStack stack, ItemDisplayContext ItemDisplayContext2, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!stack.m_41619_()) {
            BakedModel spellModel = ItemDisplayContext2 == ItemDisplayContext.GUI ? this.getSpellModel(stack) : this.getDefaultSpellModel(stack.m_41720_() == ItemInit.BANGLE.get());
            matrixStack.m_85849_();
            matrixStack.m_85836_();
            if (ItemDisplayContext2 != ItemDisplayContext.GUI) {
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext2, ItemDisplayContext2 == ItemDisplayContext.FIRST_PERSON_LEFT_HAND, matrixStack, buffer, combinedLight, combinedOverlay, spellModel);
            } else {
                boolean flag;
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                boolean bl = flag = !spellModel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, spellModel);
                bufferSource.m_109911_();
                RenderSystem.enableDepthTest();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
        }
    }

    private BakedModel getSpellModel(ItemStack stack) {
        BakedModel customModel;
        if (stack.m_41720_() == ItemInit.BANGLE.get()) {
            return this.getDefaultSpellModel(true);
        }
        int customIconIndex = ItemSpell.getCustomIcon(stack);
        if (customIconIndex < 0 || customIconIndex >= SpellIconList.ALL.length) {
            return this.getDefaultSpellModel(false);
        }
        if (!bakedSpellModels.containsKey(customIconIndex)) {
            bakedSpellModels.put(customIconIndex, Minecraft.m_91087_().m_91304_().getModel(SpellIconList.ALL[customIconIndex]));
        }
        return (customModel = bakedSpellModels.get(customIconIndex)) != null ? customModel : this.getDefaultSpellModel(false);
    }

    private BakedModel getDefaultSpellModel(boolean bangle) {
        if (this.defaultSpellModel == null) {
            this.defaultSpellModel = Minecraft.m_91087_().m_91304_().getModel(location_spell);
            this.defaultBangleModel = Minecraft.m_91087_().m_91304_().getModel(location_bangle);
        }
        return bangle ? this.defaultBangleModel : this.defaultSpellModel;
    }

    private void renderArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, HumanoidArm side) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderer playerrenderer = mc.m_91290_().m_114382_((Entity)mc.f_91074_);
        if (!(playerrenderer instanceof PlayerRenderer)) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)mc.f_91074_.m_108560_());
        matrixStackIn.m_85836_();
        if (side == HumanoidArm.RIGHT) {
            matrixStackIn.m_85837_(0.75, -0.25, 0.0);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(95.0f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(-30.0f));
            ((PlayerRenderer)playerrenderer).m_117770_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)mc.f_91074_);
        } else {
            matrixStackIn.m_85837_(0.25, -0.25, 0.0);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(260.0f));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(30.0f));
            ((PlayerRenderer)playerrenderer).m_117813_(matrixStackIn, bufferIn, combinedLightIn, (AbstractClientPlayer)mc.f_91074_);
        }
        matrixStackIn.m_85849_();
    }

    private void spawnFirstPersonParticlesForStack(ItemStack stack, HumanoidArm hand) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSpell)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        boolean playerIsRightHanded = player.m_5737_() == HumanoidArm.RIGHT;
        boolean itemIsInUse = player.m_21212_() > 0;
        InteractionHand activeHand = player.m_7655_();
        if (!itemIsInUse || playerIsRightHanded && activeHand == InteractionHand.MAIN_HAND && hand == HumanoidArm.LEFT || !playerIsRightHanded && activeHand == InteractionHand.MAIN_HAND && hand == HumanoidArm.RIGHT) {
            Vec3 particlePos = player.m_20182_().m_82520_(0.0, (double)(player.m_20192_() - 0.2f), 0.0);
            Vec3 look = player.m_20154_().m_82541_().m_82490_(0.5);
            Vec3 perp = look.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(hand == HumanoidArm.LEFT ? (double)-0.4f : (double)0.4f);
            particlePos = particlePos.m_82549_(look).m_82549_(perp);
            SpellRecipe recipe = SpellRecipe.fromNBT(((ItemSpell)stack.m_41720_()).getSpellCompound(stack, (Player)player));
            Affinity[] affs = recipe.getAffinity().keySet().toArray(new Affinity[0]);
            switch (affs[(int)(Math.random() * (double)affs.length)]) {
                case ARCANE: {
                    Vec3 origin = new Vec3(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                    Vec3 offset = new Vec3(player.m_9236_().f_46441_.m_188583_(), player.m_9236_().f_46441_.m_188583_(), player.m_9236_().f_46441_.m_188583_()).m_82541_().m_82490_((double)0.3f);
                    origin = origin.m_82549_(offset);
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_LERP.get())), (Entity)player), origin.f_82479_, origin.f_82480_, origin.f_82481_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                    break;
                }
                case EARTH: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, (double)-0.005f + Math.random() * (double)0.01f, (double)0.03f, (double)-0.005f + Math.random() * (double)0.01f);
                    break;
                }
                case ENDER: {
                    Vec3 origin = new Vec3(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                    Vec3 offset = new Vec3(player.m_9236_().f_46441_.m_188583_(), player.m_9236_().f_46441_.m_188583_(), player.m_9236_().f_46441_.m_188583_()).m_82541_().m_82490_((double)0.3f);
                    origin = origin.m_82549_(offset);
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)player), origin.f_82479_, origin.f_82480_, origin.f_82481_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                    break;
                }
                case FIRE: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                    break;
                }
                case HELLFIRE: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                    break;
                }
                case LIGHTNING: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particlePos.f_82479_ - (double)0.2f + Math.random() * (double)0.4f, particlePos.f_82480_ - (double)0.2f + Math.random() * (double)0.4f, particlePos.f_82481_ - (double)0.2f + Math.random() * (double)0.4f);
                    break;
                }
                case WATER: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, -0.05 * Math.random() * 0.1, Math.random() * 0.05, -0.05 * Math.random() * 0.1);
                    break;
                }
                case ICE: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                    break;
                }
                case WIND: {
                    player.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.02f).setColor(20, 20, 20), (Entity)player), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, (double)0.3f, (double)0.01f, (double)0.05f);
                    break;
                }
            }
        }
    }

    static {
        location_spell = new ResourceLocation("mna", "item/spell_texture");
        location_bangle = new ResourceLocation("mna", "item/bangle_texture");
    }
}

