/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IRitualTeleportLocation;
import com.mna.api.items.TieredItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.BlockInit;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.gui.containers.providers.NamedEnderDisc;
import com.mna.items.base.IItemWithGui;
import com.mna.items.base.IRadialMenuItem;
import com.mna.items.renderers.obj_gecko.EnderDiscRenderer;
import com.mna.tools.TeleportHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemEnderDisk
extends TieredItem
implements IItemWithGui<ItemEnderDisk>,
IRadialMenuItem,
GeoItem {
    private static final String KEY_INDEX = "ender_disk_index";
    private static final String KEY_NBT = "ender_disk_data";
    private static final String KEY_COUNT = "count";
    private static final String KEY_NAME = "name";
    private static final String KEY_DIMENSION = "dimension";
    private static final String KEY_ENTRY_PREFIX = "reagent_";
    private static final String CONTROLLER_NAME = "enderDiscController";
    public static final int MAX_PATTERNS = 8;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ItemEnderDisk() {
        super(new Item.Properties());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new EnderDiscRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedEnderDisc();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        IPlayerMagic magic = (IPlayerMagic)playerIn.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!this.openGuiIfModifierPressed(playerIn.m_21120_(handIn), playerIn, worldIn)) {
            this.teleport(worldIn, playerIn, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IPlayerMagic magic = (IPlayerMagic)context.m_43723_().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return InteractionResult.FAIL;
        }
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60734_() == BlockInit.RITUAL_TELEPORT_DESTINATION.get() && context.m_43723_().m_6047_()) {
            if (!context.m_43725_().m_5776_()) {
                context.m_43725_().getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
                    List<ResourceLocation> pattern = m.getRitualTeleportBlockReagents(context.m_8083_());
                    int curIndex = ItemEnderDisk.getIndex(context.m_43722_());
                    Component name = ItemEnderDisk.getPatternName(context.m_43722_(), curIndex);
                    ResourceLocation dimensionID = context.m_43725_().m_46472_().m_135782_();
                    ItemEnderDisk.setPattern(context.m_43722_(), pattern, dimensionID, curIndex, name.getString());
                    context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.ender_disc.copied"));
                });
            }
            return InteractionResult.m_19078_((boolean)context.m_43725_().m_5776_());
        }
        if (!this.openGuiIfModifierPressed(context.m_43722_(), context.m_43723_(), context.m_43725_())) {
            this.teleport(context.m_43725_(), context.m_43723_(), context.m_43722_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"mna:ender_disc.set_to", (Object[])new Object[]{ItemEnderDisk.getPatternName(stack, ItemEnderDisk.getIndex(stack))}).m_130940_(ChatFormatting.GOLD));
        IItemWithGui.super.m_7373_(stack, worldIn, tooltip, flagIn);
        IRadialMenuItem.super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    private void teleport(Level world, Player player, ItemStack stack) {
        if (world.f_46443_) {
            float particle_spread = 1.0f;
            float v = 1.0f;
            int particleCount = 25;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 velocity = new Vec3(0.0, Math.random() * (double)v, 0.0);
                world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())), player.m_20182_().m_7096_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), player.m_20182_().m_7098_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), player.m_20182_().m_7094_() + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
            }
            return;
        }
        ArrayList<ResourceLocation> pattern = ItemEnderDisk.getPattern(stack);
        if (pattern.size() == 0) {
            return;
        }
        ResourceLocation dimensionID = ItemEnderDisk.getDimension(stack);
        ServerLevel resolvedWorld = TeleportHelper.resolveRegistryKey((ServerLevel)world, dimensionID);
        ServerLevel targetWorld = resolvedWorld != null ? resolvedWorld : (ServerLevel)world;
        targetWorld.getCapability(WorldMagicProvider.MAGIC).ifPresent(worldMagicContainer -> {
            IRitualTeleportLocation teleportPosition = worldMagicContainer.getRitualTeleportBlockLocation(pattern, (ResourceKey<Level>)world.m_46472_());
            if (teleportPosition == null) {
                return;
            }
            if (!teleportPosition.getWorldType().equals((Object)targetWorld.m_46472_())) {
                player.m_213846_((Component)Component.m_237115_((String)"mna:rituals/return.wrong_dimension"));
                return;
            }
            ((ServerLevel)world).m_5594_(null, player.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.7f + Math.random() * (double)0.3f));
            targetWorld.m_5594_(null, teleportPosition.getPos(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, (float)((double)0.7f + Math.random() * (double)0.3f));
            TeleportHelper.teleportEntity((Entity)player, (ResourceKey<Level>)targetWorld.m_46472_(), Vec3.m_82539_((Vec3i)teleportPosition.getPos().m_7494_()));
        });
    }

    private static CompoundTag getCurrentCompound(ItemStack stack, int index) {
        ListTag list;
        if (stack == null || !stack.m_41782_() || !stack.m_41783_().m_128441_(KEY_NBT)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128425_(KEY_NBT, 10)) {
            return tag.m_128469_(KEY_NBT);
        }
        if (tag.m_128425_(KEY_NBT, 9) && index < (list = (ListTag)tag.m_128423_(KEY_NBT)).size()) {
            return list.m_128728_(index);
        }
        return null;
    }

    public static ArrayList<ResourceLocation> getPattern(ItemStack stack) {
        return ItemEnderDisk.getPattern(stack, ItemEnderDisk.getIndex(stack));
    }

    public static ArrayList<ResourceLocation> getPattern(ItemStack stack, int index) {
        ArrayList<ResourceLocation> output = new ArrayList<ResourceLocation>(8);
        CompoundTag nbt = ItemEnderDisk.getCurrentCompound(stack, index);
        if (nbt != null) {
            int count = Math.min(nbt.m_128451_(KEY_COUNT), 8);
            for (int i = 0; i < count; ++i) {
                output.add(new ResourceLocation(nbt.m_128461_(KEY_ENTRY_PREFIX + i)));
            }
        }
        while (output.size() < 8) {
            output.add(new ResourceLocation("minecraft:air"));
        }
        return output;
    }

    public static ResourceLocation getDimension(ItemStack stack) {
        return ItemEnderDisk.getDimension(stack, ItemEnderDisk.getIndex(stack));
    }

    public static ResourceLocation getDimension(ItemStack stack, int index) {
        CompoundTag nbt = ItemEnderDisk.getCurrentCompound(stack, index);
        if (nbt == null || !nbt.m_128441_(KEY_DIMENSION)) {
            return new ResourceLocation("mna:dimension_current");
        }
        return new ResourceLocation(nbt.m_128461_(KEY_DIMENSION));
    }

    public static Component getPatternName(ItemStack stack, int index) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = null;
        if (!tag.m_128425_(KEY_NBT, 9)) {
            return Component.m_237115_((String)"mna:ender_disc.unused");
        }
        list = tag.m_128437_(KEY_NBT, 10);
        CompoundTag nbt = null;
        if (index >= list.size()) {
            return Component.m_237115_((String)"mna:ender_disc.unused");
        }
        nbt = list.m_128728_(index);
        String str = nbt.m_128461_(KEY_NAME);
        if (str.length() > 0) {
            return Component.m_237113_((String)str);
        }
        return Component.m_237115_((String)"mna:ender_disc.unused");
    }

    public static void setPattern(ItemStack stack, List<ResourceLocation> locations, ResourceLocation dimensionID, int index, String name) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = null;
        list = tag.m_128425_(KEY_NBT, 9) ? tag.m_128437_(KEY_NBT, 10) : new ListTag();
        while (list.size() < 8) {
            list.add((Object)new CompoundTag());
        }
        CompoundTag nbt = null;
        nbt = index < list.size() ? list.m_128728_(index) : new CompoundTag();
        nbt.m_128405_(KEY_COUNT, locations.size());
        nbt.m_128359_(KEY_NAME, name);
        nbt.m_128359_(KEY_DIMENSION, dimensionID != null ? dimensionID.toString() : "");
        int count = 0;
        for (ResourceLocation loc : locations) {
            nbt.m_128359_(KEY_ENTRY_PREFIX + count++, loc.toString());
        }
        list.set(index, (Tag)nbt);
        stack.m_41783_().m_128365_(KEY_NBT, (Tag)list);
    }

    public static void setIndex(ItemStack stack, int index) {
        stack.m_41784_().m_128405_(KEY_INDEX, index);
    }

    public static int getIndex(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128451_(KEY_INDEX);
        }
        return 0;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.ender_disc_armature.idle")))});
    }
}

