/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.capabilities.WellspringNode;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.items.IPositionalItem;
import com.mna.api.items.TieredItem;
import com.mna.api.sound.SFX;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemPlayerCharm;
import com.mna.sound.ItemInUseLoopingSound;
import com.mna.tools.math.MathUtils;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemDowsingRod
extends TieredItem {
    private static final float MANA_PER_TICK_WELLSPRING = 5.0f;
    private static final float MANA_PER_TICK_BED = 2.0f;
    private static final float MANA_PER_TICK_PLAYER = 20.0f;
    private static final String KEY_STORED_POINT = "stored_point";
    private static final String KEY_MODE = "mode";

    public ItemDowsingRod() {
        super(new Item.Properties());
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 999999;
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int ticks) {
        if (!(user instanceof Player)) {
            return;
        }
        Modes mode = this.getMode(stack);
        float manaCost = 2.0f;
        switch (mode) {
            case Wellspring: {
                manaCost = 5.0f;
                break;
            }
            case Player: {
                manaCost = 20.0f;
                break;
            }
            case Bed: 
            case Point: {
                manaCost = 2.0f;
            }
        }
        Player player = (Player)user;
        boolean manaConsumed = this.consumeMana(player, manaCost);
        if (!manaConsumed) {
            player.m_21253_();
            return;
        }
        BlockPos trackPos = null;
        ItemStack offhand = user.m_7655_() == InteractionHand.MAIN_HAND ? user.m_21120_(InteractionHand.OFF_HAND) : user.m_21120_(InteractionHand.MAIN_HAND);
        switch (mode) {
            case Wellspring: {
                trackPos = this.trackWellspring(player, world, stack);
                break;
            }
            case Player: {
                trackPos = this.trackPlayer(player, world, stack, offhand);
                break;
            }
            case Bed: 
            case Point: {
                trackPos = this.trackCachedPoint(player, world, stack);
            }
        }
        if (trackPos != null) {
            Vec3 closestPos = new Vec3((double)trackPos.m_123341_() + 0.5, player.m_20186_() + (double)player.m_20192_(), (double)trackPos.m_123343_() + 0.5);
            if (world.f_46443_) {
                MathUtils.rotateEntityLookTowards(EntityAnchorArgument.Anchor.EYES, (LivingEntity)player, closestPos, 5.0f);
            }
        } else if (!world.f_46443_) {
            player.m_213846_((Component)Component.m_237115_((String)"item.mna.dowsing_rod.no_target"));
            player.m_21253_();
        }
    }

    private boolean consumeMana(Player player, float amount) {
        MutableBoolean consumeSuccess = new MutableBoolean(true);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (!m.isMagicUnlocked() || !m.getCastingResource().hasEnoughAbsolute((LivingEntity)player, amount)) {
                consumeSuccess.setFalse();
                return;
            }
            m.getCastingResource().consume((LivingEntity)player, amount);
        });
        return consumeSuccess.booleanValue();
    }

    @Nullable
    private BlockPos trackWellspring(Player player, Level level, ItemStack stack) {
        MutableObject closestPos = new MutableObject(null);
        level.getCapability(WorldMagicProvider.MAGIC).ifPresent(wm -> {
            if (stack.m_41782_() && stack.m_41783_().m_128441_(KEY_STORED_POINT)) {
                closestPos.setValue((Object)BlockPos.m_122022_((long)stack.m_41783_().m_128454_(KEY_STORED_POINT)));
            } else {
                HashMap<BlockPos, WellspringNode> nodes = wm.getWellspringRegistry().getNearbyNodes(player.m_20183_(), 0, (int)((double)GeneralConfigValues.WellspringDistance * 1.5));
                MutableDouble closestDist = new MutableDouble();
                nodes.keySet().forEach(bp -> {
                    double dist = bp.m_123331_((Vec3i)player.m_20183_());
                    if (closestPos.getValue() == null || dist < closestDist.getValue()) {
                        closestPos.setValue(bp);
                        closestDist.setValue(dist);
                    }
                });
                if (closestPos.getValue() != null) {
                    stack.m_41784_().m_128356_(KEY_STORED_POINT, ((BlockPos)closestPos.getValue()).m_121878_());
                }
            }
        });
        return (BlockPos)closestPos.getValue();
    }

    @Nullable
    private BlockPos trackPlayer(Player player, Level level, ItemStack stack, ItemStack offhand) {
        if (level.m_46467_() % 20L == 0L || !stack.m_41782_() || !stack.m_41783_().m_128441_(KEY_STORED_POINT)) {
            ItemPlayerCharm charm;
            Player target;
            if (offhand.m_41720_() instanceof ItemPlayerCharm && (target = (charm = (ItemPlayerCharm)offhand.m_41720_()).GetPlayerTarget(offhand, level)) != null) {
                stack.m_41784_().m_128356_(KEY_STORED_POINT, target.m_20183_().m_121878_());
                return target.m_20183_();
            }
        } else if (stack.m_41782_() && stack.m_41783_().m_128441_(KEY_STORED_POINT)) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_(KEY_STORED_POINT));
        }
        return null;
    }

    private BlockPos trackCachedPoint(Player player, Level level, ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(KEY_STORED_POINT)) {
            return BlockPos.m_122022_((long)stack.m_41783_().m_128454_(KEY_STORED_POINT));
        }
        return null;
    }

    private Modes getMode(ItemStack stack) {
        if (stack.m_41782_()) {
            int mode = stack.m_41783_().m_128451_(KEY_MODE);
            return Modes.values()[mode % Modes.values().length];
        }
        return Modes.Bed;
    }

    private void setMode(ItemStack stack, Modes mode) {
        stack.m_41784_().m_128405_(KEY_MODE, mode.ordinal());
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int ticks) {
        if (stack.m_41782_()) {
            stack.m_41783_().m_128473_(KEY_STORED_POINT);
            stack.m_41783_().m_128473_(KEY_MODE);
        }
        if (user instanceof Player) {
            ((Player)user).m_36335_().m_41524_((Item)this, 20);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        MutableBoolean magicUnlocked = new MutableBoolean(true);
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (!m.isMagicUnlocked()) {
                if (world.f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"item.mna.dowsing_rod.confusion"));
                }
                player.m_36335_().m_41524_((Item)this, 100);
                magicUnlocked.setFalse();
            }
        });
        ItemStack itemstack = player.m_21120_(hand);
        if (magicUnlocked.getValue().booleanValue()) {
            Modes mode = null;
            if (world.f_46443_) {
                mode = Modes.Bed;
                this.PlayLoopingSound(SFX.Loops.MANAWEAVING, player);
            } else {
                ItemStack offhandStack = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                if (offhandStack.m_41720_() instanceof IPositionalItem) {
                    IPositionalItem markItem = (IPositionalItem)offhandStack.m_41720_();
                    DirectionalPoint point = markItem.getDirectionalPoint(offhandStack);
                    if (point != null && point.getPosition() != null) {
                        mode = Modes.Point;
                        itemstack.m_41784_().m_128356_(KEY_STORED_POINT, point.getPosition().m_121878_());
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"item.mna.rune_marking.noPosition"));
                    }
                } else if (offhandStack.m_41720_() instanceof ItemPlayerCharm) {
                    ItemPlayerCharm charm = (ItemPlayerCharm)offhandStack.m_41720_();
                    if (charm.GetPlayerTarget(offhandStack, world) != null) {
                        mode = Modes.Player;
                    } else if (charm.getPlayerUUID(offhandStack) == null) {
                        player.m_213846_((Component)Component.m_237115_((String)"mna:rituals/summon.not_found"));
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"mna:rituals/summon.wrong_dimension"));
                    }
                } else if (offhandStack.m_41720_() == ItemInit.CHIMERITE_GEM.get()) {
                    mode = Modes.Wellspring;
                } else if (!world.m_46472_().equals(((ServerPlayer)player).m_8963_())) {
                    player.m_213846_((Component)Component.m_237115_((String)"item.mna.bed_charm.dimension-wrong"));
                } else {
                    BlockPos bedPos = ((ServerPlayer)player).m_8961_();
                    if (bedPos == null) {
                        player.m_213846_((Component)Component.m_237115_((String)"item.mna.bed_charm.no-bed"));
                    } else {
                        mode = Modes.Bed;
                        itemstack.m_41784_().m_128356_(KEY_STORED_POINT, bedPos.m_121878_());
                    }
                }
            }
            if (mode != null) {
                if (!world.f_46443_) {
                    this.setMode(itemstack, mode);
                    player.m_6672_(hand);
                }
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            if (!world.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"item.mna.dowsing_rod.no_target"));
            }
        }
        player.m_36335_().m_41524_((Item)this, 20);
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID, Player player) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new ItemInUseLoopingSound(soundID, player));
    }

    private static enum Modes {
        Bed,
        Wellspring,
        Player,
        Point;

    }
}

