/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.widgets.lodestar;

import com.mna.ManaAndArtifice;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskFilterParameter;
import com.mna.api.items.DynamicItemFilter;
import com.mna.gui.widgets.lodestar.LodestarParameter;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.artifice.FilterItem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FilterParameterInput
extends LodestarParameter<DynamicItemFilter> {
    public static final int V = 44;
    private ItemStack whitelistFilter = new ItemStack((ItemLike)ItemInit.FILTER_ITEM.get());
    private ItemStack blacklistFilter = new ItemStack((ItemLike)ItemInit.FILTER_ITEM.get());

    public FilterParameterInput(boolean lowTier, int x, int y, Button.OnPress pressHandler, Component tooltip) {
        super(lowTier, x, y, 44, new DynamicItemFilter(), pressHandler, tooltip);
    }

    public FilterParameterInput(boolean lowTier, int x, int y, DynamicItemFilter defaultValue, Button.OnPress pressHandler, Component tooltip) {
        super(lowTier, x, y, 44, defaultValue, pressHandler, tooltip);
    }

    @Override
    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!((DynamicItemFilter)this.value).isWhitelistEmpty()) {
            pGuiGraphics.m_280480_(this.whitelistFilter, this.m_252754_() + 19, this.m_252907_() + 3);
        }
        if (!((DynamicItemFilter)this.value).isBlacklistEmpty()) {
            pGuiGraphics.m_280480_(this.blacklistFilter, this.m_252754_() + 37, this.m_252907_() + 3);
        }
    }

    @Override
    public void saveTo(ConstructAITaskParameter param) {
        if (param instanceof ConstructTaskFilterParameter && this.value != null) {
            ((ConstructTaskFilterParameter)param).getValue().copyFrom((DynamicItemFilter)this.value);
        }
    }

    @Override
    public void loadFrom(ConstructAITaskParameter param) {
        ((DynamicItemFilter)this.value).copyFrom(((ConstructTaskFilterParameter)param).getValue());
        ((FilterItem)ItemInit.FILTER_ITEM.get()).setItems(this.whitelistFilter, ((DynamicItemFilter)this.value).getWhiteList(), ((DynamicItemFilter)this.value).getWhitelistMatchDurability(), ((DynamicItemFilter)this.value).getWhitelistMatchTag());
        ((FilterItem)ItemInit.FILTER_ITEM.get()).setItems(this.blacklistFilter, ((DynamicItemFilter)this.value).getBlackList(), ((DynamicItemFilter)this.value).getBlacklistMatchDurability(), ((DynamicItemFilter)this.value).getBlacklistMatchTag());
    }

    public void m_5716_(double mouseX, double mouseY) {
        NonNullList<ItemStack> items;
        ItemStack carried = this.getCursorHeldItem();
        int slot = this.getClickSlot(mouseX, mouseY);
        if (slot == -1) {
            return;
        }
        boolean isWhitelist = slot == 0;
        boolean matchDurability = false;
        boolean matchTag = false;
        if (!carried.m_41619_() && carried.m_41720_() instanceof FilterItem) {
            ItemInventoryBase inv = new ItemInventoryBase(carried);
            items = inv.getAllItems();
            matchDurability = ((FilterItem)carried.m_41720_()).getMatchDurability(carried);
            matchTag = ((FilterItem)carried.m_41720_()).getMatchTag(carried);
        } else {
            items = NonNullList.m_122779_();
        }
        if (isWhitelist) {
            ((DynamicItemFilter)this.value).setWhitelist(items, matchDurability, matchTag);
            ((FilterItem)ItemInit.FILTER_ITEM.get()).setItems(this.whitelistFilter, ((DynamicItemFilter)this.value).getWhiteList(), ((DynamicItemFilter)this.value).getWhitelistMatchDurability(), ((DynamicItemFilter)this.value).getWhitelistMatchTag());
        } else {
            ((DynamicItemFilter)this.value).setBlacklist(items, matchDurability, matchTag);
            ((FilterItem)ItemInit.FILTER_ITEM.get()).setItems(this.blacklistFilter, ((DynamicItemFilter)this.value).getBlackList(), ((DynamicItemFilter)this.value).getBlacklistMatchDurability(), ((DynamicItemFilter)this.value).getBlacklistMatchTag());
        }
        super.m_5716_(mouseX, mouseY);
    }

    private int getClickSlot(double mouseX, double mouseY) {
        int padding = 16;
        if (mouseX < (double)(this.m_252754_() + padding)) {
            return -1;
        }
        if (mouseX < (double)(this.m_252754_() + padding + (this.f_93618_ - padding) / 2)) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<Component> getTooltipItems() {
        List<Component> baseTT = super.getTooltipItems();
        baseTT.add((Component)Component.m_237113_((String)" "));
        baseTT.add((Component)Component.m_237115_((String)"gui.mna.filter.whitelist"));
        ((FilterItem)ItemInit.FILTER_ITEM.get()).addContentsDescription(this.whitelistFilter, ManaAndArtifice.instance.proxy.getClientWorld(), baseTT);
        baseTT.add((Component)Component.m_237113_((String)"-------"));
        baseTT.add((Component)Component.m_237115_((String)"gui.mna.filter.blacklist"));
        ((FilterItem)ItemInit.FILTER_ITEM.get()).addContentsDescription(this.blacklistFilter, ManaAndArtifice.instance.proxy.getClientWorld(), baseTT);
        return baseTT;
    }
}

