/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.radial;

import com.google.common.collect.Lists;
import com.mna.KeybindInit;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.items.inventory.ISpellBookInventory;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.events.ClientEventHandler;
import com.mna.gui.radial.GenericRadialMenu;
import com.mna.gui.radial.components.IRadialMenuHost;
import com.mna.gui.radial.components.ItemStackRadialMenuItem;
import com.mna.gui.radial.components.RadialMenuItem;
import com.mna.interop.CuriosInterop;
import com.mna.items.sorcery.ItemSpellBook;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpellRadialSelect
extends Screen {
    private ItemStack stackEquipped;
    private ISpellBookInventory inventory;
    private boolean needsRecheckStacks = true;
    private final List<ItemStackRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final GenericRadialMenu menu;
    private final InteractionHand hand;
    private final SlotContext curioSlotContext;

    public SpellRadialSelect(InteractionHand hand, SlotContext curioSlot) {
        super((Component)Component.m_237113_((String)"RADIAL MENU"));
        this.hand = hand;
        this.curioSlotContext = curioSlot;
        this.f_96541_ = Minecraft.m_91087_();
        this.stackEquipped = this.getTargetItem();
        if (this.stackEquipped.m_41720_() instanceof ItemSpellBook) {
            this.inventory = ((ItemSpellBook)this.stackEquipped.m_41720_()).getInventory(this.stackEquipped, (IPlayerMagic)this.f_96541_.f_91074_.getCapability(PlayerMagicProvider.MAGIC).orElse(null));
        } else {
            this.m_7379_();
        }
        this.menu = new GenericRadialMenu(Minecraft.m_91087_(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(GuiGraphics pGuiGraphics, ItemStack stack, int mouseX, int mouseY) {
            }

            @Override
            public void renderTooltip(GuiGraphics pGuiGraphics, Component text, int mouseX, int mouseY) {
            }

            @Override
            public Screen getScreen() {
                return SpellRadialSelect.this;
            }

            @Override
            public Font getFontRenderer() {
                return SpellRadialSelect.this.f_96547_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
        this.menu.radiusOffset = 35.0f;
    }

    private ItemStack getTargetItem() {
        return this.curioSlotContext != null ? CuriosInterop.getCurioFromSlot((LivingEntity)this.f_96541_.f_91074_, this.curioSlotContext) : this.f_96541_.f_91074_.m_21120_(this.hand);
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof SpellRadialSelect) {
            event.setCanceled(true);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ClientEventHandler.wipeOpen();
    }

    public void m_86600_() {
        super.m_86600_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.m_91087_().m_91152_(null);
            ClientEventHandler.wipeOpen();
        }
        if (!this.menu.isReady() || this.inventory == null) {
            return;
        }
        ItemStack inHand = this.getTargetItem();
        if (!(inHand.m_41720_() instanceof ItemSpellBook)) {
            this.inventory = null;
        } else {
            ItemStack stack = inHand;
            if (stack.m_41613_() <= 0) {
                this.inventory = null;
                this.stackEquipped = null;
            } else if (this.stackEquipped != stack) {
                this.menu.close();
            }
        }
        if (this.inventory == null) {
            Minecraft.m_91087_().m_91152_(null);
        } else if (!ClientEventHandler.isKeyDown((KeyMapping)KeybindInit.RadialMenuOpen.get())) {
            this.processClick(false);
        }
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.inventory == null) {
            return;
        }
        ItemStack inHand = this.getTargetItem();
        if (!(inHand.m_41720_() instanceof ItemSpellBook)) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            ItemStack[] activeSpells = this.inventory.getActiveSpells();
            int i = 0;
            while (i < activeSpells.length) {
                ItemStack inSlot = activeSpells[i];
                int index = i++;
                LocalPlayer player = this.f_96541_.f_91074_;
                ItemStackRadialMenuItem item = new ItemStackRadialMenuItem(this.menu, inSlot, (Component)Component.m_237115_((String)"gui.mna.spellbook.empty"), (Player)player, inHand, index){
                    final /* synthetic */ Player val$player;
                    final /* synthetic */ ItemStack val$inHand;
                    final /* synthetic */ int val$index;
                    {
                        this.val$player = player;
                        this.val$inHand = itemStack;
                        this.val$index = n;
                        super(owner, stack, altText);
                    }

                    @Override
                    public boolean onClick() {
                        ItemSpellBook.setSlot(this.val$player, this.val$inHand, this.val$index, SpellRadialSelect.this.hand, SpellRadialSelect.this.curioSlotContext, true);
                        SpellRadialSelect.this.menu.close();
                        return true;
                    }
                };
                item.setVisible(true);
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.needsRecheckStacks = false;
        }
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((Component)Component.m_237115_((String)"gui.mna.spellbook.empty"));
        } else {
            this.menu.setCentralText(null);
        }
        this.menu.draw(pGuiGraphics, partialTicks, mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }
}

