/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.item;

import com.mna.gui.containers.ContainerInit;
import com.mna.gui.containers.LargeContainer;
import com.mna.gui.containers.slots.ExtendedItemStackFilterSlot;
import com.mna.gui.containers.slots.ExtendedItemStackSlot;
import com.mna.interop.CuriosInterop;
import com.mna.inventory.InventoryRitualKit;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ItemPractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerPractitionersPouch
extends LargeContainer {
    private InventoryRitualKit inventory;
    public int bagHash;
    protected int mySlot;
    private int myPlayerIndex;
    private HashMap<PractitionersPouchPatches, ArrayList<ExtendedItemStackFilterSlot>> patchSlots;

    public ContainerPractitionersPouch(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, buffer.readBoolean() ? new InventoryRitualKit(CuriosInterop.GetNthCurio((LivingEntity)playerInventory.f_35978_, buffer.m_130277_(), buffer.readInt())) : new InventoryRitualKit(playerInventory.m_8020_(playerInventory.f_35977_)));
    }

    public ContainerPractitionersPouch(int windowID, Inventory playerInv, InventoryRitualKit kitInv) {
        super((MenuType)ContainerInit.RITUAL_KIT.get(), windowID, playerInv, kitInv);
        this.inventory = kitInv;
        this.bagHash = kitInv.getStack().hashCode();
        this.myPlayerIndex = kitInv.curioSlotIdentifier != null ? -1 : playerInv.f_35977_;
        this.patchSlots = new HashMap();
        this.initializeSlots(playerInv);
    }

    protected void initializeSlots(Inventory playerInv) {
        int col;
        int slotIndex = 0;
        int bagSlotIndex = 0;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 7; ++col) {
                this.m_38897_((Slot)new ExtendedItemStackSlot(this.inventory, bagSlotIndex++, 18 + col * 18, 75 + row * 18).blacklistItem((Item)ItemInit.PRACTITIONERS_POUCH.get()).blacklistItem((Item)ItemInit.MITHIONS_MAGNIFICENT_MBAG.get()).blacklistItem(Items.f_42265_));
                ++slotIndex;
            }
        }
        PractitionersPouchPatches[] patches = PractitionersPouchPatches.values();
        for (int i = 0; i < patches.length; ++i) {
            PractitionersPouchPatches patch = patches[i];
            if (!patch.hasInventory()) continue;
            ArrayList<ExtendedItemStackFilterSlot> patchSlotList = new ArrayList<ExtendedItemStackFilterSlot>();
            for (int row = 0; row < patch.getInventoryRows(); ++row) {
                for (int col2 = 0; col2 < patch.getInventoryCols(); ++col2) {
                    ExtendedItemStackFilterSlot patchSlot = new ExtendedItemStackFilterSlot(this.inventory, bagSlotIndex++, 164 + col2 * 18, patch.getRowStart() + row * 18, patch.getSlotFilter());
                    if (playerInv.f_35978_.m_9236_().m_5776_()) {
                        patchSlot.setActive(false);
                    }
                    this.m_38897_((Slot)patchSlot);
                    patchSlotList.add(patchSlot);
                    ++slotIndex;
                }
            }
            this.patchSlots.put(patch, patchSlotList);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col3 = 0; col3 < 9; ++col3) {
                this.m_38897_(new Slot((Container)playerInv, col3 + row * 9 + 9, 48 + col3 * 18, 144 + row * 18));
                ++slotIndex;
            }
        }
        for (col = 0; col < 9; ++col) {
            if (col == playerInv.f_35977_) {
                this.mySlot = slotIndex;
            }
            this.m_38897_(new Slot((Container)playerInv, col, 48 + col * 18, 202));
            ++slotIndex;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setPatchActive(PractitionersPouchPatches patch) {
        this.patchSlots.entrySet().forEach(e -> ((ArrayList)e.getValue()).forEach(v -> v.setActive(false)));
        if (patch != null && this.patchSlots.containsKey((Object)patch)) {
            this.patchSlots.get((Object)patch).forEach(s -> s.setActive(true));
        }
    }

    @Override
    public boolean m_6875_(Player p_75145_1_) {
        return true;
    }

    public boolean patchEnabled(PractitionersPouchPatches patch, int level) {
        return ((ItemPractitionersPouch)this.inventory.getStack().m_41720_()).getPatchLevel(this.inventory.getStack(), patch) >= level;
    }

    @Override
    public void m_38946_() {
        if (!this.isClientside) {
            this.inventory.writeItemStack();
        }
        super.m_38946_();
    }

    @Override
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId == this.mySlot || clickTypeIn == ClickType.SWAP && dragType == this.myPlayerIndex) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        int mainSlots = 21;
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < mainSlots ? !this.m_38903_(itemstack1, mainSlots, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, mainSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    @Override
    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean wrap) {
        boolean flag = false;
        int i = startIndex;
        if (wrap) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!wrap ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = slot.m_6641_())) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (wrap) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = wrap ? endIndex - 1 : startIndex;
            while (!(!wrap ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(stack)) {
                    if (stack.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(stack.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (wrap) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }
}

