/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.tools.math.Vector3;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class EldrinFlight
extends Entity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<BlockPos> END_POS = SynchedEntityData.m_135353_(EldrinFlight.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private Vector3 startPosition;
    private Vector3 endPosition;
    private Vector3 controlPointA;
    private Vector3 controlPointB;
    private float travelTime;
    private Player player;
    private int age = 0;
    private boolean heightAdjusted = false;
    private static final int MIN_Y = 4;

    public EldrinFlight(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EldrinFlight(Level world, Player player, Vec3 start, Vec3 end) {
        super((EntityType)EntityInit.ELDRIN_FLIGHT.get(), world);
        this.player = player;
        this.startPosition = new Vector3(start);
        if (!world.f_46443_) {
            if (end.f_82480_ == -1.0) {
                ChunkAccess chunk = world.m_46865_(BlockPos.m_274446_((Position)end));
                int yPos = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, (int)end.m_7096_(), (int)end.m_7094_());
                this.endPosition = new Vector3(end.f_82479_, yPos + 1, end.f_82481_);
            } else {
                this.endPosition = new Vector3(end);
            }
        } else {
            this.endPosition = new Vector3(end);
        }
        Vector3 delta = this.endPosition.sub(this.startPosition);
        this.controlPointA = this.startPosition.add(delta.scale(0.33f)).add(new Vector3(0.0, 100.0, 0.0));
        this.controlPointB = this.startPosition.add(delta.scale(0.66f)).add(new Vector3(0.0, 100.0, 0.0));
        this.f_19794_ = true;
        float blocksPerSecond = 50.0f;
        this.travelTime = delta.length() / blocksPerSecond * 20.0f;
        this.m_6034_(start.m_7096_(), start.m_7098_(), start.m_7094_());
    }

    public void m_8119_() {
        ++this.age;
        if (!(this.m_9236_().m_5776_() || this.startPosition != null && this.endPosition != null && this.controlPointA != null && this.controlPointB != null)) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.m_9236_().m_5776_()) {
            if (this.player != null) {
                this.player.getPersistentData().m_128379_("eldrin_flight", true);
            }
            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Math.random() - 0.5) * 0.2, 0.0, (Math.random() - 0.5) * 0.2);
            if (this.age < 60 && this.age % 10 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.TRAIL.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)this.m_19879_(), this.m_9236_().m_213780_().m_188500_(), (double)(this.travelTime + 70.0f - (float)this.age));
            }
        } else if (this.age == 1 && this.player != null) {
            this.player.m_7998_((Entity)this, true);
        }
        if (!this.heightAdjusted) {
            if (this.getEndPos().m_123341_() == 0 && this.getEndPos().m_123342_() == 0 && this.getEndPos().m_123343_() == 0) {
                this.setEndPos(BlockPos.m_274446_((Position)this.endPosition.toVec3D()));
            }
            if (this.m_9236_().m_46749_(this.getEndPos())) {
                BlockPos test = this.getEndPos();
                if (test.m_123342_() >= this.m_9236_().m_6042_().f_63865_()) {
                    int delta = this.m_9236_().m_6042_().f_63865_() - 3 - test.m_123342_();
                    test = test.m_7918_(0, delta, 0);
                }
                while (test.m_123342_() > 4 && !this.m_9236_().m_46859_(test) && !this.m_9236_().m_46859_(test.m_7494_())) {
                    test = test.m_7495_();
                }
                while (test.m_123342_() > 4 && this.m_9236_().m_46859_(test.m_7495_())) {
                    test = test.m_7495_();
                }
                while (test.m_123342_() < this.m_9236_().m_141928_() - 3 && !this.m_9236_().m_46859_(test) && !this.m_9236_().m_46859_(test.m_7494_())) {
                    test = test.m_7494_();
                }
                if (!this.m_9236_().m_46859_(test) && !this.m_9236_().m_46859_(test.m_7494_())) {
                    test.m_7918_(0, this.m_9236_().m_141928_() - test.m_123342_(), 0);
                }
                this.setEndPos(test);
                this.endPosition = new Vector3(test);
                this.heightAdjusted = true;
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_20197_().size() == 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if ((float)this.age < this.travelTime) {
            Vector3 tickPos = Vector3.bezier(this.startPosition, this.endPosition, this.controlPointA, this.controlPointB, (float)this.age / this.travelTime);
            Vector3 nextTickPos = Vector3.bezier(this.startPosition, this.endPosition, this.controlPointA, this.controlPointB, (float)this.age + 1.0f / this.travelTime);
            this.m_6034_(tickPos.x, tickPos.y, tickPos.z);
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, nextTickPos.toVec3D());
        } else if ((float)this.age >= this.travelTime && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            if (this.player != null) {
                this.player.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            }
        }
    }

    public void onRemovedFromWorld() {
        if (this.player != null) {
            if (this.m_9236_().m_5776_()) {
                for (int i = 0; i < 200; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), (Math.random() - 0.5) * 0.2, Math.random() * 0.2, (Math.random() - 0.5) * 0.2);
                }
                ManaAndArtifice.instance.proxy.resetRenderViewEntity();
            }
            this.player.getPersistentData().m_128473_("eldrin_flight");
            this.player.getPersistentData().m_128473_("eldrin_flight_entity_id");
            this.player.f_19789_ = 0.0f;
            this.player.m_21195_((MobEffect)EffectInit.ELDRIN_FLIGHT.get());
        }
        super.onRemovedFromWorld();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(END_POS, (Object)BlockPos.f_121853_);
    }

    private void setEndPos(BlockPos pos) {
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(END_POS, (Object)pos);
        }
    }

    private BlockPos getEndPos() {
        return (BlockPos)this.f_19804_.m_135370_(END_POS);
    }

    public void m_7350_(EntityDataAccessor<?> p_184206_1_) {
        super.m_7350_(p_184206_1_);
        if (p_184206_1_ == END_POS && this.m_9236_().m_5776_()) {
            this.heightAdjusted = true;
            this.endPosition = new Vector3(this.getEndPos());
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("start")) {
            this.startPosition = Vector3.readFromNBT(compound.m_128469_("start"));
        }
        if (compound.m_128441_("end")) {
            this.endPosition = Vector3.readFromNBT(compound.m_128469_("end"));
        }
        if (compound.m_128441_("control_a")) {
            this.controlPointA = Vector3.readFromNBT(compound.m_128469_("control_a"));
        }
        if (compound.m_128441_("control_b")) {
            this.controlPointB = Vector3.readFromNBT(compound.m_128469_("control_b"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        CompoundTag start = new CompoundTag();
        CompoundTag end = new CompoundTag();
        CompoundTag control_a = new CompoundTag();
        CompoundTag control_b = new CompoundTag();
        this.startPosition.writeToNBT(start);
        this.endPosition.writeToNBT(end);
        this.controlPointA.writeToNBT(control_a);
        this.controlPointB.writeToNBT(control_b);
        compound.m_128365_("start", (Tag)start);
        compound.m_128365_("end", (Tag)end);
        compound.m_128365_("control_a", (Tag)control_a);
        compound.m_128365_("control_b", (Tag)control_b);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.player != null) {
            buffer.writeInt(this.player.m_19879_());
        } else {
            buffer.writeInt(-1);
        }
        buffer.writeFloat(this.travelTime);
        if (this.startPosition != null) {
            buffer.writeDouble((double)this.startPosition.x);
            buffer.writeDouble((double)this.startPosition.y);
            buffer.writeDouble((double)this.startPosition.z);
        }
        if (this.endPosition != null) {
            buffer.writeDouble((double)this.endPosition.x);
            buffer.writeDouble((double)this.endPosition.y);
            buffer.writeDouble((double)this.endPosition.z);
        }
        if (this.controlPointA != null) {
            buffer.writeDouble((double)this.controlPointA.x);
            buffer.writeDouble((double)this.controlPointA.y);
            buffer.writeDouble((double)this.controlPointA.z);
        }
        if (this.controlPointB != null) {
            buffer.writeDouble((double)this.controlPointB.x);
            buffer.writeDouble((double)this.controlPointB.y);
            buffer.writeDouble((double)this.controlPointB.z);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        Entity e = this.m_9236_().m_6815_(additionalData.readInt());
        if (e instanceof Player) {
            this.player = (Player)e;
        }
        this.travelTime = additionalData.readFloat();
        this.startPosition = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.endPosition = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.controlPointA = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        this.controlPointB = new Vector3(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
    }
}

