/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.particles.types.movers.ParticleVelocityMover;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellFocus
extends ChanneledSpellEntity {
    public SpellFocus(EntityType<? extends SpellFocus> entityType, Level world) {
        super(entityType, world);
    }

    public SpellFocus(LivingEntity caster, ISpellDefinition spell, Level world, Vec3 position) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_FOCUS.get()), caster, spell, world);
        this.m_146884_(position);
    }

    @Override
    public void m_8119_() {
        if (this.getCaster() == null) {
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        this.getCaster().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            Vec3 pos = this.getCaster().m_146892_().m_82549_(this.getCaster().m_20156_().m_82541_().m_82490_((double)m.getFocusDistance()));
            ClipContext ctx = new ClipContext(this.getCaster().m_146892_(), pos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
            BlockHitResult bhr = this.m_9236_().m_45547_(ctx);
            if (bhr.m_6662_() == HitResult.Type.BLOCK) {
                pos = bhr.m_82450_();
            }
            this.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        });
        super.m_8119_();
    }

    @Override
    protected int getApplicationRate() {
        return 1;
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        float spellRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
        SpellContext context = new SpellContext(this.m_9236_(), recipe, this);
        SpellSource source = new SpellSource(caster, InteractionHand.MAIN_HAND);
        Direction face = Direction.UP;
        HashMap<SpellEffect, ComponentApplicationResult> results = new HashMap<SpellEffect, ComponentApplicationResult>();
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
            int radius = (int)Math.floor(spellRadius);
            if (radius < 0) {
                radius = 0;
            }
            if (radius > 0) {
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        for (int k = -radius; k <= radius; ++k) {
                            BlockPos adjusted = this.m_20183_().m_7918_(i, j, k);
                            results.putAll(SpellCaster.ApplyComponents(recipe, source, new SpellTarget(adjusted, face).doNotOffsetFace(), context));
                        }
                    }
                }
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
            float radius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
            List targets = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)radius), e -> !e.m_20147_() && e.m_6084_() && e instanceof LivingEntity);
            for (Entity target : targets) {
                if (target == null || target == caster) continue;
                results.putAll(SpellCaster.ApplyComponents(recipe, source, new SpellTarget(target), context));
            }
        }
        if (results.size() > 0) {
            List<SpellEffect> appliedEffects = results.entrySet().stream().map(e -> e.getValue() == ComponentApplicationResult.SUCCESS ? (SpellEffect)e.getKey() : null).filter(e -> e != null).collect(Collectors.toList());
            SpellCaster.spawnClientFX(this.m_9236_(), this.m_20182_(), Vec3.f_82478_, source, appliedEffects);
        }
    }

    private void spawnParticle(MAParticleType particle) {
        float radius = Math.max(1.0f, ((ModifiedSpellPart)this.getSpell().getShape()).getValue(Attribute.RADIUS));
        Vec3 end = this.m_20182_();
        int i = 0;
        while ((float)i < 3.0f * radius + 1.0f) {
            Vec3 start = this.m_20182_().m_82520_((double)(-radius) + (double)(2.0f * radius) * Math.random(), (double)(-radius) + (double)(2.0f * radius) * Math.random(), (double)(-radius) + (double)(2.0f * radius) * Math.random());
            this.m_9236_().m_7106_((ParticleOptions)particle, start.f_82479_, start.f_82480_, start.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_);
            ++i;
        }
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_LERP.get())).setScale(0.05f).setColor(10, 10, 10), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnEarthParticles(SpellRecipe recipe) {
        this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST_LERP.get())), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        if (lightning) {
            this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getCaster()));
        } else if (hellfire) {
            this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())).setMover(new ParticleVelocityMover(0.0, 0.1f, 0.0, true)), (Entity)this.getCaster()));
        } else {
            this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_LERP.get())), (Entity)this.getCaster()));
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean ice) {
        this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER_LERP.get())), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe) {
        this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)this.getCaster()));
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        this.spawnParticle(recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_LERP.get())), (Entity)this.getCaster()));
    }
}

