/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.base;

import com.mna.api.affinity.Affinity;
import com.mna.api.sound.SFX;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.Shape;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.sound.EntityAliveLoopingSound;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class ChanneledSpellEntity
extends Entity {
    private static final EntityDataAccessor<Integer> CASTER_ID = SynchedEntityData.m_135353_(ChanneledSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<CompoundTag> SPELL_RECIPE = SynchedEntityData.m_135353_(ChanneledSpellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final String NBT_CASTER_UUID = "caster_uuid";
    private static final String NBT_SPELL = "spell";
    private LivingEntity __cachedCaster = null;
    private SpellRecipe __cachedRecipe = null;
    private boolean __playedsound = false;
    private Affinity[] cachedAffinities = null;

    public ChanneledSpellEntity(EntityType<? extends ChanneledSpellEntity> entityType, Level world) {
        super(entityType, world);
        this.m_20242_(true);
        this.m_20331_(true);
    }

    public ChanneledSpellEntity(EntityType<? extends ChanneledSpellEntity> entityType, LivingEntity caster, ISpellDefinition spell, Level world) {
        this(entityType, world);
        this.setCaster(caster);
        this.setSpell(spell);
    }

    public void m_8119_() {
        LivingEntity caster = this.getCaster();
        if (caster == null || !caster.m_6084_() || !caster.m_9236_().m_46472_().equals(this.m_9236_().m_46472_()) || caster.m_21212_() <= 0 || caster.m_21211_().m_41619_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ >= this.getMaxAge()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        SpellRecipe recipe = this.getSpell();
        if (!this.m_9236_().m_5776_() && !recipe.isValid()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        boolean distanceSkip = this.m_20182_().m_82531_(this.f_19854_, this.f_19855_, this.f_19856_) > 4.0;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (distanceSkip) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ > 0 && (this.getApplicationRate() == 1 || this.f_19797_ % this.getApplicationRate() == 0)) {
                this.applyEffect(caster.m_21211_(), recipe, caster, (ServerLevel)this.m_9236_());
            }
        } else {
            this.spawnParticles();
            this.playSounds();
        }
    }

    protected int getApplicationRate() {
        return 10;
    }

    protected abstract void applyEffect(ItemStack var1, SpellRecipe var2, LivingEntity var3, ServerLevel var4);

    protected SoundEvent getSoundEffect(SpellRecipe recipe) {
        switch (recipe.getHighestAffinity()) {
            case ARCANE: {
                return SFX.Loops.ARCANE;
            }
            case EARTH: {
                return SFX.Loops.EARTH;
            }
            case ENDER: {
                return SFX.Loops.ENDER;
            }
            case FIRE: {
                return SFX.Loops.FIRE;
            }
            case HELLFIRE: {
                return SFX.Loops.FIRE;
            }
            case LIGHTNING: {
                return SFX.Loops.LIGHTNING;
            }
            case WATER: {
                return SFX.Loops.WATER;
            }
            case ICE: {
                return SFX.Loops.ICE;
            }
            case WIND: {
                return SFX.Loops.AIR;
            }
        }
        return SFX.Loops.MANAWEAVING;
    }

    protected abstract void spawnAirParticles(SpellRecipe var1);

    protected abstract void spawnEarthParticles(SpellRecipe var1);

    protected abstract void spawnFireParticles(SpellRecipe var1, boolean var2, boolean var3);

    protected abstract void spawnWaterParticles(SpellRecipe var1, boolean var2);

    protected abstract void spawnEnderParticles(SpellRecipe var1);

    protected abstract void spawnArcaneParticles(SpellRecipe var1);

    protected void spawnParticles() {
        SpellRecipe recipe = this.getSpell();
        if (recipe == null) {
            return;
        }
        if (this.cachedAffinities == null) {
            this.cachedAffinities = recipe.getAffinity().keySet().toArray(new Affinity[0]);
        }
        switch (this.cachedAffinities[(int)(Math.random() * (double)this.cachedAffinities.length)]) {
            case ARCANE: {
                this.spawnArcaneParticles(recipe);
                break;
            }
            case EARTH: {
                this.spawnEarthParticles(recipe);
                break;
            }
            case ENDER: {
                this.spawnEnderParticles(recipe);
                break;
            }
            case FIRE: {
                this.spawnFireParticles(recipe, false, false);
                break;
            }
            case HELLFIRE: {
                this.spawnFireParticles(recipe, true, false);
                break;
            }
            case LIGHTNING: {
                this.spawnFireParticles(recipe, false, true);
                break;
            }
            case WATER: {
                this.spawnWaterParticles(recipe, false);
                break;
            }
            case ICE: {
                this.spawnWaterParticles(recipe, true);
                break;
            }
            case WIND: {
                this.spawnAirParticles(recipe);
                break;
            }
            default: {
                this.spawnArcaneParticles(recipe);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void playSounds() {
        if (this.__playedsound) {
            return;
        }
        SpellRecipe recipe = this.getSpell();
        if (recipe == null) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityAliveLoopingSound(this.getSoundEffect(recipe), this));
        this.__playedsound = true;
    }

    protected float getShapeAttributeByAge(Attribute attr) {
        float base;
        SpellRecipe recipe = this.getSpell();
        if (recipe == null || recipe.getShape() == null) {
            return 0.0f;
        }
        float adjusted = ((ModifiedSpellPart)recipe.getShape()).getValue(attr);
        if (adjusted < (base = ((ModifiedSpellPart)recipe.getShape()).getDefaultValue(attr))) {
            return adjusted;
        }
        return base + (adjusted - base) * Math.min((float)this.f_19797_ / 30.0f, 1.0f);
    }

    @Nullable
    public LivingEntity getCaster() {
        if (this.__cachedCaster == null) {
            int id = (Integer)this.f_19804_.m_135370_(CASTER_ID);
            Entity found = this.m_9236_().m_6815_(id);
            if (found != null && found instanceof LivingEntity) {
                this.__cachedCaster = (LivingEntity)found;
            }
        }
        return this.__cachedCaster;
    }

    public void setCaster(LivingEntity caster) {
        if (caster != null) {
            this.f_19804_.m_135381_(CASTER_ID, (Object)caster.m_19879_());
        }
    }

    public float getShapeAttribute(Attribute attr) {
        SpellRecipe recipe = this.getSpell();
        if (recipe == null || recipe.getShape() == null) {
            return 0.0f;
        }
        return ((ModifiedSpellPart)recipe.getShape()).getValue(attr);
    }

    protected int getMaxAge() {
        if (this.getSpell() == null || this.getSpell().getShape() == null || ((ModifiedSpellPart)this.getSpell().getShape()).getPart() == null || this.getCaster() == null) {
            return 100;
        }
        float multiplier = 1.0f;
        if (this.getCaster() != null && EnchantmentHelper.m_44831_((ItemStack)this.getCaster().m_21211_()).containsKey(Enchantments.f_44958_)) {
            multiplier = 2.0f;
        }
        return (int)((float)((Shape)((ModifiedSpellPart)this.getSpell().getShape()).getPart()).maxChannelTime(this.getSpell().getShape()) * multiplier);
    }

    public SpellRecipe getSpell() {
        if (this.__cachedRecipe == null) {
            this.__cachedRecipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
        }
        return this.__cachedRecipe;
    }

    public void setSpell(ISpellDefinition spell) {
        CompoundTag nbt = new CompoundTag();
        spell.writeToNBT(nbt);
        this.f_19804_.m_135381_(SPELL_RECIPE, (Object)nbt);
    }

    protected boolean losCheck(Entity other) {
        Vec3 vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vector3d1 = new Vec3(other.m_20185_(), other.m_20188_(), other.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    protected boolean losCheck(BlockPos pos) {
        if (this.__cachedRecipe != null && this.__cachedRecipe.getComponents().stream().noneMatch(c -> ((SpellEffect)c.getPart()).getUseTag() == SpellPartTags.HARMFUL)) {
            return true;
        }
        Vec3 vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vector3d1 = Vec3.m_82512_((Vec3i)pos);
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return result.m_82425_().equals((Object)pos);
        }
        return result.m_6662_() == HitResult.Type.MISS;
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_(NBT_SPELL, (Tag)this.f_19804_.m_135370_(SPELL_RECIPE));
        int casterId = (Integer)this.f_19804_.m_135370_(CASTER_ID);
        compound.m_128405_(NBT_CASTER_UUID, casterId);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(NBT_SPELL)) {
            this.f_19804_.m_135381_(SPELL_RECIPE, (Object)((CompoundTag)compound.m_128423_(NBT_SPELL)));
        }
        if (compound.m_128441_(NBT_CASTER_UUID)) {
            this.f_19804_.m_135381_(CASTER_ID, (Object)compound.m_128451_(NBT_CASTER_UUID));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CASTER_ID, (Object)-1);
        this.f_19804_.m_135372_(SPELL_RECIPE, (Object)new CompoundTag());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public final int getOverrideColor() {
        LivingEntity caster = this.getCaster();
        SpellRecipe recipe = this.getSpell();
        if (caster == null || recipe == null) {
            return -1;
        }
        MutableInt color = new MutableInt(-1);
        if (caster instanceof Player) {
            caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> color.setValue(m.getParticleColorOverride()));
        }
        if (color.getValue() == -1) {
            color.setValue(recipe.getParticleColorOverride());
        }
        return color.getValue();
    }
}

