/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery;

import com.mna.entities.EntityInit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityDecoy
extends Mob {
    private static final EntityDataAccessor<Optional<UUID>> RENDER_AS_UUID = SynchedEntityData.m_135353_(EntityDecoy.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(EntityDecoy.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntityDecoy.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAGNITUDE = SynchedEntityData.m_135353_(EntityDecoy.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Player _cachedRenderAs;
    private HashSet<LivingEntity> _affectedEntities = new HashSet();

    public EntityDecoy(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityDecoy(Player caster, Level world, Vec3 position, float speed, float radius, float magnitude) {
        this((EntityType<? extends Mob>)((EntityType)EntityInit.DECOY_ENTITY.get()), world);
        this.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, caster.m_5675_(0.0f), caster.m_5686_(0.0f));
        this.setPlayer(caster);
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
        this.f_19804_.m_135381_(MAGNITUDE, (Object)Float.valueOf(magnitude));
        this._affectedEntities = new HashSet();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_21344_.m_26571_() && !this.m_9236_().m_5776_()) {
            Vec3 fwd = this.m_20182_().m_82549_(Vec3.m_82503_((Vec2)this.m_20155_()).m_82541_().m_82490_(30.0));
            this.f_21344_.m_26519_(fwd.f_82479_, fwd.f_82480_, fwd.f_82481_, (double)((Float)this.f_19804_.m_135370_(SPEED)).floatValue());
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)((Float)this.f_19804_.m_135370_(RADIUS)).floatValue(), 2.0, (double)((Float)this.f_19804_.m_135370_(RADIUS)).floatValue()), e -> e instanceof PathfinderMob && Math.random() <= (double)(((Float)this.f_19804_.m_135370_(MAGNITUDE)).floatValue() / 10.0f)).stream().map(e -> (PathfinderMob)e).forEach(e -> {
                if (!this._affectedEntities.contains(e)) {
                    e.m_6710_((LivingEntity)this);
                    this._affectedEntities.add((LivingEntity)e);
                }
            });
        }
        if (this.f_19797_ > 300) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public Player getPlayer() {
        if (this._cachedRenderAs == null) {
            Optional param = (Optional)this.f_19804_.m_135370_(RENDER_AS_UUID);
            if (!param.isPresent()) {
                return null;
            }
            UUID uuid = (UUID)param.get();
            this._cachedRenderAs = this.m_9236_().m_46003_(uuid);
        }
        return this._cachedRenderAs;
    }

    public void setPlayer(Player player) {
        this.f_19804_.m_135381_(RENDER_AS_UUID, Optional.of(player.m_20148_()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RENDER_AS_UUID, Optional.empty());
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(3.0f));
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(MAGNITUDE, (Object)Float.valueOf(5.0f));
    }

    protected void m_8099_() {
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22278_, 1.0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

