/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.construct;

import com.mna.ManaAndArtifice;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.IConstructConstruction;
import com.mna.api.entities.construct.ItemConstructPart;
import com.mna.api.tools.RLoc;
import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.models.constructs.ConstructModel;
import com.mna.entities.models.constructs.modular.ConstructMaterialModel;
import com.mna.entities.models.constructs.modular.ConstructModelRegistry;
import com.mna.entities.renderers.MAGeckoRenderer;
import com.mna.items.constructs.parts.torso.ConstructPartManaTorso;
import com.mna.items.constructs.parts.torso.ConstructPartTankTorso;
import com.mna.tools.math.MathUtils;
import com.mna.tools.render.ModelUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.util.RenderUtils;

public class ConstructRenderer
extends MAGeckoRenderer<Construct> {
    private static final ResourceLocation FISHING_HOOK_TEX = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType BOBBER_RENDER = RenderType.m_110452_((ResourceLocation)FISHING_HOOK_TEX);
    public static final ConstructModel constructModel = new ConstructModel();
    public static ConstructRenderer instance;
    public static final ResourceLocation model_brb_mining;
    public static final ResourceLocation model_brb_adventuring;
    public static final ResourceLocation model_brb_hunting;
    private final ItemRenderer itemRenderer;
    private RenderReferenceStack renderStack = null;
    private float fillPct = 0.0f;
    Matrix4f pos;
    Matrix3f normal;
    Minecraft mc = Minecraft.m_91087_();

    public ConstructRenderer(EntityRendererProvider.Context context) {
        super(context, constructModel);
        this.itemRenderer = this.mc.m_91291_();
        instance = this;
    }

    @Override
    public void defaultRender(PoseStack poseStack, Construct animatable, MultiBufferSource bufferSource, RenderType renderType, VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        RenderReferenceStack latest;
        Color renderColor = this.getRenderColor((GeoAnimatable)animatable, partialTick, packedLight);
        float red = renderColor.getRedFloat();
        float green = renderColor.getGreenFloat();
        float blue = renderColor.getBlueFloat();
        float alpha = renderColor.getAlphaFloat();
        int packedOverlay = this.getPackedOverlay((Entity)animatable, 0.0f);
        BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)animatable));
        this.renderStack = latest = new RenderReferenceStack(animatable.m_21205_(), animatable.m_21206_(), animatable.getConstructData().getHat(), animatable.getConstructData().getBanner());
        latest.model = (ConstructModel)this.getGeoModel();
        latest.data = animatable.getConstructData();
        latest.model.getBakedModel(latest.model.getModelResource(animatable));
        for (ConstructMaterial matl : latest.data.getComposition()) {
            latest.setVisibilityMatrix(animatable, matl);
            poseStack.m_85836_();
            this.renderPass(poseStack, animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight, model, red, green, blue, alpha, packedOverlay);
            poseStack.m_85849_();
        }
        animatable.getConstructData().getPart(ConstructSlot.TORSO).ifPresent(p -> {
            if (p instanceof ConstructPartManaTorso) {
                this.fillPct = animatable.getManaPct();
                this.renderChargeBar(packedLight, ((float)animatable.f_19797_ + partialTick) / 5.0f, bufferSource);
            } else if (p instanceof ConstructPartTankTorso) {
                this.fillPct = (float)animatable.getStoredFluidAmount() / (float)animatable.getTankCapacity(1);
                this.renderFluidBar(bufferSource, packedLight, partialTick, animatable, poseStack);
            }
        });
        this.renderFishingLine(bufferSource, animatable, partialTick, poseStack);
        this.renderHeldItems(bufferSource);
    }

    private void renderPass(PoseStack poseStack, Construct animatable, MultiBufferSource bufferSource, RenderType renderType, VertexConsumer buffer, float yaw, float partialTick, int packedLight, BakedGeoModel model, float red, float green, float blue, float alpha, int packedOverlay) {
        this.emissivePass = false;
        if (renderType == null) {
            renderType = this.getRenderType(animatable, this.m_5478_((Entity)animatable), bufferSource, partialTick);
        }
        if (buffer == null) {
            buffer = bufferSource.m_6299_(renderType);
        }
        poseStack.m_85836_();
        this.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.firePreRenderEvent(poseStack, model, bufferSource, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, (GeoAnimatable)animatable, model, renderType, bufferSource, buffer, packedLight, packedLight, packedOverlay);
            this.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.applyRenderLayers(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
            this.postRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.firePostRenderEvent(poseStack, model, bufferSource, partialTick, packedLight);
        }
        poseStack.m_85849_();
        this.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void render(Construct entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110451_());
        int away_type = entityIn.getAwayType();
        if (away_type != 0) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(entityIn.yaw_rnd));
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(entityIn.pitch_rnd));
            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(entityIn.roll_rnd));
            switch (entityIn.getAwayType()) {
                case 1: {
                    ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_brb_mining, matrixStackIn, packedLightIn, OverlayTexture.f_118083_);
                    break;
                }
                case 2: {
                    ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_brb_adventuring, matrixStackIn, packedLightIn, OverlayTexture.f_118083_);
                    break;
                }
                case 3: {
                    ModelUtils.renderEntityModel(builder, (Level)this.mc.f_91073_, model_brb_hunting, matrixStackIn, packedLightIn, OverlayTexture.f_118083_);
                }
            }
            matrixStackIn.m_85849_();
        }
        if (entityIn.isRenderDisabled()) {
            return;
        }
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderChargeBar(int packedLight, float partialTicks, MultiBufferSource bufferSource) {
        if (bufferSource == null || this.pos == null || this.normal == null) {
            return;
        }
        float alpha = this.fillPct > 0.2f ? 1.0f : Math.abs((float)Math.sin(partialTicks));
        float[] fullColor = new float[]{0.0f, 1.0f, 0.0f, alpha};
        float[] emptyColor = new float[]{1.0f, 0.0f, 0.0f, alpha};
        float width = 0.028f;
        float min = 0.65f;
        float height = 0.25f;
        VertexConsumer builder = bufferSource.m_6299_(RenderType.m_173242_());
        float[] rgba = new float[]{MathUtils.lerpf(emptyColor[0], fullColor[0], this.fillPct), MathUtils.lerpf(emptyColor[1], fullColor[1], this.fillPct), MathUtils.lerpf(emptyColor[2], fullColor[2], this.fillPct), MathUtils.lerpf(emptyColor[3], fullColor[3], this.fillPct)};
        Vector3f nrm = new Vector3f(1.0f, 0.0f, 0.0f);
        nrm.mul((Matrix3fc)this.normal);
        builder.m_252986_(this.pos, -width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(0.0f, 0.0f);
        builder.m_86008_(0);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(1.0f, 0.0f);
        builder.m_86008_(0);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, width, min + height * this.fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(1.0f, 1.0f);
        builder.m_86008_(0);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, -width, min + height * this.fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(0.0f, 1.0f);
        builder.m_86008_(0);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
    }

    private void renderFluidBar(MultiBufferSource bufferIn, int packedLight, float partialTicks, Construct entity, PoseStack matrixStackIn) {
        if (this.pos == null || this.normal == null || entity == null || entity.getStoredFluid() == null) {
            return;
        }
        boolean isBone = entity.getConstructData().getSlotMaterial(ConstructSlot.TORSO) == ConstructMaterial.BONE;
        float width = 0.1f;
        float min = isBone ? 0.7125f : 0.65f;
        float height = isBone ? 0.25f : 0.3125f;
        FluidType attrs = entity.getStoredFluid().getFluidType();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((FluidType)attrs);
        ResourceLocation fluidTexBase = extension.getStillTexture();
        if (fluidTexBase == null) {
            return;
        }
        TextureAtlasSprite sp = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidTexBase);
        RenderType liquid = RenderType.m_110431_((ResourceLocation)TextureAtlas.f_118259_);
        VertexConsumer builder = bufferIn.m_6299_(liquid);
        int color = extension.getTintColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float[] rgba = new float[]{r, g, b, a};
        Vector3f nrm = new Vector3f(0.0f, 1.0f, 0.0f);
        nrm.mul((Matrix3fc)this.normal);
        float maxV = sp.m_118411_() + (sp.m_118412_() - sp.m_118411_()) * this.fillPct;
        int light = 0xF000F0;
        builder.m_252986_(this.pos, -width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118409_(), sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, width, min, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118410_(), sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, width, min + height * this.fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118410_(), maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, -width, min + height * this.fillPct, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118409_(), maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(light);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        float topY = min + height * this.fillPct;
        builder.m_252986_(this.pos, -width, topY, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118409_(), sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, width, topY, 0.0f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118410_(), sp.m_118411_());
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, width, topY, -0.2f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118410_(), maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
        builder.m_252986_(this.pos, -width, topY, -0.2f);
        builder.m_85950_(rgba[0], rgba[1], rgba[2], rgba[3]);
        builder.m_7421_(sp.m_118409_(), maxV);
        builder.m_86008_(OverlayTexture.f_118083_);
        builder.m_85969_(packedLight);
        builder.m_5601_(nrm.x(), nrm.y(), nrm.z());
        builder.m_5752_();
    }

    private void renderHeldItems(MultiBufferSource bufferIn) {
        ClientLevel level = this.mc.f_91073_;
        if (this.renderStack.offHandStack != null) {
            this.itemRenderer.m_269128_(this.renderStack.offHand, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, this.renderStack.packedLight, this.renderStack.packedOverlay, this.renderStack.offHandStack, bufferIn, (Level)level, 0);
        }
        if (this.renderStack.mainHandStack != null) {
            this.itemRenderer.m_269128_(this.renderStack.mainHand, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, this.renderStack.packedLight, this.renderStack.packedOverlay, this.renderStack.mainHandStack, bufferIn, (Level)level, 0);
        }
        if (this.renderStack.hatStack != null) {
            this.itemRenderer.m_269128_(this.renderStack.hat, ItemDisplayContext.FIXED, this.renderStack.packedLight, this.renderStack.packedOverlay, this.renderStack.hatStack, bufferIn, (Level)level, 0);
        }
        if (this.renderStack.bannerStack != null) {
            this.itemRenderer.m_269128_(this.renderStack.banner, ItemDisplayContext.FIXED, this.renderStack.packedLight, this.renderStack.packedOverlay, this.renderStack.bannerStack, bufferIn, (Level)level, 0);
        }
        this.renderStack.mainHandStack = null;
        this.renderStack.offHandStack = null;
    }

    private void renderFishingLine(MultiBufferSource bufferSource, Construct construct, float partialTicks, PoseStack poseStack) {
        if (!construct.isFishing()) {
            return;
        }
        if (poseStack == null || construct.getFishingTarget() == null || !construct.m_20183_().m_123314_((Vec3i)construct.getFishingTarget(), 8.0)) {
            return;
        }
        VertexConsumer lineStrips = bufferSource.m_6299_(RenderType.m_173247_());
        float bob = (float)(Math.sin(((float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks) / 20.0f) / 12.0);
        poseStack.m_85836_();
        Vec3 forward = construct.m_20156_().m_82541_();
        Vec3 side = forward.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82490_(construct.f_20912_ == InteractionHand.OFF_HAND ? 0.175 : -0.275);
        Vec3 sourceOffset = new Vec3(0.0, 1.35, 0.0).m_82549_(forward.m_82490_((double)0.94f)).m_82549_(side);
        poseStack.m_85837_(sourceOffset.f_82479_, sourceOffset.f_82480_, sourceOffset.f_82481_);
        Vec3 source = construct.m_20182_().m_82549_(sourceOffset);
        Vec3 target = Vec3.m_82514_((Vec3i)construct.getFishingTarget(), (double)1.0).m_82520_(0.0, (double)bob, 0.0);
        Vec3 delta = target.m_82546_(source);
        PoseStack.Pose lastPose = poseStack.m_85850_();
        for (int k = 0; k <= 16; ++k) {
            ConstructRenderer.stringVertex((float)delta.f_82479_, (float)delta.f_82480_, (float)delta.f_82481_, lineStrips, lastPose, ConstructRenderer.fraction(k, 16), ConstructRenderer.fraction(k + 1, 16));
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(sourceOffset.f_82479_, sourceOffset.f_82480_, sourceOffset.f_82481_);
        poseStack.m_85837_(delta.f_82479_, delta.f_82480_, delta.f_82481_);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = bufferSource.m_6299_(BOBBER_RENDER);
        ConstructRenderer.vertex(vertexconsumer, matrix4f, matrix3f, this.renderStack.packedLight, 0.0f, 0, 0, 1);
        ConstructRenderer.vertex(vertexconsumer, matrix4f, matrix3f, this.renderStack.packedLight, 1.0f, 0, 1, 1);
        ConstructRenderer.vertex(vertexconsumer, matrix4f, matrix3f, this.renderStack.packedLight, 1.0f, 1, 1, 0);
        ConstructRenderer.vertex(vertexconsumer, matrix4f, matrix3f, this.renderStack.packedLight, 0.0f, 1, 0, 0);
        poseStack.m_85849_();
    }

    private static void vertex(VertexConsumer bufferBuilder, Matrix4f pose, Matrix3f normal, int packedLight, float x, int p_114717_, int p_114718_, int p_114719_) {
        bufferBuilder.m_252986_(pose, x - 0.5f, (float)p_114717_ - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)p_114718_, (float)p_114719_).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private static void stringVertex(float deltaX, float deltaY, float deltaZ, VertexConsumer vertexBuffer, PoseStack.Pose pose, float pctFrom, float pctTo) {
        float startX = deltaX * pctFrom;
        float startY = deltaY * (pctFrom * pctFrom + pctFrom) * 0.5f + 0.25f;
        float startZ = deltaZ * pctFrom;
        Vec3 normal = new Vec3((double)(deltaX * pctTo - startX), (double)(deltaY * (pctTo * pctTo + pctTo) * 0.5f + 0.25f - startY), (double)(deltaZ * pctTo - startZ)).m_82541_();
        vertexBuffer.m_252986_(pose.m_252922_(), startX, startY, startZ).m_6122_(187, 191, 191, 255).m_252939_(pose.m_252943_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    @Override
    public RenderType getRenderType(Construct animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110451_();
    }

    public void renderRecursively(PoseStack stack, Construct animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Optional<ItemConstructPart> TORSO = animatable.getConstructData().getPart(ConstructSlot.TORSO);
        if (bone.getName().equals("RIGHT_GRAB_POINT") && !this.renderStack.offHand.m_41619_()) {
            Optional<ItemConstructPart> rightArm = animatable.getConstructData().getPart(ConstructSlot.RIGHT_ARM);
            boolean rightHandWickerwood = rightArm.isPresent() && rightArm.get().getMaterial().equals(ConstructMaterial.WICKERWOOD);
            stack.m_85836_();
            if (rightHandWickerwood) {
                stack.m_85837_(0.38, 0.2, -0.05);
            } else {
                stack.m_85837_(0.53, 0.23, -0.05);
            }
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            this.renderStack.offHandStack = new PoseStack();
            this.renderStack.offHandStack.f_85834_.add(stack.m_85850_());
            this.renderStack.packedLight = packedLight;
            this.renderStack.packedOverlay = packedOverlay;
            stack.m_85849_();
        } else if (bone.getName().equals("LEFT_GRAB_POINT") && !this.renderStack.mainHand.m_41619_()) {
            Optional<ItemConstructPart> leftArm = animatable.getConstructData().getPart(ConstructSlot.LEFT_ARM);
            boolean leftHandWickerwood = leftArm.isPresent() && leftArm.get().getMaterial().equals(ConstructMaterial.WICKERWOOD);
            stack.m_85836_();
            if (leftHandWickerwood) {
                stack.m_85837_(-0.38, 0.2, -0.05);
            } else {
                stack.m_85837_(-0.53, 0.23, -0.05);
            }
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            this.renderStack.mainHandStack = new PoseStack();
            this.renderStack.mainHandStack.f_85834_.add(stack.m_85850_());
            this.renderStack.packedLight = packedLight;
            this.renderStack.packedOverlay = packedOverlay;
            stack.m_85849_();
        } else if (bone.getName().equals("MANA_TORSO_GAUGE_POS") && TORSO.isPresent() && TORSO.get() instanceof ConstructPartManaTorso) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.35f, 0.51f);
            if (TORSO.get().getMaterial() == ConstructMaterial.BONE) {
                stack.m_85837_(0.0, 0.0, -0.166);
            }
            this.normal = stack.m_85850_().m_252943_();
            this.pos = stack.m_85850_().m_252922_();
            stack.m_85849_();
        } else if (bone.getName().equals("TANK_TORSO_FLUID_POS") && TORSO.isPresent() && TORSO.get() instanceof ConstructPartTankTorso) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.22f, 0.48f);
            if (TORSO.get().getMaterial() == ConstructMaterial.BONE) {
                stack.m_85837_(0.0, 0.0625, -0.1875);
            }
            this.normal = stack.m_85850_().m_252943_();
            this.pos = stack.m_85850_().m_252922_();
            stack.m_85849_();
        }
        if ((bone.getName().equals("RIGHT_GRAB_POINT") || bone.getName().equals("LEFT_GRAB_POINT")) && animatable.isFishing()) {
            if (animatable.handHasCapability(InteractionHand.MAIN_HAND, ConstructCapability.FISH)) {
                stack.m_85836_();
                this.renderStack.mainHandStack = new PoseStack();
                this.renderStack.mainHandStack.f_85834_.add(stack.m_85850_());
                this.renderStack.packedLight = packedLight;
                this.renderStack.packedOverlay = packedOverlay;
                stack.m_85849_();
            }
            if (animatable.handHasCapability(InteractionHand.OFF_HAND, ConstructCapability.FISH)) {
                stack.m_85836_();
                this.renderStack.mainHandStack = new PoseStack();
                this.renderStack.mainHandStack.f_85834_.add(stack.m_85850_());
                this.renderStack.packedLight = packedLight;
                this.renderStack.packedOverlay = packedOverlay;
                stack.m_85849_();
            }
        }
        ItemStack hatStack = animatable.getConstructData().getHat();
        if (bone.getName().equals("HAT") && !hatStack.m_41619_()) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 1.775f, 0.0f);
            if (hatStack.m_41720_() instanceof BlockItem) {
                stack.m_85837_(0.0, -0.05, 0.0);
                stack.m_85841_(0.5f, 0.5f, 0.5f);
            } else if (hatStack.m_41720_() instanceof ItemConstructPart) {
                stack.m_85837_(0.0, 0.0, 0.125);
                stack.m_85841_(0.5f, 0.5f, 0.5f);
            } else {
                stack.m_85837_(0.0, -0.125, 0.0);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_85841_(0.5f, 0.5f, 0.5f);
            }
            this.renderStack.hatStack = new PoseStack();
            this.renderStack.hatStack.f_85834_.add(stack.m_85850_());
            this.renderStack.packedLight = packedLight;
            this.renderStack.packedOverlay = packedOverlay;
            stack.m_85849_();
        }
        if (bone.getName().equals("BANNER") && !animatable.getConstructData().getBanner().m_41619_()) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 1.35f, 0.25f);
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            stack.m_85841_(1.5f, 1.5f, 1.5f);
            this.renderStack.bannerStack = new PoseStack();
            this.renderStack.bannerStack.f_85834_.add(stack.m_85850_());
            this.renderStack.packedLight = packedLight;
            this.renderStack.packedOverlay = packedOverlay;
            stack.m_85849_();
        }
        ConstructMaterialModel cmm = ConstructModelRegistry.getMaterialModelFor(this.renderStack.matl);
        List<ResourceLocation> bonemodels = cmm.getForBone(bone.getName(), this.renderStack.model, animatable);
        if (!bone.isHidden()) {
            stack.m_85836_();
            RenderUtils.translateMatrixToBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateToPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.rotateMatrixAroundBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.scaleMatrixForBone((PoseStack)stack, (CoreGeoBone)bone);
            RenderUtils.translateAwayFromPivotPoint((PoseStack)stack, (CoreGeoBone)bone);
            bonemodels.forEach(model -> {
                stack.m_85836_();
                ModelUtils.renderEntityModel(buffer, (Level)this.mc.f_91073_, model, stack, packedLight, packedOverlay);
                stack.m_85849_();
            });
            for (GeoBone childBone : bone.getChildBones()) {
                this.renderRecursively(stack, animatable, childBone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
            stack.m_85849_();
        }
    }

    public boolean shouldShowName(Construct entity) {
        if (entity.isAway()) {
            return false;
        }
        return super.m_6512_((Entity)entity);
    }

    protected void renderNameTag(Construct construct, Component name, PoseStack matrixStack, MultiBufferSource buffer, int p_225629_5_) {
        super.m_7649_((Entity)construct, name, matrixStack, buffer, p_225629_5_);
    }

    static {
        model_brb_mining = RLoc.create("construct/common/brb_mining");
        model_brb_adventuring = RLoc.create("construct/common/brb_adventuring");
        model_brb_hunting = RLoc.create("construct/common/brb_hunting");
    }

    private class RenderReferenceStack {
        public ItemStack mainHand = ItemStack.f_41583_;
        public ItemStack offHand = ItemStack.f_41583_;
        public ItemStack hat = ItemStack.f_41583_;
        public ItemStack banner = ItemStack.f_41583_;
        public ConstructModel model;
        public IConstructConstruction data;
        ConstructMaterial matl;
        private PoseStack mainHandStack = null;
        private PoseStack offHandStack = null;
        private PoseStack hatStack = null;
        private PoseStack bannerStack = null;
        private int packedLight;
        private int packedOverlay;

        public RenderReferenceStack(ItemStack mainHand, ItemStack offHand, ItemStack hat, ItemStack banner) {
            this.mainHand = mainHand;
            this.offHand = offHand;
            this.hat = hat;
            this.banner = banner;
        }

        public void setVisibilityMatrix(Construct entity, ConstructMaterial matl) {
            this.matl = matl;
            if (this.model == null || this.data == null || matl == null || entity == null) {
                return;
            }
            this.model.resetMutexVisibility();
            this.model.setActiveMaterial(matl);
            this.model.setOwner(entity.getOwner() != null ? entity.getOwner().m_20148_() : null);
            for (ItemConstructPart part : this.data.getPartsForMaterial(matl)) {
                this.model.setMutexVisibility(part.getSlot(), part.getModelTypeMutex());
            }
        }
    }
}

