/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.ManaAndArtifice;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.SummonUtils;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Deathcap
extends BaseFactionMob<Deathcap>
implements AnimationController.CustomKeyframeHandler<Deathcap> {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(Deathcap.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_FLING = "fling";
    private static final String INSTRUCTION_HEAL = "heal";
    private static final String INSTRUCTION_BURROW_POS = "burrow_position";
    private static final String INSTRUCTION_BURROW_FLING = "burrow_attack";
    private static final String INSTRUCTION_ROOTS_POISON = "roots_attack";
    private static final String INSTRUCTION_SPORE_BURST = "spore_burst";
    private static final int BURROW_CD = 300;
    private static final int HEAL_CD = 1200;
    private static final int ROOTS_CD = 400;
    private static final int SPORES_CD = 400;
    private Entity attackEntity;
    private int burrowCooldown = 0;
    private int rootsCooldown = 0;
    private int healCooldown = 0;
    private int sporesCooldown = 0;
    private Vec3 rootsPos = Vec3.f_82478_;
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean meleeLeftHand = false;
    private boolean isBurrowing = false;
    private boolean isSporeBursting = false;
    private boolean isRooting = false;
    private boolean isHealing = false;

    public Deathcap(EntityType<Deathcap> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
    }

    @Override
    protected void addControllerListeners(AnimationController<Deathcap> controller) {
        controller.transitionLength(2);
        controller.setCustomInstructionKeyframeHandler((AnimationController.CustomKeyframeHandler)this);
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.isActing) {
            if (this.isRooting) {
                builder.thenPlay("animation.mushroom_soldier.roots");
            } else if (this.isBurrowing) {
                builder.thenPlay("animation.mushroom_soldier.burrow");
            } else if (this.isHealing) {
                builder.thenPlay("animation.mushroom_soldier.heal");
            } else if (this.isSporeBursting) {
                builder.thenPlay("animation.mushroom_soldier.spore_burst");
            } else if (this.meleeLeftHand) {
                builder.thenPlay("animation.mushroom_soldier.attack_left");
            } else {
                builder.thenPlay("animation.mushroom_soldier.attack_right");
            }
        }
        if (this.m_20184_().m_82553_() > (double)0.05f) {
            if ((Integer)this.f_19804_.m_135370_(TARGET_ID) != -1) {
                builder.thenLoop("animation.mushroom_soldier.run");
            } else {
                builder.thenLoop("animation.mushroom_soldier.walk");
            }
        } else {
            builder.thenLoop("animation.mushroom_soldier.idle");
        }
        return state.setAndContinue(builder);
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11723_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11723_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11902_;
    }

    @Override
    public IFaction getFaction() {
        return Factions.FEY;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isBurrowing && !source.m_269533_(DamageTypeTags.f_268490_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_() != MobEffects.f_19614_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        --this.burrowCooldown;
        --this.healCooldown;
        --this.rootsCooldown;
        --this.sporesCooldown;
    }

    public void m_6710_(LivingEntity pLivingEntity) {
        super.m_6710_(pLivingEntity);
        if (pLivingEntity == null) {
            this.f_19804_.m_135381_(TARGET_ID, (Object)-1);
        } else {
            this.f_19804_.m_135381_(TARGET_ID, (Object)pLivingEntity.m_19879_());
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(1, this, new HealGoal()));
        this.f_21345_.m_25352_(3, (Goal)new FactionTierWrapperGoal(1, this, new SporeBurstGoal()));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(2, this, new BurrowGoal()));
        this.f_21345_.m_25352_(2, (Goal)new FactionTierWrapperGoal(2, this, new RootsGoal()));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_) * 1.25, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.3f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void m_21011_(InteractionHand p_226292_1_, boolean p_226292_2_) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isMeleeAttacking = true;
        this.meleeLeftHand = Math.random() < 0.5;
        this.isActing = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.isMeleeAttacking) {
            return true;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 5, entityIn, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 15, "", this::handleDelayCallback));
        this.isActing = true;
        this.isMeleeAttacking = false;
        ServerMessageDispatcher.sendEntityStateMessage(this);
        this.attackEntity = entityIn;
        return true;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (!this.m_9236_().m_5776_()) {
                this.m_5496_(SFX.Entity.Generic.WOOSH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
            }
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity = (Player)entityIn;
                this.m_21424_(playerentity, this.m_21205_(), playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.2f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    private void m_21424_(Player p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.m_41619_() && !p_233655_3_.m_41619_() && p_233655_2_.m_41720_() instanceof AxeItem && p_233655_3_.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_233655_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                switch (identifier) {
                    case "fling": {
                        entity.m_5997_(0.0, 1.0, 0.0);
                        if (entity instanceof Player) {
                            ((ServerPlayer)entity).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
                        }
                        this.m_5496_(SFX.Entity.Generic.WOOSH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                        break;
                    }
                    case "damage": {
                        this.damageEntity(entity);
                        if (!(entity instanceof LivingEntity)) break;
                        ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1));
                        break;
                    }
                    case "heal": {
                        this.m_5634_(this.m_21233_() * 0.5f);
                        break;
                    }
                    case "burrow_position": {
                        Vec3 pos = entity.m_20182_();
                        if (!(pos.m_82554_(this.m_20182_()) < 64.0)) break;
                        Vec3 newPos = this.m_20182_().m_82546_(pos).m_82541_();
                        this.m_6034_(pos.f_82479_ + newPos.f_82479_, pos.f_82480_ + newPos.f_82480_, pos.f_82481_ + newPos.f_82481_);
                        this.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
                        break;
                    }
                    case "burrow_attack": {
                        Vec3 pos = entity.m_20182_();
                        this.m_5496_(SFX.Spell.Impact.Single.EARTH, 1.0f, (float)((double)0.9f + Math.random() * (double)0.2f));
                        if (!(pos.m_82554_(this.m_20182_()) < 2.0)) break;
                        this.handleDelayCallback(INSTRUCTION_FLING, entity);
                        break;
                    }
                    case "roots_attack": {
                        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.m_9236_(), this.rootsPos.f_82479_, this.rootsPos.f_82480_, this.rootsPos.f_82481_);
                        areaeffectcloud.m_19718_((LivingEntity)this);
                        areaeffectcloud.m_19712_(3.0f);
                        areaeffectcloud.m_19732_(-0.5f);
                        areaeffectcloud.m_19740_(10);
                        areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
                        areaeffectcloud.m_19722_(Potions.f_43584_);
                        this.m_9236_().m_7967_((Entity)areaeffectcloud);
                        break;
                    }
                    case "spore_burst": {
                        this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(3.0), e -> e.m_6084_() && e instanceof LivingEntity && !SummonUtils.isTargetFriendly(e, (LivingEntity)this)).stream().map(e -> (LivingEntity)e).forEach(e -> e.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 2)));
                    }
                }
            } else {
                switch (identifier) {
                    case "heal": {
                        int i;
                        for (i = 0; i < 5; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
                        }
                        for (i = 0; i < 5; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), 0.18, 0.3, 0.03);
                        }
                        break;
                    }
                    case "burrow_position": {
                        BlockPos pos = this.m_20097_();
                        BlockState state = this.m_9236_().m_8055_(pos);
                        for (int i = 0; i < 10; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_() + Math.random(), this.m_20186_() + 0.5, this.m_20189_() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
                        }
                        SoundType soundType = this.m_146900_().m_60827_();
                        this.m_9236_().m_6263_(ManaAndArtifice.instance.proxy.getClientPlayer(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), soundType.m_56775_(), SoundSource.HOSTILE, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                        break;
                    }
                    case "burrow_attack": {
                        BlockPos pos = this.m_20097_();
                        BlockState state = this.m_9236_().m_8055_(pos);
                        for (int i = 0; i < 10; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_() + Math.random(), this.m_20186_() + 0.5, this.m_20189_() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
                        }
                        break;
                    }
                    case "spore_burst": {
                        Vec3 particlePos = this.m_146892_();
                        for (int i = 0; i < 50; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())).setColor(54, 69, 30).setScale((float)((double)0.2f + Math.random() * 0.1)), particlePos.m_7096_(), particlePos.m_7098_() - Math.random(), particlePos.f_82481_, -0.5 + Math.random(), 0.0, -0.5 + Math.random());
                        }
                        break;
                    }
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            this.isActing = false;
            if (this.isBurrowing) {
                this.burrowCooldown = 300;
                this.isBurrowing = false;
            } else if (this.isHealing) {
                this.healCooldown = 1200;
                this.isHealing = false;
            } else if (this.isRooting) {
                this.rootsCooldown = 400;
                this.isRooting = false;
            } else if (this.isSporeBursting) {
                this.sporesCooldown = 400;
                this.isSporeBursting = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    public void handle(CustomInstructionKeyframeEvent<Deathcap> event) {
        if (this.attackEntity == ManaAndArtifice.instance.proxy.getClientPlayer() && event.getKeyframeData().getInstructions().indexOf(INSTRUCTION_FLING) > -1) {
            this.attackEntity.m_5997_(0.0, 1.0, 0.0);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isActing);
        nbt.m_128379_("burrowing", this.isBurrowing);
        nbt.m_128379_("rooting", this.isRooting);
        nbt.m_128379_("healing", this.isHealing);
        nbt.m_128379_("meleeLeftHand", this.meleeLeftHand);
        nbt.m_128379_("sporeBursting", this.isSporeBursting);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isActing = nbt.m_128471_("attacking");
        this.isBurrowing = nbt.m_128471_("burrowing");
        this.isHealing = nbt.m_128471_("healing");
        this.isRooting = nbt.m_128471_("rooting");
        this.meleeLeftHand = nbt.m_128471_("meleeLeftHand");
        this.isSporeBursting = nbt.m_128471_("sporeBursting");
        if (this.m_9236_().m_5776_()) {
            if (this.isHealing) {
                DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_HEAL, 60, (LivingEntity)this, this::handleDelayCallback));
            } else if (this.isBurrowing) {
                DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BURROW_POS, 50, (LivingEntity)this, this::handleDelayCallback));
                DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BURROW_FLING, 75, (LivingEntity)this, this::handleDelayCallback));
            } else if (this.isSporeBursting) {
                DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_SPORE_BURST, 10, (LivingEntity)this, this::handleDelayCallback));
            }
        }
    }

    public class HealGoal
    extends Goal {
        public HealGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Deathcap.this.healCooldown <= 0 && Deathcap.this.m_21223_() < Deathcap.this.m_21233_() * 0.75f && !Deathcap.this.isActing;
        }

        public void m_8056_() {
            Deathcap.this.m_21573_().m_26573_();
            Deathcap.this.isHealing = true;
            Deathcap.this.isActing = true;
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(Deathcap.INSTRUCTION_HEAL, 60, (LivingEntity)Deathcap.this, Deathcap.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 90, "", Deathcap.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(Deathcap.this);
        }

        public boolean m_8045_() {
            return Deathcap.this.isHealing;
        }
    }

    public class SporeBurstGoal
    extends Goal {
        public SporeBurstGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Deathcap.this.sporesCooldown <= 0 && Deathcap.this.m_5448_() != null && Deathcap.this.m_5448_().m_20270_((Entity)Deathcap.this) <= 3.0f && !Deathcap.this.isActing;
        }

        public void m_8056_() {
            Deathcap.this.m_21573_().m_26573_();
            Deathcap.this.isSporeBursting = true;
            Deathcap.this.isActing = true;
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(Deathcap.INSTRUCTION_SPORE_BURST, 10, Deathcap.this.m_5448_(), Deathcap.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 60, "", Deathcap.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(Deathcap.this);
        }

        public boolean m_8045_() {
            return Deathcap.this.isSporeBursting;
        }
    }

    public class BurrowGoal
    extends Goal {
        public BurrowGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Deathcap.this.burrowCooldown <= 0 && Deathcap.this.rootsCooldown > 0 && Deathcap.this.m_20096_() && Deathcap.this.m_9236_().m_46578_(Deathcap.this.m_20183_().m_7495_(), (Entity)Deathcap.this, Direction.UP) && Deathcap.this.m_5448_() != null && Deathcap.this.m_5448_().m_20096_() && Deathcap.this.m_5448_().m_20270_((Entity)Deathcap.this) > 8.0f && !Deathcap.this.isActing;
        }

        public void m_8056_() {
            Deathcap.this.m_21573_().m_26573_();
            Deathcap.this.isBurrowing = true;
            Deathcap.this.isActing = true;
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(Deathcap.INSTRUCTION_BURROW_POS, 65, Deathcap.this.m_5448_(), Deathcap.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(Deathcap.INSTRUCTION_BURROW_FLING, 80, Deathcap.this.m_5448_(), Deathcap.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 90, "", Deathcap.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(Deathcap.this);
        }

        public boolean m_8045_() {
            return Deathcap.this.isBurrowing;
        }
    }

    public class RootsGoal
    extends Goal {
        public RootsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Deathcap.this.rootsCooldown <= 0 && Deathcap.this.m_20096_() && Deathcap.this.m_9236_().m_46578_(Deathcap.this.m_20183_().m_7495_(), (Entity)Deathcap.this, Direction.UP) && Deathcap.this.m_5448_() != null && Deathcap.this.m_5448_().m_20096_() && !Deathcap.this.isActing;
        }

        public void m_8056_() {
            Deathcap.this.m_21573_().m_26573_();
            Deathcap.this.isRooting = true;
            Deathcap.this.isActing = true;
            Deathcap.this.rootsPos = Deathcap.this.m_5448_().m_20182_();
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(Deathcap.INSTRUCTION_ROOTS_POISON, 50, Deathcap.this.m_5448_(), Deathcap.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Deathcap.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 95, "", Deathcap.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(Deathcap.this);
        }

        public boolean m_8045_() {
            return Deathcap.this.isRooting;
        }
    }
}

