/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ConstructPlaceBlock
extends ConstructAITask<ConstructPlaceBlock> {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY};
    private int interactTimer = 20;
    protected BlockPos blockPos;
    protected Direction side;

    public ConstructPlaceBlock(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.blockPos != null && this.side != null;
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        AbstractGolem c = this.getConstructAsEntity();
        if (this.construct.getCarryingHands().length == 0) {
            if (!this.isSuccess()) {
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.place_block_hands_empty", new Object[0]));
            }
            this.exitCode = 1;
            c.f_21345_.m_25363_((Goal)this);
            return;
        }
        if (!c.m_9236_().m_46749_(this.blockPos) || !c.m_9236_().m_46859_(this.blockPos)) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.place_block_not_clear", new Object[0]));
            this.exitCode = 1;
            return;
        }
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, Vec3.m_82512_((Vec3i)this.blockPos));
        this.setMoveTarget(this.blockPos);
        if (this.doMove(8.0f)) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else if (this.interactTimer == 0) {
                InteractionHand[] carrying = this.construct.getCarryingHands(i -> i.m_41720_() instanceof BlockItem);
                if (carrying.length == 0) {
                    this.exitCode = 1;
                    return;
                }
                boolean placed = false;
                String blockTranslated = "";
                for (int i2 = 0; i2 < carrying.length; ++i2) {
                    ItemStack stack = c.m_21120_(carrying[i2]);
                    InteractionResult result = ((BlockItem)stack.m_41720_()).m_40576_(new BlockPlaceContext(this.createFakePlayer(), carrying[i2], stack, new BlockHitResult(new Vec3((double)this.blockPos.m_123341_(), (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_()), this.side, this.blockPos, true)));
                    if (result != InteractionResult.SUCCESS && result != InteractionResult.CONSUME) continue;
                    blockTranslated = this.translate(stack);
                    stack.m_41774_(1);
                    c.m_6674_(carrying[i2]);
                    break;
                }
                if (!placed) {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.place_block_failed", new Object[0]));
                    this.exitCode = 1;
                } else {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.place_block_success", blockTranslated, this.blockPos.m_123341_(), this.blockPos.m_123342_(), this.blockPos.m_123343_()));
                    this.exitCode = 0;
                }
                return;
            }
        }
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.interactTimer = 20;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.PLACE_BLOCK);
    }

    @Override
    public ConstructPlaceBlock duplicate() {
        return new ConstructPlaceBlock(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public void inflateParameters() {
        this.getParameter("place_block.point").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.blockPos = ((ConstructTaskPointParameter)param).getPosition();
                this.side = ((ConstructTaskPointParameter)param).getDirection();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskPointParameter("place_block.point"));
        return parameters;
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public ConstructPlaceBlock copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructPlaceBlock) {
            this.side = ((ConstructPlaceBlock)other).side;
            this.blockPos = ((ConstructPlaceBlock)other).blockPos;
        }
        return this;
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.blockPos != null) {
            nbt.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        }
        if (this.side != null) {
            nbt.m_128405_("direction", this.side.m_122411_());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("blockPos")) {
            this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos"));
        }
        if (nbt.m_128441_("direction")) {
            this.side = Direction.m_122376_((int)nbt.m_128451_("direction"));
        }
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null && this.side != null;
    }
}

