/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructConstruction;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskBooleanParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskFilterParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskIntegerParameter;
import com.mna.api.faction.IFaction;
import com.mna.api.items.DynamicItemFilter;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.items.sorcery.ItemCrystalPhylactery;
import com.mna.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;

public class ConstructHunt
extends ConstructAITask<ConstructHunt> {
    private static final ConstructCapability[] required_capabilities = new ConstructCapability[]{ConstructCapability.CARRY};
    private static final int REQUIRED_LIGHTS_UNDERGROUND = 20;
    private static final int REQUIRED_PERCEPTION_FOR_NO_LIGHTS = 20;
    private static final float REQUIRED_BUOYANCY = 1.0f;
    protected BlockPos blockPos;
    protected Vec3 targetLook;
    private static final int WANDER_DIST = 5;
    protected int waitCount = 0;
    protected boolean isWaiting = false;
    protected int waitTime = 100;
    protected DynamicItemFilter itemFilter = new DynamicItemFilter();
    protected boolean surface;
    protected boolean flying;
    protected boolean swimming;
    protected boolean underground;
    protected int dangerLevel;
    protected List<Pair<EntityType<?>, EntitySource>> aggregatedEntityTypes;
    protected int damageToDeal = 0;

    public ConstructHunt(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (!this.isWaiting) {
            this.setMoveTarget(this.blockPos);
            if (this.doMove()) {
                this.construct.setHunting(true);
                this.waitCount = 0;
                this.targetLook = this.construct.asEntity().m_20156_().m_82541_().m_82490_(-10.0);
                this.isWaiting = true;
            }
        } else {
            ++this.waitCount;
            if (this.waitCount > 40) {
                this.faceBlockPos(this.blockPos.m_7918_((int)this.targetLook.f_82479_, (int)this.targetLook.f_82480_, (int)this.targetLook.f_82481_));
            }
            if (this.waitCount >= this.getWaitTime()) {
                this.construct.resetActions();
                if ((float)this.damageToDeal > this.construct.asEntity().m_21223_()) {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.hunt_death", new Object[0]));
                } else {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.hunt_success", new Object[0]));
                }
                ManaAndArtifice.LOGGER.error("Dealing Damage: " + this.damageToDeal);
                if (this.damageToDeal >= 1 && !this.construct.asEntity().m_6469_(this.construct.asEntity().m_269291_().m_269341_(), (float)this.damageToDeal)) {
                    this.construct.asEntity().m_142687_(Entity.RemovalReason.KILLED);
                }
                this.exitCode = 0;
                return;
            }
            if (this.waitCount == this.getWaitTime() - 30) {
                this.construct.setHunting(false);
                this.rollLoot();
                if ((float)this.damageToDeal > this.construct.asEntity().m_21223_()) {
                    this.construct.setConcerned(100);
                } else {
                    this.construct.setHappy(100);
                }
            }
        }
    }

    @Override
    public void onTaskSet() {
        int count;
        super.onTaskSet();
        this.waitCount = 0;
        this.isWaiting = false;
        AbstractGolem c = this.getConstructAsEntity();
        int rX = (int)c.m_20208_(5.0);
        int rY = (int)c.m_20187_();
        int rZ = (int)c.m_20262_(5.0);
        this.blockPos = new BlockPos(rX, rY, rZ);
        BlockState state = c.m_9236_().m_8055_(this.blockPos);
        for (count = 0; !state.m_60795_() && count < 10; ++count) {
            this.blockPos = this.blockPos.m_7918_(0, 1, 0);
            state = c.m_9236_().m_8055_(this.blockPos);
        }
        for (count = 0; state.m_60795_() && count < 10; ++count) {
            this.blockPos = this.blockPos.m_7918_(0, -1, 0);
            state = c.m_9236_().m_8055_(this.blockPos);
        }
        this.aggregatedEntityTypes = this.aggregateEntityTypes();
        this.damageToDeal = 0;
    }

    private void rollLoot() {
        if (this.aggregatedEntityTypes.size() == 0) {
            this.forceFail();
            this.construct.setConfused(100);
            this.construct.pushDiagnosticMessage(this.translate("mna.constructs.feedback.hunt_no_mobs", new Object[0]), null);
            return;
        }
        IConstructConstruction caps = this.construct.getConstructData();
        int constructIntelligence = caps.calculateIntelligence();
        int constructPerception = caps.calculatePerception();
        int constructArmor = caps.calculateArmor();
        int constructToughness = caps.calculateToughness();
        float constructHealth = this.construct.asEntity().m_21223_();
        float constructMaxHealth = this.construct.asEntity().m_21233_();
        float constructDamage = Math.max(caps.calculateDamage(), caps.calculateRangedDamage());
        int num_encounters = constructPerception / 4;
        ServerLevel world = (ServerLevel)this.construct.asEntity().m_9236_();
        for (int i = 0; i < num_encounters; ++i) {
            Pair<EntityType<?>, EntitySource> encounterMob = this.aggregatedEntityTypes.get((int)(Math.random() * (double)this.aggregatedEntityTypes.size()));
            Entity e = ((EntityType)encounterMob.getFirst()).m_20615_((Level)world);
            if (e instanceof IFactionEnemy) {
                IFaction alliedFaction;
                IPlayerProgression progression;
                IFactionEnemy factionMob = (IFactionEnemy)e;
                if (this.construct.getOwner() != null && (progression = (IPlayerProgression)this.construct.getOwner().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) != null && (alliedFaction = progression.getAlliedFaction()) != null && alliedFaction == factionMob.getFaction()) {
                    float healing = constructMaxHealth * 0.33f;
                    this.damageToDeal = (int)((float)this.damageToDeal - healing);
                    constructHealth += healing;
                    continue;
                }
            }
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
                ItemCrystalPhylactery.addToPhylactery((IItemHandler)this.construct, (EntityType<? extends Mob>)mob.m_6095_(), 1.0f, (Level)world, false);
            }
            List<ItemStack> loot = this.rollMonsterLoot(e, world, constructIntelligence, constructPerception);
            for (int l = 0; l < loot.size(); ++l) {
                ItemStack stack = loot.get(l);
                if (!this.itemFilter.matches(stack)) continue;
                this.insertOrDiscardItem(stack);
            }
            float damage = this.calculateRiskDamage((EntityType)encounterMob.getFirst(), (EntitySource)((Object)encounterMob.getSecond()), constructArmor, constructToughness, constructDamage);
            this.damageToDeal = (int)((float)this.damageToDeal + damage);
            if ((constructHealth -= damage) <= 0.0f || constructIntelligence > 16 && constructHealth <= constructMaxHealth * 0.1f * (float)(this.dangerLevel + 1)) break;
        }
    }

    private List<ItemStack> rollMonsterLoot(Entity e, ServerLevel world, int constructIntelligence, int constructPerception) {
        AbstractGolem c = this.construct.asEntity();
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ResourceLocation resourcelocation = living.m_5743_();
            LootParams.Builder lootparams$builder = new LootParams.Builder(world);
            if ((float)constructIntelligence >= 36.0f && (float)constructPerception >= 28.0f) {
                lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.createFakePlayer());
            }
            lootparams$builder.m_287286_(LootContextParams.f_81457_, (Object)living.m_269291_().m_269425_());
            lootparams$builder.m_287289_(LootContextParams.f_81459_, (Object)c);
            lootparams$builder.m_287289_(LootContextParams.f_81458_, (Object)c);
            lootparams$builder.m_287286_(LootContextParams.f_81455_, (Object)living);
            lootparams$builder.m_287286_(LootContextParams.f_81460_, (Object)c.m_20182_());
            LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
            LootTable loottable = world.m_7654_().m_278653_().m_278676_(resourcelocation);
            return loottable.m_287195_(lootparams);
        }
        return new ArrayList<ItemStack>();
    }

    private float calculateRiskDamage(EntityType<?> entity, EntitySource source, int armor, int toughness, float constructDamage) {
        int difficulty;
        for (difficulty = 0; difficulty < MATags.EntityTypes.Constructs.HUNT_DANGER_LEVELS.length && !MATags.getEntitiesOnTag(MATags.EntityTypes.Constructs.HUNT_DANGER_LEVELS[difficulty]).contains(entity); ++difficulty) {
        }
        float riskDamage = (float)(Math.random() * 5.0 * (double)(difficulty + 1));
        switch (source) {
            case Flying: 
            case Swimming: {
                riskDamage *= 1.5f;
                break;
            }
            case Underground: {
                riskDamage *= 1.5f;
                break;
            }
        }
        float armorFactor = (float)armor / 5.0f;
        float toughnessFactor = (float)armor - riskDamage * 4.0f / (float)(toughness + 8);
        float mitigationFactor = 1.0f - Math.min(20.0f, Math.max(armorFactor, toughnessFactor)) / 25.0f;
        riskDamage *= mitigationFactor;
        float constructDamageOutputMitigation = 1.0f - Math.min(constructDamage, 40.0f) / 50.0f;
        riskDamage *= constructDamageOutputMitigation;
        switch (source) {
            case Flying: {
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.WIND);
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.ARCANE);
                break;
            }
            case Surface: {
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.EARTH);
                break;
            }
            case Swimming: {
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.WATER);
                break;
            }
            case Underground: {
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.EARTH);
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.FIRE);
                riskDamage -= (float)this.construct.getConstructData().getAffinityScore(Affinity.ENDER);
            }
        }
        return Math.max(riskDamage, 0.0f);
    }

    private int getWaitTime() {
        if (!this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.ITEM_STORAGE)) {
            return this.getInteractTime(ConstructCapability.ADVENTURE, 4800);
        }
        return this.getInteractTime(ConstructCapability.ADVENTURE, 9600);
    }

    private ArrayList<Pair<EntityType<?>, EntitySource>> aggregateEntityTypes() {
        ArrayList<Pair<EntityType<?>, EntitySource>> typesFiltered;
        ArrayList types = new ArrayList();
        ServerLevel serverWorld = (ServerLevel)this.construct.asEntity().m_9236_();
        IConstructConstruction caps = this.construct.getConstructData();
        if (this.surface) {
            this.getTagForDimensionAndFlag(serverWorld, "surface").forEach(et -> types.add(new Pair(et, (Object)EntitySource.Surface)));
        }
        if (this.flying && (caps.areCapabilitiesEnabled(ConstructCapability.FLY) || caps.areCapabilitiesEnabled(ConstructCapability.RANGED_ATTACK) || caps.areCapabilitiesEnabled(ConstructCapability.TELEPORT))) {
            this.getTagForDimensionAndFlag(serverWorld, "flying").forEach(et -> types.add(new Pair(et, (Object)EntitySource.Flying)));
        }
        if (this.swimming && (caps.areCapabilitiesEnabled(ConstructCapability.FISH) || caps.calculateBuoyancy() >= 1.0f)) {
            this.getTagForDimensionAndFlag(serverWorld, "swimming").forEach(et -> types.add(new Pair(et, (Object)EntitySource.Flying)));
        }
        if (this.underground && (caps.calculatePerception() >= 20 || this.construct.hasItem(MATags.Items.Constructs.UNDERGROUND_LIGHTS, 20))) {
            this.getTagForDimensionAndFlag(serverWorld, "underground").forEach(et -> types.add(new Pair(et, (Object)EntitySource.Flying)));
        }
        if ((typesFiltered = this.filterTagToRiskLevel(types)).size() == 0) {
            this.construct.setConfused(100);
            this.construct.pushDiagnosticMessage(this.translate("mna.constructs.feedback.hunt_no_mobs", new Object[0]), null);
            this.forceFail();
        }
        if (this.underground && caps.calculatePerception() < 20) {
            InventoryUtilities.consumeByTag((IItemHandler)this.construct, MATags.Items.Constructs.UNDERGROUND_LIGHTS, 20);
        }
        return typesFiltered;
    }

    private List<EntityType<?>> getTagForDimensionAndFlag(ServerLevel level, String flag) {
        ResourceLocation mobsForFlagTag = RLoc.create("constructs/hunt/" + flag + "/" + level.m_46472_().m_135782_().toString().replace(':', '_'));
        if (MATags.doesEntityTagExist(mobsForFlagTag)) {
            return MATags.getEntitiesOnTag(mobsForFlagTag);
        }
        ResourceLocation overworldFallback = RLoc.create("constructs/hunt/" + flag + "/overworld");
        if (MATags.doesEntityTagExist(overworldFallback)) {
            return MATags.getEntitiesOnTag(overworldFallback);
        }
        return new ArrayList();
    }

    private ArrayList<Pair<EntityType<?>, EntitySource>> filterTagToRiskLevel(ArrayList<Pair<EntityType<?>, EntitySource>> originalTag) {
        ArrayList mobsByDangerLevel = new ArrayList();
        for (int i = 0; i < this.dangerLevel; ++i) {
            mobsByDangerLevel.addAll(MATags.getEntitiesOnTag(MATags.EntityTypes.Constructs.HUNT_DANGER_LEVELS[i]));
        }
        return originalTag.stream().filter(et -> mobsByDangerLevel.contains(et.getFirst())).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.HUNT);
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        nbt.m_128379_("surface", this.surface);
        nbt.m_128379_("flying", this.flying);
        nbt.m_128379_("swimming", this.swimming);
        nbt.m_128379_("underground", this.underground);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        this.surface = nbt.m_128471_("surface");
        this.flying = nbt.m_128471_("flying");
        this.swimming = nbt.m_128471_("swimming");
        this.underground = nbt.m_128471_("underground");
    }

    @Override
    public boolean isFullyConfigured() {
        return this.surface || this.flying || this.swimming || this.underground;
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskIntegerParameter("hunt.danger", 1, 5));
        parameters.add(new ConstructTaskBooleanParameter("hunt.surface", true));
        parameters.add(new ConstructTaskBooleanParameter("hunt.underground", false));
        parameters.add(new ConstructTaskBooleanParameter("hunt.swimming", false));
        parameters.add(new ConstructTaskBooleanParameter("hunt.flying", false));
        parameters.add(new ConstructTaskFilterParameter("hunt.items"));
        return parameters;
    }

    @Override
    public void inflateParameters() {
        this.getParameter("hunt.danger").ifPresent(param -> {
            if (param instanceof ConstructTaskIntegerParameter) {
                ConstructTaskIntegerParameter intParam = (ConstructTaskIntegerParameter)param;
                this.dangerLevel = intParam.getValue();
            }
        });
        this.getParameter("hunt.surface").ifPresent(param -> {
            if (param instanceof ConstructTaskBooleanParameter) {
                ConstructTaskBooleanParameter boolParam = (ConstructTaskBooleanParameter)param;
                this.surface = boolParam.getValue();
            }
        });
        this.getParameter("hunt.underground").ifPresent(param -> {
            if (param instanceof ConstructTaskBooleanParameter) {
                ConstructTaskBooleanParameter boolParam = (ConstructTaskBooleanParameter)param;
                this.underground = boolParam.getValue();
            }
        });
        this.getParameter("hunt.swimming").ifPresent(param -> {
            if (param instanceof ConstructTaskBooleanParameter) {
                ConstructTaskBooleanParameter boolParam = (ConstructTaskBooleanParameter)param;
                this.swimming = boolParam.getValue();
            }
        });
        this.getParameter("hunt.flying").ifPresent(param -> {
            if (param instanceof ConstructTaskBooleanParameter) {
                ConstructTaskBooleanParameter boolParam = (ConstructTaskBooleanParameter)param;
                this.flying = boolParam.getValue();
            }
        });
        this.getParameter("hunt.items").ifPresent(param -> {
            if (param instanceof ConstructTaskFilterParameter) {
                ConstructTaskFilterParameter filterParam = (ConstructTaskFilterParameter)param;
                this.itemFilter.copyFrom(filterParam.getValue());
            }
        });
    }

    @Override
    public ConstructHunt copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructHunt) {
            ConstructHunt hunt = (ConstructHunt)other;
            this.surface = hunt.surface;
            this.flying = hunt.flying;
            this.swimming = hunt.swimming;
            this.underground = hunt.underground;
            this.dangerLevel = hunt.dangerLevel;
            this.itemFilter.copyFrom(hunt.itemFilter);
        }
        return this;
    }

    @Override
    public ConstructHunt duplicate() {
        return new ConstructHunt(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return required_capabilities;
    }

    @Override
    public int getRequiredIntelligence() {
        return 16;
    }

    @Override
    public boolean areCapabilitiesMet() {
        if (this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.CARRY)) {
            return true;
        }
        return this.construct.getConstructData().areCapabilitiesEnabled(ConstructCapability.ITEM_STORAGE);
    }

    private static enum EntitySource {
        Surface,
        Underground,
        Flying,
        Swimming;

    }
}

