/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.ConstructBlockAreaTask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskItemStackParameter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ConstructCollectFluid
extends ConstructBlockAreaTask<ConstructCollectFluid> {
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.FLUID_STORE, ConstructCapability.FLUID_DISPENSE};
    private ItemStack fluidStack;

    public ConstructCollectFluid(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.construct.getTankCapacity(1) == this.construct.getStoredFluidAmount()) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.take_fluid_tank_full", new Object[0]));
            this.exitCode = 1;
            return;
        }
        if (!this.findBlockTarget()) {
            return;
        }
        if (this.moveToCurrentTarget()) {
            this.harvest();
        }
    }

    private void harvest() {
        AbstractGolem c = this.getConstructAsEntity();
        BlockState state = c.m_9236_().m_8055_(this.currentTarget);
        FluidState flState = state.m_60819_();
        if (flState == null || !flState.m_76170_()) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.fluid_invalid", this.translate(state), this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_()));
        } else {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.collecting_fluid", this.translate(state), this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_()));
            Fluid fluid = flState.m_76152_();
            int fluidAmt = Math.max(flState.m_76186_(), 1000);
            this.construct.fill(new FluidStack(fluid, fluidAmt), IFluidHandler.FluidAction.EXECUTE);
            if (state.m_60734_() instanceof BucketPickup) {
                BucketPickup bp = (BucketPickup)state.m_60734_();
                bp.m_142598_((LevelAccessor)c.m_9236_(), this.currentTarget, state);
            }
            c.m_9236_().m_142346_((Entity)c, GameEvent.f_157816_, this.currentTarget);
        }
        this.removeBlockTarget(this.currentTarget);
        this.currentTarget = null;
        this.exitCode = 0;
    }

    @Override
    protected boolean isValidBlock(BlockState state, BlockPos pos) {
        return ConstructCollectFluid.blockValid(state);
    }

    public static boolean blockValid(BlockState state) {
        FluidState flState = state.m_60819_();
        if (flState == null) {
            return false;
        }
        return flState.m_76170_();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.interactTimer = this.getInteractTime(ConstructCapability.HARVEST);
    }

    @Override
    public void inflateParameters() {
        super.inflateParameters();
        this.getParameter("collect_fluid.stack").ifPresent(param -> {
            if (param instanceof ConstructTaskItemStackParameter) {
                this.fluidStack = ((ConstructTaskItemStackParameter)param).getStack();
            }
        });
    }

    @Override
    public List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskItemStackParameter("collect_fluid.stack"));
        return parameters;
    }

    @Override
    public ConstructCollectFluid duplicate() {
        return new ConstructCollectFluid(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCollectFluid copyFrom(ConstructAITask<?> other) {
        super.copyFrom((ConstructAITask)other);
        if (other instanceof ConstructCollectFluid) {
            this.fluidStack = ((ConstructCollectFluid)other).fluidStack;
        }
        return this;
    }

    @Override
    protected int getInteractTimer() {
        return this.getInteractTime(ConstructCapability.FLUID_DISPENSE);
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.GATHER_FLUID);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    protected String getAreaIdentifier() {
        return "collect_fluid.area";
    }
}

