/*
 * Decompiled with CFR 0.152.
 */
package com.mna.effects.particles;

import com.mna.ManaAndArtifice;
import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.capabilities.entity.MAPFX;
import com.mna.capabilities.entity.MAPFXProvider;
import com.mna.entities.boss.DemonLord;
import com.mna.particles.types.movers.ParticleOrbitMover;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EffectParticleSpawner {
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        entity.getCapability(MAPFXProvider.MAPFX).ifPresent(pfx -> {
            Vec3 pos;
            int i;
            pfx.requestSync(entity);
            if (pfx.getFlag(entity, MAPFX.Flag.FIRE_SHIELD) || pfx.getFlag(entity, MAPFX.Flag.LIVING_BOMB)) {
                int amount = (int)(entity.m_20206_() * 5.0f);
                MAParticleType type = new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME_ORBIT.get()));
                if (entity instanceof DemonLord) {
                    type.setColor(Affinity.HELLFIRE.getColor()[0], Affinity.HELLFIRE.getColor()[1], Affinity.HELLFIRE.getColor()[2]);
                    type.setScale(0.075f);
                }
                for (int i2 = 0; i2 < amount; ++i2) {
                    world.m_7106_((ParticleOptions)type, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 3.0f * 2.0f) * Math.random(), entity.m_20189_(), (double)0.1f, (double)0.01f + Math.random() * (double)0.02f, 1.0 + Math.random());
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.MANA_SHIELD)) {
                for (i = 0; i < 3; ++i) {
                    double angle = Math.random() * 360.0 / 180.0 * Math.PI;
                    pos = new Vec3(entity.m_20185_() + Math.cos(angle), entity.m_20186_() + 1.9 + Math.random() * 0.2, entity.m_20189_() + Math.sin(angle));
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.BRIARTHORN_BARRIER)) {
                for (i = 0; i < 3; ++i) {
                    double angle = Math.random() * 360.0 / 180.0 * Math.PI;
                    pos = new Vec3(entity.m_20185_() + Math.cos(angle), entity.m_20186_() + 0.9 + Math.random() * 0.2, entity.m_20189_() + Math.sin(angle));
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.EARTH.get())), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.4392157f, 0.2235294133424759, 0.0784313753247261);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.MIST_FORM) && (entity != ManaAndArtifice.instance.proxy.getClientPlayer() || Minecraft.m_91087_().f_91063_.m_109153_().m_90594_())) {
                for (i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.MIST.get())), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), (Math.random() - 0.5) * (double)0.1f, (Math.random() - 0.5) * (double)0.1f, (Math.random() - 0.5) * (double)0.1f);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.AURA_OF_FROST) && !pfx.getFlag(entity, MAPFX.Flag.MIST_FORM)) {
                for (i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())).setMover(new ParticleOrbitMover(entity.m_20185_(), entity.m_20186_() + (double)0.05f, entity.m_20189_(), 0.05f, 0.01f, 1.0 + Math.random() * 2.0)), entity.m_20185_(), entity.m_20186_() + (double)0.05f, entity.m_20189_(), 0.0, Math.random() * (double)0.05f, 0.0);
                }
                for (i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), entity.m_20185_() - 3.0 + Math.random() * 6.0, entity.m_20186_() + (double)0.05f, entity.m_20189_() - 3.0 + Math.random() * 6.0, 0.0, Math.random() * (double)0.01f, 0.0);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.CIRCLE_OF_POWER)) {
                world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_VELOCITY.get())).setMaxAge(5), entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() / 2.0, entity.m_20189_() - 0.5 + Math.random(), 0.0, (double)0.17f, 0.0);
            }
            if (pfx.getFlag(entity, MAPFX.Flag.WIND_WALL)) {
                for (i = 0; i < 10; ++i) {
                    world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.05f).setColor(10, 10, 10), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (double)0.1f, (double)0.04f + Math.random() * (double)0.04f, (double)1.2f);
                }
            }
            if (pfx.getFlag(entity, MAPFX.Flag.SOAKED) && Math.random() < 0.5 && !entity.m_20072_()) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123804_, entity.m_20185_() - 0.5 + Math.random(), entity.m_20186_() + Math.random() * (double)entity.m_20206_(), entity.m_20189_() - 0.5 + Math.random(), 0.0, 0.0, 0.0);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingRenderPre(RenderLivingEvent.Pre<?, ?> event) {
        event.getEntity().getCapability(MAPFXProvider.MAPFX).ifPresent(pfx -> {
            if (pfx.getFlag(event.getEntity(), MAPFX.Flag.CANCEL_RENDER)) {
                event.setCanceled(true);
            }
        });
    }
}

