/*
 * Decompiled with CFR 0.152.
 */
package com.mna.capabilities.chunkdata;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IChunkMagic;
import com.mna.capabilities.chunkdata.ChunkMagic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChunkMagicProvider
implements ICapabilitySerializable<Tag> {
    private static final String KEY_RESIDUAL_MAGIC = "residualMagic";
    private static final String KEY_ELDRIN_POSITIONS = "knownEldrinPositions";
    public static final Capability<IChunkMagic> MAGIC = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkMagic>(){});
    private final LazyOptional<IChunkMagic> holder = LazyOptional.of(ChunkMagic::new);

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return MAGIC.orEmpty(cap, this.holder);
    }

    public Tag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        IChunkMagic resolved = (IChunkMagic)this.holder.resolve().get();
        nbt.m_128350_(KEY_RESIDUAL_MAGIC, resolved.getResidualMagic());
        ListTag positions = new ListTag();
        resolved.getKnownEldrinSuppliers().forEach(pos -> positions.add((Object)LongTag.m_128882_((long)pos)));
        nbt.m_128365_(KEY_ELDRIN_POSITIONS, (Tag)positions);
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            IChunkMagic resolved = (IChunkMagic)this.holder.resolve().get();
            CompoundTag cnbt = (CompoundTag)nbt;
            if (cnbt.m_128441_(KEY_RESIDUAL_MAGIC)) {
                resolved.setResidualMagic(((CompoundTag)nbt).m_128457_(KEY_RESIDUAL_MAGIC));
            }
            if (cnbt.m_128425_(KEY_ELDRIN_POSITIONS, 9)) {
                ListTag positions = cnbt.m_128437_(KEY_ELDRIN_POSITIONS, 4);
                positions.forEach(pos -> resolved.pushKnownEldrinSupplier(BlockPos.m_122022_((long)((LongTag)pos).m_7046_())));
            }
        } else {
            ManaAndArtifice.LOGGER.error("Chunk capability data NBT passed back not an instance of CompoundNBT - save data was NOT loaded!");
        }
    }
}

