/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.worldgen;

import com.mna.api.blocks.IManaweaveNotifiable;
import com.mna.api.blocks.WaterloggableBlockWithOffset;
import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.blocks.BlockInit;
import com.mna.blocks.tileentities.ManaweaveCacheTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.interop.lootr.LootrIntegration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fml.ModList;

public class ManaweaveCacheBlock
extends WaterloggableBlockWithOffset
implements EntityBlock,
IManaweaveNotifiable,
IDontCreateBlockItem {
    public ManaweaveCacheBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60955_().m_155956_(200.0f).m_155954_(200.0f), false, new BlockPos(0, 1, 0), new BlockPos(0, 2, 0));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 10;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ManaweaveCacheTile cache;
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && tile instanceof ManaweaveCacheTile && (cache = (ManaweaveCacheTile)tile).isOpen() && !cache.isBuff()) {
            if (!world.f_46443_) {
                if (ModList.get().isLoaded("lootr")) {
                    LootrIntegration.openCache(cache, (ServerPlayer)player);
                } else {
                    cache.m_59640_(player);
                    player.m_5893_((MenuProvider)cache);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ManaweaveCacheTile(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.MANAWEAVE_CACHE.get() ? (lvl, pos, state1, be) -> ManaweaveCacheTile.Tick(lvl, pos, state1, (ManaweaveCacheTile)be) : null;
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean notify(Level world, BlockPos pos, BlockState state, List<IManaweavePattern> patterns, @Nullable LivingEntity caster) {
        if (!world.f_46443_ && caster instanceof Player) {
            Player player = (Player)caster;
            ManaweaveCacheTile te = (ManaweaveCacheTile)world.m_7702_(pos);
            return te.notifyPattern(player, patterns.get(0).getRegistryId());
        }
        return false;
    }

    @Override
    public void m_6810_(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean drops) {
        if (!oldState.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = world.m_7702_(pos);
            if (blockentity instanceof ManaweaveCacheTile && ((ManaweaveCacheTile)blockentity).isOpen() && !((ManaweaveCacheTile)blockentity).isBuff()) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((ManaweaveCacheTile)blockentity));
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(oldState, world, pos, newState, drops);
        }
    }

    @Override
    protected void m_142387_(Level world, Player player, BlockPos pos, BlockState state) {
        for (int i = 0; i < 20; ++i) {
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)BlockInit.CHIMERITE_ARCANE_STONE_STRAIGHT.get()).m_49966_()), (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.05 * Math.random(), 0.0);
        }
    }
}

