/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.events.GenericProgressionEvent;
import com.mna.api.events.ProgressionEventIDs;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ICanContainSpell;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.tools.MATags;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.items.ItemInit;
import com.mna.items.artifice.charms.ItemContingencyCharm;
import com.mna.items.runes.ItemStoneRune;
import com.mna.items.sorcery.ItemBookOfRote;
import com.mna.spells.crafting.SpellRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TranscriptionTableTile
extends WizardLabTile
implements IEldrinConsumerTile {
    public static final int SLOT_INK = 0;
    public static final int SLOT_LAPIS = 1;
    public static final int SLOT_BOOK = 2;
    public static final int SLOT_INPUT = 3;
    public static final int INVENTORY_SIZE = 4;
    private static final int LAPIS_REQUIRED_PER_TIER = 10;
    private static final int LAPIS_REQUIRED_PER_TIER_RECHARGE = 2;
    private static final int LAPIS_REQUIRED_PER_TIER_GLYPH = 1;
    private static final int INK_REQUIRED_PER_TIER = 1;
    private float ticksRequired = 100.0f;
    private SpellRecipe copyRecipe;
    private PowerStatus powerConsumeStatus = PowerStatus.NOT_REQUESTING;
    private float powerAccumulation = 0.0f;
    private Affinity requiredAffinity = Affinity.UNKNOWN;

    public TranscriptionTableTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public TranscriptionTableTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.TRANSCRIPTION_TABLE.get(), pos, state, 4);
    }

    @Override
    public boolean canActivate(Player player) {
        ItemStack spellSlotItem = this.m_8020_(3);
        ItemStack bookStack = this.m_8020_(2);
        if (bookStack.m_41619_() || !(bookStack.m_41720_() instanceof ICanContainSpell)) {
            return false;
        }
        ISpellDefinition spell = ((ICanContainSpell)bookStack.m_41720_()).getSpell(bookStack, player);
        return this.hasStack(3) && this.hasStack(0) && this.m_8020_(0).m_41773_() + this.getInkRequired() <= this.m_8020_(0).m_41776_() && this.hasStack(1) && this.m_8020_(1).m_41613_() >= this.getLapisRequired(player) && this.hasStack(2) && spellSlotItem.m_41720_() instanceof ICanContainSpell && ((ICanContainSpell)spellSlotItem.m_41720_()).canAcceptSpell(spellSlotItem, spell);
    }

    @Override
    protected boolean canContinue() {
        ItemStack spellSlotItem = this.m_8020_(3);
        ItemStack bookStack = this.m_8020_(2);
        if (bookStack.m_41619_() || !(bookStack.m_41720_() instanceof ICanContainSpell)) {
            return false;
        }
        ISpellDefinition spell = ((ICanContainSpell)bookStack.m_41720_()).getSpell(bookStack, this.getCrafter());
        return this.copyRecipe != null && this.hasStack(3) && this.hasStack(2) && spellSlotItem.m_41720_() instanceof ICanContainSpell && ((ICanContainSpell)spellSlotItem.m_41720_()).canAcceptSpell(spellSlotItem, spell);
    }

    @Override
    public float getPctComplete() {
        return (float)this.getActiveTicks() / this.ticksRequired;
    }

    public int getLapisRequired(@Nullable Player player) {
        ISpellDefinition spell;
        if (this.copyRecipe == null || !this.hasStack(3)) {
            return 0;
        }
        ItemStack inputStack = this.m_8020_(3);
        if (inputStack.m_41720_() instanceof ItemContingencyCharm && this.copyRecipe.isSame(spell = ((ICanContainSpell)inputStack.m_41720_()).getSpell(inputStack, player), false, true, true)) {
            return this.copyRecipe.getTier(this.f_58857_) * 2;
        }
        if (MATags.isItemIn(inputStack.m_41720_(), MATags.Items.STONE_RUNES)) {
            return this.copyRecipe.getTier(this.f_58857_) * 1;
        }
        return this.copyRecipe.getTier(this.f_58857_) * 10;
    }

    public int getInkRequired() {
        if (this.copyRecipe == null || !this.hasStack(3)) {
            return 0;
        }
        return this.copyRecipe.getTier(this.f_58857_) * 1;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(0, 1, 2, 3);
    }

    @Override
    protected void onCraftStart(Player crafter) {
        ItemStack book = this.m_8020_(2);
        if (book.m_41619_() || !(book.m_41720_() instanceof ItemBookOfRote)) {
            this.setInactive();
            return;
        }
        ItemStack input = this.m_8020_(3);
        if (input.m_41619_() || !(input.m_41720_() instanceof ICanContainSpell)) {
            this.setInactive();
            return;
        }
        ItemStack lapis = this.m_8020_(1);
        lapis.m_41774_(this.getLapisRequired(crafter));
        ItemStack ink = this.m_8020_(0);
        if (!this.m_58904_().m_5776_()) {
            ink.m_220157_(this.getInkRequired(), this.f_58857_.f_46441_, (ServerPlayer)crafter);
            if (ink.m_41773_() >= ink.m_41776_()) {
                this.m_6836_(0, ItemStack.f_41583_);
            }
        }
        if (!this.m_58904_().m_5776_()) {
            CompoundTag spellTag = ((ItemBookOfRote)ItemInit.ROTE_BOOK.get()).getSpellCompound(book, crafter);
            this.copyRecipe = SpellRecipe.fromNBT(spellTag);
            if (!this.copyRecipe.isValid()) {
                this.setInactive();
            } else {
                this.requiredAffinity = this.copyRecipe.getHighestAffinity().getShiftAffinity();
            }
        }
    }

    public float getPowerPerTick() {
        return this.m_8020_(3).m_41720_() instanceof ItemStoneRune ? 1.0f : 3.0f;
    }

    @Override
    protected boolean canActiveTick() {
        if (this.copyRecipe == null || !this.copyRecipe.isValid()) {
            if (!this.m_58904_().m_5776_()) {
                this.setInactive();
            }
            return false;
        }
        float amount = this.consume(this.getCrafter(), this.m_58899_(), Vec3.m_82512_((Vec3i)this.m_58899_()), this.requiredAffinity, this.getPowerPerTick());
        this.powerConsumeStatus = this.calculatePowerStatus(this.getPowerPerTick(), amount);
        this.powerAccumulation += Math.max(amount, 0.0f);
        if (this.powerAccumulation < this.getPowerPerTick()) {
            return false;
        }
        this.powerAccumulation = 0.0f;
        return true;
    }

    @Override
    protected void onComplete() {
        Player crafter;
        ItemStack output = this.m_8020_(3).m_41777_();
        if (output.m_41619_()) {
            return;
        }
        output = ((ICanContainSpell)output.m_41720_()).setSpell(output, this.copyRecipe);
        ((ICanContainSpell)output.m_41720_()).setTranscribedSpell(output);
        if (this.m_8020_(2).m_41788_()) {
            output.m_41714_(this.m_8020_(2).m_41786_());
        }
        this.m_6836_(3, output);
        if (this.getCrafter() != null && !this.m_58904_().m_5776_() && (crafter = this.getCrafter()) != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GenericProgressionEvent(crafter, ProgressionEventIDs.TRANSCRIBE_SPELL));
            if (crafter instanceof ServerPlayer) {
                CustomAdvancementTriggers.TRANSCRIBE_SPELL.trigger((ServerPlayer)crafter, this.copyRecipe, output);
            }
        }
        if (!this.m_58904_().m_5776_()) {
            this.m_58904_().m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SFX.Event.Eldrin.DRAW_IN_ITEM, SoundSource.BLOCKS, 1.0f, (float)(0.95 + Math.random() * (double)0.1f));
        }
    }

    @Override
    protected void onDeactivated() {
        this.powerConsumeStatus = PowerStatus.NOT_REQUESTING;
    }

    @Override
    protected CompoundTag getMeta() {
        CompoundTag tag = new CompoundTag();
        if (this.copyRecipe != null) {
            this.copyRecipe.writeToNBT(tag);
        }
        this.writePowerConsumeStatus(this.powerConsumeStatus, tag);
        tag.m_128350_("powerAccum", this.powerAccumulation);
        tag.m_128405_("affinity", this.requiredAffinity.ordinal());
        return tag;
    }

    @Override
    protected void loadMeta(CompoundTag tag) {
        this.copyRecipe = SpellRecipe.fromNBT(tag);
        this.powerConsumeStatus = this.readPowerConsumeStatus(tag);
        if (tag.m_128441_("powerAccum")) {
            this.powerAccumulation = tag.m_128457_("powerAccum");
        }
        if (tag.m_128441_("affinity")) {
            int aff = tag.m_128451_("affinity");
            this.requiredAffinity = Affinity.values()[aff % Affinity.values().length];
        }
    }

    @Override
    public int getXPCost(Player crafter) {
        return 20;
    }

    @Override
    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        HashMap<Affinity, PowerStatus> reqs = new HashMap<Affinity, PowerStatus>();
        reqs.put(this.requiredAffinity, this.powerConsumeStatus);
        return reqs;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends WizardLabTile> state) {
        if (this.isActive()) {
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.laboratory_transcription_armature.active"));
        }
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.laboratory_transcription_armature.idle"));
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 3};
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        if (index == 3) {
            return direction == Direction.UP || direction == Direction.DOWN;
        }
        return true;
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (this.isActive()) {
            return false;
        }
        ItemStack existing = this.m_8020_(index);
        switch (index) {
            case 0: {
                return stack.m_41720_() == ItemInit.ARCANIST_INK.get() && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
            case 1: {
                return stack.m_41720_() == Items.f_42534_ && (existing.m_41619_() || existing.m_41613_() < existing.m_41741_());
            }
            case 3: {
                ICanContainSpell inter;
                Item item = stack.m_41720_();
                return item instanceof ICanContainSpell && (inter = (ICanContainSpell)item).canAcceptSpell(stack, this.copyRecipe) && existing.m_41619_();
            }
        }
        return false;
    }
}

