/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.wizard_lab;

import com.mna.Registries;
import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.IEldrinConsumerTile;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.capabilities.IPlayerRoteSpells;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.blocks.tileentities.wizard_lab.ISelectSpellComponents;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import com.mna.capabilities.playerdata.rote.PlayerRoteSpellsProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class SpellSpecializationTile
extends WizardLabTile
implements IEldrinConsumerTile,
ISelectSpellComponents {
    public static final int INVENTORY_SIZE = 0;
    private ISpellComponent selectedPart;
    private float ticksRequired = 3600.0f;
    private float powerPerTick = 10.0f;
    private float powerAccum = 0.0f;
    private PowerStatus powerConsumeStatus = PowerStatus.NOT_REQUESTING;

    public SpellSpecializationTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize) {
        super(type, pos, state, inventorySize);
    }

    public SpellSpecializationTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.SPELL_SPECIALIZAITON.get(), pos, state, 0);
    }

    @Override
    public boolean canActivate(Player player) {
        if (this.selectedPart == null) {
            return false;
        }
        LazyOptional rote = player.getCapability(PlayerRoteSpellsProvider.ROTE);
        if (!rote.isPresent()) {
            return false;
        }
        return !(((IPlayerRoteSpells)rote.resolve().get()).getMastery(this.selectedPart) >= 0.5f);
    }

    @Override
    protected boolean canContinue() {
        return this.selectedPart != null;
    }

    @Override
    public float getPctComplete() {
        return (float)this.getActiveTicks() / this.ticksRequired;
    }

    @Override
    protected List<Integer> getSyncedInventorySlots() {
        return Arrays.asList(new Integer[0]);
    }

    @Override
    protected boolean canActiveTick() {
        if (this.getCrafter() == null) {
            return false;
        }
        Affinity aff = this.getSelectedAffinity();
        float amount = this.consume(this.getCrafter(), this.m_58899_(), Vec3.m_82512_((Vec3i)this.m_58899_()), aff, this.powerPerTick);
        this.powerConsumeStatus = this.calculatePowerStatus(this.powerPerTick, amount);
        this.powerAccum += Math.max(amount, 0.0f);
        if (this.powerAccum >= this.powerPerTick) {
            this.powerAccum = 0.0f;
            return true;
        }
        return false;
    }

    public Affinity getSelectedAffinity() {
        return this.selectedPart instanceof SpellEffect ? ((SpellEffect)this.selectedPart).getAffinity().getShiftAffinity() : Affinity.ARCANE;
    }

    @Override
    public ISpellComponent getSpellComponent() {
        return this.selectedPart;
    }

    @Override
    public void setSpellComponent(ISpellComponent part) {
        this.selectedPart = part;
    }

    @Override
    protected CompoundTag getMeta() {
        CompoundTag tag = new CompoundTag();
        if (this.selectedPart != null) {
            tag.m_128359_("part", this.selectedPart.getRegistryName().toString());
        }
        this.writePowerConsumeStatus(this.powerConsumeStatus, tag);
        tag.m_128350_("accum", this.powerAccum);
        return tag;
    }

    @Override
    protected void loadMeta(CompoundTag tag) {
        this.powerConsumeStatus = this.readPowerConsumeStatus(tag);
        if (tag.m_128441_("accum")) {
            this.powerAccum = tag.m_128457_("accum");
        }
        this.selectedPart = null;
        if (tag.m_128441_("part")) {
            ResourceLocation part = new ResourceLocation(tag.m_128461_("part"));
            if (Registries.Shape.get().containsKey(part)) {
                this.selectedPart = (ISpellComponent)Registries.Shape.get().getValue(part);
            } else if (Registries.SpellEffect.get().containsKey(part)) {
                this.selectedPart = (ISpellComponent)Registries.SpellEffect.get().getValue(part);
            } else if (Registries.Modifier.get().containsKey(part)) {
                this.selectedPart = (ISpellComponent)Registries.Modifier.get().getValue(part);
            }
        }
    }

    @Override
    protected void onComplete() {
        this.powerConsumeStatus = PowerStatus.NOT_REQUESTING;
        Player craft = this.getCrafter();
        if (craft == null) {
            return;
        }
        craft.getCapability(PlayerRoteSpellsProvider.ROTE).ifPresent(r -> {
            r.addMastery(craft, this.selectedPart, 0.05f);
            if (!craft.m_9236_().m_5776_()) {
                craft.m_213846_((Component)Component.m_237110_((String)"gui.mna.mastery_increased", (Object[])new Object[]{Component.m_237115_((String)this.selectedPart.getRegistryName().toString()).getString(), (int)(r.getMastery(this.selectedPart) * 100.0f)}));
            }
        });
    }

    @Override
    protected void onDeactivated() {
        this.powerConsumeStatus = PowerStatus.NOT_REQUESTING;
    }

    @Override
    public int getXPCost(Player crafter) {
        return 100;
    }

    @Override
    protected void tick() {
        super.tick();
        if (this.m_58904_().m_5776_()) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        if (this.isActive()) {
            Vec3 particleStart;
            Vec3 particleEnd = Vec3.m_82512_((Vec3i)this.m_58899_());
            switch ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                case EAST: {
                    particleStart = new Vec3(-0.4, 0.75, 0.0);
                    particleEnd = particleEnd.m_82520_(0.1, 0.3, 0.0);
                    break;
                }
                case NORTH: {
                    particleStart = new Vec3(0.0, 0.75, 0.4);
                    particleEnd = particleEnd.m_82520_(0.0, 0.3, -0.2);
                    break;
                }
                case WEST: {
                    particleStart = new Vec3(0.4, 0.75, 0.0);
                    particleEnd = particleEnd.m_82520_(-0.1, 0.3, 0.0);
                    break;
                }
                default: {
                    particleStart = new Vec3(0.0, 0.75, -0.4);
                    particleEnd = particleEnd.m_82520_(0.0, 0.3, 0.2);
                }
            }
            this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, particleEnd.f_82479_, particleEnd.f_82480_, particleEnd.f_82481_, particleStart.f_82479_, particleStart.f_82480_, particleStart.f_82481_);
        }
    }

    @Override
    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        HashMap<Affinity, PowerStatus> reqs = new HashMap<Affinity, PowerStatus>();
        reqs.put(this.getSelectedAffinity(), this.powerConsumeStatus);
        return reqs;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends WizardLabTile> state) {
        return state.setAndContinue(RawAnimation.begin().thenLoop("animation.laboratory_mastery_armature.idle"));
    }
}

