/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities.pylon;

import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.pylon.PylonTileBase;
import com.mna.api.items.ChargeableItem;
import com.mna.api.tools.RLoc;
import com.mna.blocks.tileentities.init.TileEntityInit;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.curios.api.CuriosApi;

public class RechargePylonTile
extends PylonTileBase {
    private static final ResourceLocation icon = RLoc.create("textures/gui/pylon/recharge.png");

    public RechargePylonTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public RechargePylonTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TileEntityInit.RECHARGE_PYLON.get(), pPos, pBlockState);
    }

    @Override
    protected HashMap<Affinity, Float> getPowerConsumption() {
        return this.getBlock().getPowerConsumption();
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, RechargePylonTile tile) {
        if (tile.tick()) {
            int n = tile.powerUpTicks;
            Objects.requireNonNull(tile);
            if (n == 60 && level.m_46467_() % 20L == 0L) {
                tile.forAllPlayers(false, p -> {
                    p.m_150109_().f_35975_.forEach(tile::rechargeItem);
                    p.m_150109_().f_35974_.forEach(tile::rechargeItem);
                    p.m_150109_().f_35976_.forEach(tile::rechargeItem);
                    CuriosApi.getCuriosInventory((LivingEntity)p).ifPresent(handler -> handler.findCurios(is -> is.m_41720_() instanceof ChargeableItem).forEach(slotResult -> tile.rechargeItem(slotResult.stack())));
                });
            }
        }
    }

    private void rechargeItem(ItemStack item) {
        Item item2 = item.m_41720_();
        if (item2 instanceof ChargeableItem) {
            ChargeableItem chargeable = (ChargeableItem)item2;
            chargeable.refundMana(item, 50.0f, null);
        }
    }
}

