/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.BlockInit;
import com.mna.blocks.artifice.SlipstreamGeneratorBlock;
import com.mna.blocks.tileentities.init.TileEntityInit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SlipstreamGeneratorTile
extends BlockEntity {
    private ArrayList<Entity> levitatingEntities = new ArrayList();
    private int updateTicks = 1;
    private Direction levitateDir = null;
    private boolean playersOnly = true;
    private AABB bb = null;
    private static final int EFFECT_HEIGHT = 50;
    private static final int MAX_STACK = 5;
    private static final float VELOCITY_SCALE = 0.5999999f;
    private static final float STOP_THRESHOLD = 0.2f;
    private static final float VELOCITY_ADD = 0.2f;
    private static final float PLAYER_VELOCITY_ADD = 0.75f;

    public SlipstreamGeneratorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.SLIPSTREAM_GENERATOR.get(), pos, state);
    }

    private Direction getLevitateDir() {
        if (this.levitateDir == null) {
            BlockState state = this.m_58900_();
            this.levitateDir = state.m_61138_((Property)SlipstreamGeneratorBlock.FACING) ? (Direction)state.m_61143_((Property)SlipstreamGeneratorBlock.FACING) : Direction.UP;
        }
        return this.levitateDir;
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, SlipstreamGeneratorTile tile) {
        if (tile.updateTicks++ > 10) {
            tile.refreshPushAxis();
            tile.refreshEntityList();
            tile.updateTicks = 0;
        }
        if (tile.bb == null) {
            return;
        }
        Iterator<Entity> it = tile.levitatingEntities.iterator();
        while (it.hasNext()) {
            Entity entity = it.next();
            if (entity instanceof Player) {
                if (tile.levitatePlayer((Player)entity, tile.getLevitateDir().m_122434_())) continue;
                it.remove();
                continue;
            }
            if (tile.pushEntity(entity)) continue;
            it.remove();
        }
    }

    private boolean pushEntity(Entity entity) {
        if (!this.entityIsValid(entity)) {
            return false;
        }
        entity.m_20256_(Vec3.f_82478_);
        entity.m_20334_((double)((float)this.getLevitateDir().m_122429_() * 0.2f), (double)((float)this.getLevitateDir().m_122430_() * 0.2f), (double)((float)this.getLevitateDir().m_122431_() * 0.2f));
        return true;
    }

    private boolean levitatePlayer(Player player, Direction.Axis axis) {
        if (!this.entityIsValid((Entity)player)) {
            return false;
        }
        this.slowPlayerDown(player, false);
        if (!player.m_6144_()) {
            if (axis == Direction.Axis.Y) {
                this.levitatePlayerYAxis(player);
            } else {
                this.levitatePlayerHorizontally(player, axis);
            }
        }
        if (this.m_58904_().m_5776_()) {
            this.spawnParticles(player);
        }
        return true;
    }

    private void slowPlayerDown(Player player, boolean xz) {
        double x = player.m_20184_().f_82479_;
        double y = player.m_20184_().f_82480_ * 0.5999999046325684;
        double z = player.m_20184_().f_82481_;
        if (this.getLevitateDir().m_122434_() == Direction.Axis.X) {
            x *= 0.5999999046325684;
        } else if (this.getLevitateDir().m_122434_() == Direction.Axis.Z) {
            z *= 0.5999999046325684;
        }
        player.m_20334_(x, y, z);
        if (Math.abs(player.m_20184_().f_82480_) < (double)0.2f) {
            player.m_5997_(0.0, -player.m_20184_().f_82480_, 0.0);
            player.f_19789_ = 0.0f;
        } else {
            player.f_19789_ -= 1.0f;
        }
        if (this.getLevitateDir().m_122434_() == Direction.Axis.X && Math.abs(player.m_20184_().f_82479_) < (double)0.2f) {
            player.m_5997_(-player.m_20184_().f_82479_, 0.0, 0.0);
        }
        if (this.getLevitateDir().m_122434_() == Direction.Axis.Z && Math.abs(player.m_20184_().f_82481_) < (double)0.2f) {
            player.m_5997_(0.0, 0.0, -player.m_20184_().f_82481_);
        }
    }

    private void levitatePlayerYAxis(Player player) {
        float pitch = player.m_146909_();
        float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
        if (Math.abs(pitch) > 10.0f) {
            player.m_6478_(MoverType.PLAYER, new Vec3(0.0, (double)factor, 0.0));
        }
    }

    private void levitatePlayerHorizontally(Player player, Direction.Axis axis) {
        float factorX = 0.0f;
        float factorZ = 0.0f;
        Vec3 posX = new Vec3(1.0, 0.0, 0.0);
        Vec3 negX = new Vec3(-1.0, 0.0, 0.0);
        Vec3 posZ = new Vec3(0.0, 0.0, 1.0);
        Vec3 negZ = new Vec3(0.0, 0.0, -1.0);
        Vec3 playerH = new Vec3(player.m_20154_().f_82479_, 0.0, player.m_20154_().f_82481_);
        if (axis == Direction.Axis.X) {
            double dotPosX = posX.m_82526_(playerH);
            double dotNegX = negX.m_82526_(playerH);
            if (dotPosX > 0.2) {
                factorX = (float)dotPosX;
            } else if (dotNegX > 0.2) {
                factorX = (float)dotNegX * -1.0f;
            }
            factorX *= 0.75f;
        } else if (axis == Direction.Axis.Z) {
            double dotPosZ = posZ.m_82526_(playerH);
            double dotNegZ = negZ.m_82526_(playerH);
            if (dotPosZ > 0.2) {
                factorZ = (float)dotPosZ;
            } else if (dotNegZ > 0.2) {
                factorZ = (float)dotNegZ * -1.0f;
            }
            factorZ *= 0.75f;
        }
        double deltaY = (double)this.m_58899_().m_123342_() - player.m_20186_() + 0.5;
        float yThreshold = 0.1f;
        if (Math.abs(deltaY) < (double)yThreshold) {
            deltaY = 0.0;
        } else if (deltaY != 0.0) {
            deltaY = (double)yThreshold * Math.signum(deltaY);
        }
        if (Math.abs(factorX) > 0.0f || Math.abs(factorZ) > 0.0f || deltaY > 0.0) {
            player.m_6478_(MoverType.PLAYER, new Vec3((double)factorX, deltaY, (double)factorZ));
        }
    }

    private void spawnParticles(Player player) {
        float pitch = player.m_146909_();
        float factor = (pitch > 0.0f ? pitch - 10.0f : pitch + 10.0f) / -180.0f;
        if (player.m_6144_()) {
            factor = 0.01f;
        }
        for (int i = 0; i < 5; ++i) {
            this.m_58904_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), player.m_20185_(), player.m_6144_() ? player.m_20186_() : player.m_20186_() + (double)factor + Math.random() * (double)player.m_20206_(), player.m_20189_(), (double)0.1f, (double)factor, 1.0);
        }
    }

    private boolean entityIsValid(Entity player) {
        if (player == null || !player.m_6084_()) {
            return false;
        }
        Vec3 myPos = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        if (player.m_20191_().m_82381_(this.bb)) {
            BlockHitResult result = this.f_58857_.m_45547_(new ClipContext(player.m_20299_(0.0f), myPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, player));
            if (result.m_6662_() == HitResult.Type.MISS) {
                return true;
            }
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                return result.m_82425_().equals((Object)this.m_58899_());
            }
        }
        return false;
    }

    private void refreshEntityList() {
        this.levitatingEntities.clear();
        if (this.bb == null) {
            return;
        }
        if (this.playersOnly) {
            this.levitatingEntities.addAll(this.m_58904_().m_6907_().stream().filter(p -> this.entityIsValid((Entity)p) && !this.levitatingEntities.contains(p)).collect(Collectors.toList()));
        } else {
            this.levitatingEntities.addAll(this.m_58904_().m_45976_(Entity.class, this.bb));
        }
    }

    private void refreshPushAxis() {
        this.bb = null;
        int axisStacks = this.countStacksAlongAxis(this.getLevitateDir().m_122424_());
        BlockPos bbOffset = this.m_58899_().m_5484_(this.getLevitateDir(), (axisStacks + 1) * 50);
        this.bb = new AABB(this.m_58899_(), bbOffset.m_7918_(this.getLevitateDir().m_122429_() == 0 ? 1 : 0, this.getLevitateDir().m_122430_() == 0 ? 1 : 0, this.getLevitateDir().m_122431_() == 0 ? 1 : 0));
    }

    private int countStacksAlongAxis(Direction axis) {
        int count = 0;
        BlockPos checkPos = this.m_58899_().m_121955_(axis.m_122436_());
        while (this.m_58904_().m_8055_(checkPos).m_60734_() == BlockInit.SLIPSTREAM_GENERATOR.get() && count < 5) {
            ++count;
            checkPos = checkPos.m_121955_(axis.m_122436_());
        }
        return count;
    }
}

