/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.items.ChargeableItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.blocks.runeforging.PedestalBlock;
import com.mna.blocks.tileentities.PedestalTile;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.effects.EffectInit;
import com.mna.entities.EntityInit;
import com.mna.entities.constructs.animated.Construct;
import com.mna.entities.sorcery.targeting.SpellSigil;
import com.mna.network.ServerMessageDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ManaCrystalTile
extends BlockEntity
implements GeoBlockEntity {
    private ArrayList<Long> knownPedestalLocations;
    private static final int SCAN_RADIUS = 8;
    private AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ManaCrystalTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.MANA_CRYSTAL.get(), pos, state);
        this.knownPedestalLocations = new ArrayList();
    }

    public static void ServerTick(Level level, BlockPos pos, BlockState state, ManaCrystalTile tile) {
        if (!level.m_5776_()) {
            if (level.m_46467_() % 80L == 0L) {
                tile.addEffectsToPlayers();
                tile.rechargeConstructs();
                tile.scanForPedestals();
            }
            if (level.m_46467_() % 5L == 0L) {
                tile.chargeItems();
            }
            if (level.m_46467_() % 100L == 0L) {
                tile.chargeSigils();
            }
        }
    }

    private void addEffectsToPlayers() {
        double radius = 16.0;
        AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(radius);
        List list = this.m_58904_().m_45976_(Player.class, axisalignedbb);
        Vec3 myPos = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        for (Player playerentity : list) {
            double dist = myPos.m_82554_(playerentity.m_20182_());
            int magnitudeByDist = 4 - (int)Math.floor(dist / 4.0);
            playerentity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MANA_REGEN.get(), 100, magnitudeByDist, true, false, true));
        }
    }

    private void rechargeConstructs() {
        double radius = 16.0;
        AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(radius);
        List list = this.m_58904_().m_45976_(Construct.class, axisalignedbb);
        Vec3 myPos = new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        for (Construct construct : list) {
            if (construct.getManaPct() == 1.0f || !construct.getConstructData().isCapabilityEnabled(ConstructCapability.STORE_MANA)) continue;
            double dist = myPos.m_82554_(construct.m_20182_());
            int magnitudeByDist = 4 - (int)Math.floor(dist / 4.0);
            float manaRestored = magnitudeByDist * 50;
            construct.adjustMana(manaRestored);
            ServerMessageDispatcher.sendParticleSpawn((double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_() + 1, (double)this.f_58858_.m_123343_() + 0.5, construct.m_20185_(), construct.m_20186_() + 0.8, construct.m_20189_(), 0, 32.0f, (ResourceKey<Level>)this.f_58857_.m_46472_(), (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()));
        }
    }

    private void chargeItems() {
        if (this.knownPedestalLocations.size() == 0) {
            return;
        }
        int i = (int)Math.floor(Math.random() * (double)this.knownPedestalLocations.size());
        BlockPos curPos = BlockPos.m_122022_((long)this.knownPedestalLocations.get(i));
        if (!this.m_58904_().m_46749_(curPos)) {
            return;
        }
        BlockState state = this.m_58904_().m_8055_(curPos);
        if (state.m_60734_() instanceof PedestalBlock) {
            ChargeableItem item;
            PedestalTile pedestal;
            ItemStack stack;
            BlockEntity te = this.f_58857_.m_7702_(curPos);
            if (te instanceof PedestalTile && (stack = (pedestal = (PedestalTile)te).m_8020_(0)).m_41720_() instanceof ChargeableItem && (item = (ChargeableItem)stack.m_41720_()).getMana(stack) < item.getMaxMana()) {
                item.refundMana(pedestal.m_8020_(0), 50.0f, null);
                ServerMessageDispatcher.sendParticleSpawn((double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_() + 1, (double)this.f_58858_.m_123343_() + 0.5, (double)curPos.m_123341_() + 0.5, (double)curPos.m_123342_() + 0.9, (double)curPos.m_123343_() + 0.5, 0, 32.0f, (ResourceKey<Level>)this.f_58857_.m_46472_(), (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()));
            }
        } else {
            this.knownPedestalLocations.remove(i--);
        }
    }

    private void chargeSigils() {
        double radius = 16.0;
        AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(radius);
        this.m_58904_().m_142425_((EntityTypeTest)EntityInit.SPELL_RUNE.get(), axisalignedbb, e -> e instanceof SpellSigil && e.isPermanent()).forEach(sigil -> sigil.addCharge());
    }

    private void scanForPedestals() {
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                for (int k = -8; k <= 8; ++k) {
                    long posLong;
                    BlockState state;
                    BlockPos curPos = this.f_58858_.m_7918_(i, j, k);
                    if (!this.m_58904_().m_46749_(curPos) || !((state = this.m_58904_().m_8055_(curPos)).m_60734_() instanceof PedestalBlock) || this.knownPedestalLocations.contains(posLong = curPos.m_121878_())) continue;
                    this.knownPedestalLocations.add(posLong);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.mana_crystal_armature.idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

