/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.tileentities;

import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.blocks.tileentities.init.TileEntityInit;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemSpellBook;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class BookshelfTile
extends TileEntityWithInventory {
    private static List<Item> directDisplayItems = Arrays.asList((Item)ItemInit.GUIDE_BOOK.get(), (Item)ItemInit.SPELL_BOOK.get(), (Item)ItemInit.GRIMOIRE.get(), (Item)ItemInit.GRIMOIRE_COUNCIL.get(), (Item)ItemInit.GRIMOIRE_DEMON.get(), (Item)ItemInit.GRIMOIRE_UNDEAD.get(), (Item)ItemInit.GRIMOIRE_FEY.get(), (Item)ItemInit.BOOK_MARKS.get(), (Item)ItemInit.FLAT_LANDS_BOOK.get(), (Item)ItemInit.MODIFIER_BOOK.get(), (Item)ItemInit.ROTE_BOOK.get(), (Item)ItemInit.RECIPE_COPY_BOOK.get());
    private ItemStack[] displayItems = new ItemStack[15];

    public BookshelfTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.BOOKSHELF.get(), pos, state, 15);
        for (int i = 0; i < 15; ++i) {
            this.displayItems[i] = ItemStack.f_41583_;
        }
    }

    private void refreshDisplayItems(ArrayList<ResourceLocation> items, ArrayList<Integer> colors) {
        for (int i = 0; i < 15; ++i) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(items.get(i));
            int color = colors.get(i);
            if (item == null || item == Items.f_41852_) {
                this.displayItems[i] = ItemStack.f_41583_;
                continue;
            }
            if (directDisplayItems.contains(item)) {
                this.displayItems[i] = new ItemStack((ItemLike)item);
                if (color <= -1 || !(item instanceof DyeableLeatherItem)) continue;
                ((DyeableLeatherItem)item).m_41115_(this.displayItems[i], color);
                continue;
            }
            this.displayItems[i] = new ItemStack((ItemLike)ItemInit.SPELL_BOOK.get());
            ((ItemSpellBook)ItemInit.SPELL_BOOK.get()).m_41115_(this.displayItems[i], color > -1 ? color : this.resourceLocationToColor(items.get(i)));
        }
    }

    private int resourceLocationToColor(ResourceLocation rLoc) {
        return rLoc.toString().hashCode();
    }

    public ItemStack getDisplayItem(int index) {
        return this.displayItems[index % this.displayItems.length];
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        ListTag items = new ListTag();
        for (int i = 0; i < 15; ++i) {
            CompoundTag item = new CompoundTag();
            int color = -1;
            if (this.m_8020_(i).m_41720_() instanceof DyeableLeatherItem) {
                color = ((DyeableLeatherItem)this.m_8020_(i).m_41720_()).m_41121_(this.m_8020_(i));
            }
            item.m_128359_("rLoc", ForgeRegistries.ITEMS.getKey((Object)this.m_8020_(i).m_41720_()).toString());
            if (color > -1) {
                item.m_128405_("color", color);
            }
            items.add((Object)item);
        }
        tag.m_128365_("displayItems", (Tag)items);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.parseItemsList(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag compoundtag = pkt.m_131708_();
        if (compoundtag != null) {
            this.parseItemsList(compoundtag);
        }
    }

    private void parseItemsList(CompoundTag tag) {
        if (tag.m_128441_("displayItems")) {
            ListTag items = tag.m_128437_("displayItems", 10);
            ArrayList<ResourceLocation> rLocs = new ArrayList<ResourceLocation>();
            ArrayList<Integer> colors = new ArrayList<Integer>();
            items.forEach(i -> {
                CompoundTag item = (CompoundTag)i;
                rLocs.add(new ResourceLocation(item.m_128461_("rLoc")));
                if (item.m_128441_("color")) {
                    colors.add(item.m_128451_("color"));
                } else {
                    colors.add(-1);
                }
            });
            this.refreshDisplayItems(rLocs, colors);
        }
    }

    @Override
    public int[] m_7071_(Direction side) {
        int[] items = new int[this.m_6643_()];
        for (int i = 0; i < this.m_6643_(); ++i) {
            items[i] = i;
        }
        return items;
    }

    @Override
    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return true;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82363_(0.0, 1.0, 0.0);
    }
}

