/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.runeforging;

import com.mna.api.blocks.WizardLabBlock;
import com.mna.api.blocks.interfaces.ICutoutBlock;
import com.mna.api.tools.BlockUtilities;
import com.mna.blocks.tileentities.wizard_lab.RunescribingTableTile;
import com.mna.items.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RunescribingTableBlock
extends WizardLabBlock
implements ICutoutBlock,
EntityBlock {
    public static final BooleanProperty HAS_CHISEL = BooleanProperty.m_61465_((String)"has_chisel");
    public static final BooleanProperty HAS_HAMMER = BooleanProperty.m_61465_((String)"has_hammer");
    private static final VoxelShape CHISEL = Block.m_49796_((double)9.0, (double)1.25, (double)13.0, (double)10.0, (double)8.5, (double)14.0);
    private static final VoxelShape HAMMER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)1.25, (double)13.0, (double)7.0, (double)6.0, (double)14.0), (VoxelShape)Block.m_49796_((double)5.0, (double)6.0, (double)12.5, (double)8.0, (double)7.5, (double)14.5));
    private static final VoxelShape OFFSET_SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)14.0, (double)0.5, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)8.0, (double)5.0, (double)1.0, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)5.0, (double)1.0, (double)16.0), Block.m_49796_((double)11.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)1.0, (double)15.0), Block.m_49796_((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)5.0, (double)15.0), Block.m_49796_((double)4.0, (double)0.0, (double)14.0, (double)5.0, (double)5.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)14.0, (double)12.0, (double)5.0, (double)15.0)});
    private static final VoxelShape OFFSET_SHAPE_NORTH_CHISEL = Shapes.m_83110_((VoxelShape)OFFSET_SHAPE_NORTH, (VoxelShape)CHISEL);
    private static final VoxelShape OFFSET_SHAPE_NORTH_HAMMER = Shapes.m_83110_((VoxelShape)OFFSET_SHAPE_NORTH, (VoxelShape)HAMMER);
    private static final VoxelShape OFFSET_SHAPE_NORTH_HAMMER_CHISEL = Shapes.m_83124_((VoxelShape)OFFSET_SHAPE_NORTH, (VoxelShape[])new VoxelShape[]{HAMMER, CHISEL});
    private static final VoxelShape OFFSET_SHAPE_EAST = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, OFFSET_SHAPE_NORTH);
    private static final VoxelShape OFFSET_SHAPE_EAST_CHISEL = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, OFFSET_SHAPE_NORTH_CHISEL);
    private static final VoxelShape OFFSET_SHAPE_EAST_HAMMER = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, OFFSET_SHAPE_NORTH_HAMMER);
    private static final VoxelShape OFFSET_SHAPE_EAST_HAMMER_CHISEL = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.EAST, OFFSET_SHAPE_NORTH_HAMMER_CHISEL);
    private static final VoxelShape OFFSET_SHAPE_SOUTH = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, OFFSET_SHAPE_NORTH);
    private static final VoxelShape OFFSET_SHAPE_SOUTH_CHISEL = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, OFFSET_SHAPE_NORTH_CHISEL);
    private static final VoxelShape OFFSET_SHAPE_SOUTH_HAMMER = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, OFFSET_SHAPE_NORTH_HAMMER);
    private static final VoxelShape OFFSET_SHAPE_SOUTH_HAMMER_CHISEL = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.SOUTH, OFFSET_SHAPE_NORTH_HAMMER_CHISEL);
    private static final VoxelShape OFFSET_SHAPE_WEST = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, OFFSET_SHAPE_NORTH);
    private static final VoxelShape OFFSET_SHAPE_WEST_CHISEL = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, OFFSET_SHAPE_NORTH_CHISEL);
    private static final VoxelShape OFFSET_SHAPE_WEST_HAMMER = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, OFFSET_SHAPE_NORTH_HAMMER);
    private static final VoxelShape OFFSET_SHAPE_WEST_HAMMER_CHISEL = BlockUtilities.rotateVoxelShape(Direction.NORTH, Direction.WEST, OFFSET_SHAPE_NORTH_HAMMER_CHISEL);

    public RunescribingTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60955_(), new BlockPos(0, 1, 0));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HAS_CHISEL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_HAMMER, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HAS_CHISEL});
        builder.m_61104_(new Property[]{HAS_HAMMER});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RunescribingTableTile(pos, state);
    }

    @Override
    protected MenuProvider getProvider(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity workbench = level.m_7702_(pos);
        if (workbench != null && workbench instanceof RunescribingTableTile) {
            return (RunescribingTableTile)workbench;
        }
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        if (player.m_6047_()) {
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            ItemStack activeStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offhandStack = player.m_21120_(InteractionHand.OFF_HAND);
            BlockEntity be = worldIn.m_7702_(pos);
            if (be != null && be instanceof RunescribingTableTile) {
                RunescribingTableTile tile = (RunescribingTableTile)be;
                ItemStack hammerStack = tile.m_8020_(0);
                if (hammerStack.m_41619_()) {
                    if (activeStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get()) {
                        tile.m_6836_(0, activeStack.m_41777_());
                        activeStack.m_41774_(1);
                        return InteractionResult.SUCCESS;
                    }
                    if (offhandStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get()) {
                        tile.m_6836_(0, offhandStack.m_41777_());
                        offhandStack.m_41774_(1);
                        return InteractionResult.SUCCESS;
                    }
                } else if (hammerStack.m_41720_() == ItemInit.RUNESMITH_HAMMER.get()) {
                    tile.m_6836_(0, ItemStack.f_41583_);
                    if (!player.m_36356_(hammerStack.m_41777_())) {
                        player.m_36176_(hammerStack.m_41777_(), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, p_225533_6_);
    }

    @Override
    public VoxelShape getOffsetShape(BlockPos delta, BlockState parentState, BlockPos parentPos, BlockGetter pLevel, CollisionContext pContext) {
        Direction dir = (Direction)parentState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        boolean hasHammer = (Boolean)parentState.m_61143_((Property)HAS_HAMMER);
        boolean hasChisel = (Boolean)parentState.m_61143_((Property)HAS_CHISEL);
        switch (dir) {
            case EAST: {
                if (hasHammer != hasChisel) {
                    return hasHammer ? OFFSET_SHAPE_EAST_HAMMER : OFFSET_SHAPE_EAST_CHISEL;
                }
                return hasHammer ? OFFSET_SHAPE_EAST_HAMMER_CHISEL : OFFSET_SHAPE_EAST;
            }
            case NORTH: {
                if (hasHammer != hasChisel) {
                    return hasHammer ? OFFSET_SHAPE_NORTH_HAMMER : OFFSET_SHAPE_NORTH_CHISEL;
                }
                return hasHammer ? OFFSET_SHAPE_NORTH_HAMMER_CHISEL : OFFSET_SHAPE_NORTH;
            }
            case SOUTH: {
                if (hasHammer != hasChisel) {
                    return hasHammer ? OFFSET_SHAPE_SOUTH_HAMMER : OFFSET_SHAPE_SOUTH_CHISEL;
                }
                return hasHammer ? OFFSET_SHAPE_SOUTH_HAMMER_CHISEL : OFFSET_SHAPE_SOUTH;
            }
            case WEST: {
                if (hasHammer != hasChisel) {
                    return hasHammer ? OFFSET_SHAPE_WEST_HAMMER : OFFSET_SHAPE_WEST_CHISEL;
                }
                return hasHammer ? OFFSET_SHAPE_WEST_HAMMER_CHISEL : OFFSET_SHAPE_WEST;
            }
        }
        return Shapes.m_83144_();
    }
}

