/*
 * Decompiled with CFR 0.152.
 */
package com.mna.blocks.ritual;

import com.mna.api.blocks.WaterloggableBlock;
import com.mna.api.blocks.interfaces.IDontCreateBlockItem;
import com.mna.api.blocks.interfaces.ITranslucentBlock;
import com.mna.api.rituals.IRitualReagent;
import com.mna.api.tools.MATags;
import com.mna.blocks.tileentities.ChalkRuneTile;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.Ritual;
import com.mna.items.filters.ItemFilterGroup;
import com.mna.tools.DidYouKnowHelper;
import com.mna.tools.InventoryUtilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChalkRuneBlock
extends WaterloggableBlock
implements ITranslucentBlock,
IDontCreateBlockItem,
EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.05, (double)16.0);
    public static final BooleanProperty ACTIVATED = BooleanProperty.m_61465_((String)"activated");
    public static final BooleanProperty METAL = BooleanProperty.m_61465_((String)"metal");
    public static final IntegerProperty RUNEINDEX = IntegerProperty.m_61631_((String)"rune", (int)0, (int)15);
    private int heldItemActivateCount = 0;
    private long lastActivateTime = 0L;

    public ChalkRuneBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283930_).m_60978_(0.1f).m_60910_().m_60955_().m_60918_(SoundType.f_56745_), false);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)METAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RUNEINDEX, (Comparable)Integer.valueOf((int)Math.random() * 15)));
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.OPEN;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        BlockItem blockItem;
        Item item;
        if (((Boolean)pState.m_61143_((Property)METAL)).booleanValue() && (item = pUseContext.m_43722_().m_41720_()) instanceof BlockItem && MATags.isBlockIn((blockItem = (BlockItem)item).m_40614_(), MATags.Blocks.SPECTRAL_BLOCKS)) {
            return true;
        }
        return super.m_6864_(pState, pUseContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVATED, RUNEINDEX, METAL});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChalkRuneTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_225533_6_) {
        List rituals;
        ItemStack activeStack = player.m_21120_(handIn);
        if (ItemFilterGroup.GROUND_RUNE_NON_PLACEABLE.anyMatchesFilter(activeStack)) {
            return InteractionResult.PASS;
        }
        if (((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue() && (rituals = worldIn.m_142425_((EntityTypeTest)EntityInit.RITUAL_ENTITY.get(), new AABB(pos).m_82400_(16.0), e -> true)).size() > 0 && rituals.stream().anyMatch(r -> r.getState() != Ritual.RitualState.GUIDING_REAGENT_PLACEMENT)) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            if (!activeStack.m_41619_() && ((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
                if (worldIn.m_46467_() - this.lastActivateTime < 200L) {
                    ++this.heldItemActivateCount;
                    if (this.heldItemActivateCount >= 4) {
                        DidYouKnowHelper.CheckAndShowDidYouKnow(player, "helptip.mna.ritual_empty_hand");
                    }
                } else {
                    this.heldItemActivateCount = 0;
                }
                this.lastActivateTime = worldIn.m_46467_();
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof ChalkRuneTile) {
            ChalkRuneTile tecr = (ChalkRuneTile)tileEntity;
            if (!tecr.m_7983_()) {
                ItemStack stack = tecr.m_8016_(0);
                if (!player.m_36356_(stack)) {
                    player.m_36176_(stack, true);
                }
                worldIn.m_7260_(pos, state, state, 2);
                worldIn.m_46717_(pos, state.m_60734_());
            } else {
                IRitualReagent reagent;
                if (activeStack.m_41619_() && (reagent = this.getReagentFromNearbyRitual(worldIn, pos)) != null) {
                    if (!player.m_7500_()) {
                        activeStack = InventoryUtilities.removeSingleItemFromInventory(reagent.getResourceLocation(), (Container)player.m_150109_());
                    } else {
                        List<Item> possibilities = MATags.smartLookupItem(reagent.getResourceLocation());
                        if (possibilities != null && possibilities.size() > 0) {
                            activeStack = new ItemStack((ItemLike)possibilities.get((int)(Math.random() * (double)possibilities.size())));
                        }
                    }
                }
                if (!activeStack.m_41619_() && tecr.m_7983_()) {
                    ItemStack single = activeStack.m_41777_();
                    single.m_41764_(1);
                    tecr.m_6836_(0, single);
                    worldIn.m_7260_(pos, state, state, 2);
                    worldIn.m_46717_(pos, state.m_60734_());
                    if (!player.m_7500_()) {
                        activeStack.m_41774_(1);
                    }
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private IRitualReagent getReagentFromNearbyRitual(Level world, BlockPos pos) {
        AABB bb = new AABB(pos).m_82400_(5.0);
        List rituals = world.m_45976_(Ritual.class, bb);
        if (rituals == null || rituals.size() != 1) {
            return null;
        }
        return ((Ritual)((Object)rituals.get(0))).getReagentForPosition(pos);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.notifyNearbyRitualsOfRuneDestruction(state, worldIn, pos);
            this.dropInventory(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity != null && tileEntity instanceof ChalkRuneTile && !((ChalkRuneTile)tileEntity).isGhostItem()) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)tileEntity));
        }
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ACTIVATED)).booleanValue()) {
            return 6;
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_ && fromPos.equals((Object)pos.m_7495_()) && !worldIn.m_8055_(fromPos).m_60804_((BlockGetter)worldIn, fromPos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te != null && te instanceof ChalkRuneTile && !((ChalkRuneTile)te).getDisplayedItem().m_41619_()) {
            return 15;
        }
        return 0;
    }

    public void notifyNearbyRitualsOfRuneDestruction(BlockState blockState, Level world, BlockPos pos) {
        if (world.f_46443_) {
            return;
        }
        List rituals = world.m_142425_((EntityTypeTest)EntityInit.RITUAL_ENTITY.get(), new AABB(pos).m_82400_(16.0), e -> true);
        for (Ritual ritual : rituals) {
            ritual.checkForExplosion(false);
        }
    }

    @Override
    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        if (state.m_61138_((Property)METAL) && ((Boolean)state.m_61143_((Property)METAL)).booleanValue()) {
            return super.m_6044_(worldIn, pos, state, fluidIn);
        }
        return true;
    }

    @Override
    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (state.m_61138_((Property)METAL) && !((Boolean)state.m_61143_((Property)METAL)).booleanValue()) {
            worldIn.m_7731_(pos, fluidStateIn.m_76188_(), 3);
            return false;
        }
        return super.m_7361_(worldIn, pos, state, fluidStateIn);
    }
}

